/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mondrian.olap.MondrianServer;
import mondrian.server.monitor.Monitor;
import mondrian.server.monitor.ServerInfo;
import org.saiku.web.rest.resources.MondrianStats;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/statistics")
public class StatisticsResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/mondrian")
    public MondrianStats getMondrianStats() {
        MondrianServer mondrianServer = MondrianServer.forId(null);
        if (mondrianServer != null) {
            MondrianServer.MondrianVersion mv = mondrianServer.getVersion();
            Monitor monitor = mondrianServer.getMonitor();
            ServerInfo server = monitor.getServer();
            int statementCurrentlyOpenCount = server.statementCurrentlyOpenCount();
            int connectionCurrentlyOpenCount = server.connectionCurrentlyOpenCount();
            int sqlStatementCurrentlyOpenCount = server.sqlStatementCurrentlyOpenCount();
            int statementCurrentlyExecutingCount = server.statementCurrentlyExecutingCount();
            float avgCellDimensionality = (float)server.cellCoordinateCount / (float)server.cellCount;
            List connections = monitor.getConnections();
            List statements = monitor.getStatements();
            return new MondrianStats(server, mv, statementCurrentlyOpenCount, connectionCurrentlyOpenCount, sqlStatementCurrentlyOpenCount, statementCurrentlyExecutingCount, avgCellDimensionality, connections, statements);
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/mondrian/server")
    public ServerInfo getMondrianServer() {
        MondrianServer mondrianServer = MondrianServer.forId(null);
        if (mondrianServer != null) {
            MondrianServer.MondrianVersion mv = mondrianServer.getVersion();
            Monitor monitor = mondrianServer.getMonitor();
            ServerInfo server = monitor.getServer();
            return server;
        }
        return null;
    }
}

