/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.saiku.olap.dto.SaikuConnection;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuCubeMetadata;
import org.saiku.olap.dto.SaikuDimension;
import org.saiku.olap.dto.SaikuHierarchy;
import org.saiku.olap.dto.SaikuLevel;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.service.olap.OlapDiscoverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Path(value="/saiku/{username}/discover")
public class OlapDiscoverResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OlapDiscoverService olapDiscoverService;
    private static final Logger log = LoggerFactory.getLogger(OlapDiscoverResource.class);

    public void setOlapDiscoverService(OlapDiscoverService olapds) {
        this.olapDiscoverService = olapds;
    }

    @GET
    @Produces(value={"application/json"})
    public List<SaikuConnection> getConnections() {
        try {
            return this.olapDiscoverService.getAllConnections();
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuConnection>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}")
    public List<SaikuConnection> getConnections(@PathParam(value="connection") String connectionName) {
        try {
            return this.olapDiscoverService.getConnection(connectionName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuConnection>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/refresh")
    public List<SaikuConnection> refreshConnections() {
        try {
            this.olapDiscoverService.refreshAllConnections();
            return this.olapDiscoverService.getAllConnections();
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuConnection>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/refresh")
    public List<SaikuConnection> refreshConnection(@PathParam(value="connection") String connectionName) {
        try {
            this.olapDiscoverService.refreshConnection(connectionName);
            return this.olapDiscoverService.getConnection(connectionName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuConnection>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/metadata")
    public SaikuCubeMetadata getMetadata(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            List dimensions = this.olapDiscoverService.getAllDimensions(cube);
            List measures = this.olapDiscoverService.getMeasures(cube);
            return new SaikuCubeMetadata(dimensions, measures);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new SaikuCubeMetadata(null, null);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/dimensions")
    public List<SaikuDimension> getDimensions(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getAllDimensions(cube);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuDimension>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/dimensions/{dimension}")
    public SaikuDimension getDimension(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName, @PathParam(value="dimension") String dimensionName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getDimension(cube, dimensionName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/dimensions/{dimension}/hierarchies")
    public List<SaikuHierarchy> getDimensionHierarchies(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName, @PathParam(value="dimension") String dimensionName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getAllDimensionHierarchies(cube, dimensionName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuHierarchy>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/dimensions/{dimension}/hierarchies/{hierarchy}/levels")
    public List<SaikuLevel> getHierarchy(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName, @PathParam(value="dimension") String dimensionName, @PathParam(value="hierarchy") String hierarchyName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getAllHierarchyLevels(cube, dimensionName, hierarchyName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuLevel>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/dimensions/{dimension}/hierarchies/{hierarchy}/levels/{level}")
    public List<SaikuMember> getLevelMembers(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName, @PathParam(value="dimension") String dimensionName, @PathParam(value="hierarchy") String hierarchyName, @PathParam(value="level") String levelName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getLevelMembers(cube, dimensionName, hierarchyName, levelName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuMember>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/hierarchies/{hierarchy}/rootmembers")
    public List<SaikuMember> getRootMembers(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName, @PathParam(value="hierarchy") String hierarchyName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getHierarchyRootMembers(cube, hierarchyName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return null;
        }
    }

    @GET
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/hierarchies/")
    @Produces(value={"application/json"})
    public List<SaikuHierarchy> getCubeHierarchies(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getAllHierarchies(cube);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuHierarchy>();
        }
    }

    @GET
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/measures/")
    @Produces(value={"application/json"})
    public List<SaikuMember> getCubeMeasures(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getMeasures(cube);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuMember>();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/member/{member}")
    public SaikuMember getMember(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName, @PathParam(value="member") String memberName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getMember(cube, memberName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{connection}/{catalog}/{schema}/{cube}/member/{member}/children")
    public List<SaikuMember> getMemberChildren(@PathParam(value="connection") String connectionName, @PathParam(value="catalog") String catalogName, @PathParam(value="schema") String schemaName, @PathParam(value="cube") String cubeName, @PathParam(value="member") String memberName) {
        if ("null".equals(schemaName)) {
            schemaName = "";
        }
        SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        try {
            return this.olapDiscoverService.getMemberChildren(cube, memberName);
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuMember>();
        }
    }
}

