/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuDimensionSelection;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SaikuQuery;
import org.saiku.olap.dto.SaikuSelection;
import org.saiku.olap.dto.SaikuTag;
import org.saiku.olap.dto.SaikuTuple;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.service.olap.OlapQueryService;
import org.saiku.service.util.KeyValue;
import org.saiku.service.util.exception.SaikuServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Path(value="/saiku/{username}/tags")
@XmlAccessorType(value=XmlAccessType.NONE)
public class BasicTagRepositoryResource {
    private static final Logger log = LoggerFactory.getLogger(BasicTagRepositoryResource.class);
    private OlapQueryService olapQueryService;
    private FileObject repo;

    public void setPath(String path) throws Exception {
        try {
            FileSystemManager fileSystemManager;
            FileObject fileObject;
            if (!path.endsWith("" + File.separatorChar)) {
                path = path + File.separatorChar;
            }
            if ((fileObject = (fileSystemManager = VFS.getManager()).resolveFile(path)) == null) {
                throw new IOException("File cannot be resolved: " + path);
            }
            if (!fileObject.exists()) {
                throw new IOException("File does not exist: " + path);
            }
            this.repo = fileObject;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Autowired
    public void setOlapQueryService(OlapQueryService olapqs) {
        this.olapQueryService = olapqs;
    }

    @GET
    @Path(value="/{cubeIdentifier}")
    @Produces(value={"application/json"})
    public List<SaikuTag> getSavedTags(@PathParam(value="cubeIdentifier") String cubeIdentifier) {
        ArrayList<SaikuTag> allTags;
        block4: {
            allTags = new ArrayList<SaikuTag>();
            try {
                if (this.repo != null) {
                    File[] files;
                    for (File file : files = new File(this.repo.getName().getPath()).listFiles()) {
                        String filename;
                        if (file.isHidden() || !(filename = file.getName()).endsWith(".tag") || !(filename = filename.substring(0, filename.length() - ".tag".length())).equals(cubeIdentifier)) continue;
                        FileReader fi = new FileReader(file);
                        BufferedReader br = new BufferedReader(fi);
                        ObjectMapper om = new ObjectMapper();
                        om.setVisibilityChecker(om.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
                        List tags = (List)om.readValue(file, TypeFactory.collectionType(ArrayList.class, SaikuTag.class));
                        allTags.addAll(tags);
                    }
                    break block4;
                }
                throw new Exception("repo URL is null");
            }
            catch (Exception e) {
                log.error(this.getClass().getName(), (Throwable)e);
                e.printStackTrace();
            }
        }
        Collections.sort(allTags);
        return allTags;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{cubeIdentifier}/{tagName}")
    public Response.Status deleteTag(@PathParam(value="cubeIdentifier") String cubeIdentifier, @PathParam(value="tagName") String tagName) {
        try {
            if (this.repo != null) {
                File tagFile;
                List<SaikuTag> tags = this.getSavedTags(cubeIdentifier);
                ArrayList<SaikuTag> remove = new ArrayList<SaikuTag>();
                for (SaikuTag tag : tags) {
                    if (!tag.getName().equals(tagName)) continue;
                    remove.add(tag);
                }
                tags.removeAll(remove);
                ObjectMapper om = new ObjectMapper();
                om.setVisibilityChecker(om.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
                String uri = this.repo.getName().getPath();
                if (!uri.endsWith("" + File.separatorChar)) {
                    uri = uri + File.separatorChar;
                }
                if (!cubeIdentifier.endsWith(".tag")) {
                    cubeIdentifier = cubeIdentifier + ".tag";
                }
                if ((tagFile = new File(uri + URLDecoder.decode(cubeIdentifier, "UTF-8"))).exists()) {
                    tagFile.delete();
                } else {
                    tagFile.createNewFile();
                }
                om.writeValue(tagFile, tags);
                return Response.Status.GONE;
            }
            throw new Exception("Cannot delete tag :" + tagName);
        }
        catch (Exception e) {
            log.error("Cannot delete tag (" + tagName + ")", (Throwable)e);
            return Response.Status.NOT_FOUND;
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{cubeIdentifier}/{tagname}")
    public SaikuTag saveTag(@PathParam(value="tagname") String tagName, @PathParam(value="cubeIdentifier") String cubeIdentifier, @FormParam(value="queryname") String queryName, @FormParam(value="positions") String positions) {
        try {
            ArrayList cellPositions = new ArrayList();
            for (String position : positions.split(",")) {
                String[] ps = position.split(":");
                ArrayList<Integer> cellPosition = new ArrayList<Integer>();
                for (String p : ps) {
                    Integer pInt = Integer.parseInt(p);
                    cellPosition.add(pInt);
                }
                cellPositions.add(cellPosition);
            }
            SaikuTag t = this.olapQueryService.createTag(queryName, tagName, cellPositions);
            if (this.repo != null) {
                File tagFile;
                List<SaikuTag> tags = this.getSavedTags(cubeIdentifier);
                if (!cubeIdentifier.endsWith(".tag")) {
                    cubeIdentifier = cubeIdentifier + ".tag";
                }
                ArrayList<SaikuTag> remove = new ArrayList<SaikuTag>();
                for (SaikuTag tag : tags) {
                    if (!tag.getName().equals(tagName)) continue;
                    remove.add(tag);
                }
                tags.removeAll(remove);
                tags.add(t);
                ObjectMapper om = new ObjectMapper();
                om.setVisibilityChecker(om.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
                String uri = this.repo.getName().getPath();
                if (!uri.endsWith("" + File.separatorChar)) {
                    uri = uri + File.separatorChar;
                }
                if ((tagFile = new File(uri + URLDecoder.decode(cubeIdentifier, "UTF-8"))).exists()) {
                    tagFile.delete();
                } else {
                    tagFile.createNewFile();
                }
                om.writeValue(tagFile, tags);
                return t;
            }
        }
        catch (Exception e) {
            log.error("Cannot add tag " + tagName + " for query (" + queryName + ")", (Throwable)e);
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{cubeIdentifier}/{tagName}")
    public SaikuTag getTag(@PathParam(value="cubeIdentifier") String cubeIdentifier, @PathParam(value="tagName") String tagName) {
        try {
            if (this.repo != null) {
                List<SaikuTag> tags = this.getSavedTags(cubeIdentifier);
                for (SaikuTag tag : tags) {
                    if (!tag.getName().equals(tagName)) continue;
                    return tag;
                }
            }
        }
        catch (Exception e) {
            log.error("Cannot get tag " + tagName + " for " + cubeIdentifier, (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"text/csv"})
    @Path(value="/{cubeIdentifier}/{tagName}/export/csv")
    public Response getDrillthroughExport(@PathParam(value="cubeIdentifier") String cubeIdentifier, @PathParam(value="tagName") String tagName, @QueryParam(value="maxrows") @DefaultValue(value="0") Integer maxrows, @QueryParam(value="returns") String returns, @QueryParam(value="connection") String connection, @QueryParam(value="catalog") String catalog, @QueryParam(value="schema") String schema, @QueryParam(value="cube") String cube, @QueryParam(value="additional") String additional) {
        ResultSet rs = null;
        try {
            SaikuTag tag;
            ArrayList<Integer> cellPosition = new ArrayList<Integer>();
            cellPosition.add(0);
            ArrayList<KeyValue> additionalColumns = new ArrayList<KeyValue>();
            if (additional != null) {
                for (String kvs : additional.split(",")) {
                    String[] kv = kvs.split(":");
                    if (kv.length != 2) continue;
                    additionalColumns.add(new KeyValue((Object)kv[0], (Object)kv[1]));
                }
            }
            if ((tag = this.getTag(cubeIdentifier, tagName)) != null) {
                String queryName = UUID.randomUUID().toString();
                SaikuCube saikuCube = new SaikuCube(connection, cube, cube, cube, catalog, schema);
                this.olapQueryService.createNewOlapQuery(queryName, saikuCube);
                SaikuQuery q = this.olapQueryService.simulateTag(queryName, tag);
                if (!cube.startsWith("[")) {
                    cube = "[" + cube + "]";
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                boolean first = true;
                for (SaikuTuple tuple : tag.getSaikuTuples()) {
                    String mdx = null;
                    for (SaikuMember member : tuple.getSaikuMembers()) {
                        if (mdx == null) {
                            mdx = "SELECT (" + member.getUniqueName();
                            continue;
                        }
                        mdx = mdx + ", " + member.getUniqueName();
                    }
                    boolean where = true;
                    if (tag.getSaikuDimensionSelections() != null) {
                        for (SaikuDimensionSelection sdim : tag.getSaikuDimensionSelections()) {
                            if (sdim.getSelections().size() <= 1) continue;
                            where = false;
                        }
                    }
                    if (where) {
                        mdx = mdx + ") ON COLUMNS from " + cube;
                        SelectNode sn = new DefaultMdxParserImpl().parseSelect(q.getMdx());
                        StringWriter writer = new StringWriter();
                        sn.getFilterAxis().unparse(new ParseTreeWriter(new PrintWriter(writer)));
                        if (StringUtils.isNotBlank((String)((Object)writer).toString())) {
                            mdx = mdx + "\r\nWHERE " + ((Object)writer).toString();
                        }
                        System.out.println("Executing... :" + mdx);
                        this.olapQueryService.executeMdx(queryName, mdx);
                        rs = this.olapQueryService.drillthrough(queryName, cellPosition, maxrows, returns);
                        byte[] doc = this.olapQueryService.exportResultSetCsv(rs, ",", "\"", first, additionalColumns);
                        first = false;
                        outputStream.write(doc);
                        continue;
                    }
                    if (tag.getSaikuDimensionSelections() == null) continue;
                    for (SaikuDimensionSelection sdim : tag.getSaikuDimensionSelections()) {
                        for (SaikuSelection ss : sdim.getSelections()) {
                            if (ss.getType() != SaikuSelection.Type.MEMBER) continue;
                            String newmdx = mdx;
                            newmdx = newmdx + "," + ss.getUniqueName() + ") ON COLUMNS from " + cube;
                            System.out.println("Executing... :" + newmdx);
                            this.olapQueryService.executeMdx(queryName, newmdx);
                            rs = this.olapQueryService.drillthrough(queryName, cellPosition, maxrows, returns);
                            byte[] doc = this.olapQueryService.exportResultSetCsv(rs, ",", "\"", first, additionalColumns);
                            first = false;
                            outputStream.write(doc);
                        }
                    }
                }
                byte[] csv = outputStream.toByteArray();
                String name = SaikuProperties.webExportCsvName;
                Response response = Response.ok((Object)csv, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + name + "-drillthrough.csv")).header("content-length", (Object)csv.length).build();
                return response;
            }
        }
        catch (Exception e) {
            log.error("Cannot export drillthrough tag (" + tagName + ")", (Throwable)e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (rs != null) {
                try {
                    try {
                        Statement statement = rs.getStatement();
                        statement.close();
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException e) {
                        throw new SaikuServiceException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    rs = null;
                    throw throwable;
                }
            }
        }
        return Response.serverError().build();
    }
}

