/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaikuProperties
extends Properties {
    private static final long serialVersionUID = 4835692048422342660L;
    private static final Logger log = LoggerFactory.getLogger(SaikuProperties.class);
    private final PropertySource propertySource = new FilePropertySource(new File("saiku.properties"));
    private int populateCount;
    private static SaikuProperties instance = SaikuProperties.instance();
    private static final String SAIKU_PROPERTIES = "saiku.properties";
    public static final Boolean olapDefaultNonEmpty = SaikuProperties.getPropBoolean("saiku.olap.nonempty", "false");
    public static final String webExportCsvName = SaikuProperties.getPropString("saiku.web.export.csv.name", "saiku-export");
    public static final String webExportExcelName = SaikuProperties.getPropString("saiku.web.export.excel.name", "saiku-export");
    public static final String webExportExcelFormat = SaikuProperties.getPropString("saiku.web.export.excel.format", "xlsx");
    public static final String webExportExcelDefaultNumberFormat = SaikuProperties.getPropString("saiku.web.export.excel.numberformat", "#,##0.00");
    public static final String formatDefautNumberFormat = SaikuProperties.getPropString("saiku.format.numberformat", "#,##0.00");
    public static final Locale locale = SaikuProperties.getLocale();

    private static synchronized SaikuProperties instance() {
        if (instance == null) {
            instance = new SaikuProperties();
            instance.populate();
        }
        return instance;
    }

    public void populate() {
        this.loadIfStale(this.propertySource);
        URL url = null;
        File file = new File(SAIKU_PROPERTIES);
        if (file.exists() && file.isFile()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.warn("Saiku: file '" + file.getAbsolutePath() + "' could not be loaded", (Throwable)e);
            }
        } else {
            url = SaikuProperties.class.getClassLoader().getResource(SAIKU_PROPERTIES);
        }
        if (url != null) {
            this.load(new UrlPropertySource(url));
        } else {
            log.warn("saiku.properties can't be found under '" + new File(".").getAbsolutePath() + "' or classloader");
        }
        int count = 0;
        Enumeration<Object> keys = System.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = System.getProperty(key);
            if (!key.startsWith("saiku.")) continue;
            if (log.isDebugEnabled()) {
                log.debug("System property : populate: key=" + key + ", value=" + value);
            }
            instance.setProperty(key, value);
            ++count;
        }
        if (this.populateCount++ == 0) {
            log.info("Saiku: loaded " + count + " system properties");
        }
    }

    private void loadIfStale(PropertySource source) {
        if (source.isStale()) {
            if (log.isDebugEnabled()) {
                log.debug("Saiku: loading " + source.getDescription());
            }
            this.load(source);
        }
    }

    private void load(PropertySource source) {
        try {
            instance.load(source.openStream());
            if (this.populateCount == 0) {
                log.info("Saiku: properties loaded from '" + source.getDescription() + "'");
                instance.list(System.out);
            }
        }
        catch (IOException e) {
            log.error("Saiku: error while loading properties from '" + source.getDescription() + "' (" + e.getMessage() + ")");
        }
    }

    private static Locale getLocale() {
        String locale = null;
        try {
            locale = SaikuProperties.getPropString("saiku.format.default.locale", null);
            if (locale != null) {
                return LocaleUtils.toLocale((String)locale);
            }
        }
        catch (Exception e) {
            log.warn("Property: saiku.format.default.locale with value: " + locale + ", cannot be used for a Locale, falling back to default locale: " + Locale.getDefault(), (Throwable)e);
        }
        return Locale.getDefault();
    }

    private static Boolean getPropBoolean(String key, String defaultValue) {
        Boolean ret = instance.containsKey(key) ? Boolean.valueOf(Boolean.parseBoolean(instance.getProperty(key))) : Boolean.valueOf(Boolean.parseBoolean(defaultValue));
        return ret;
    }

    private static String getPropString(String key, String defaultValue) {
        String ret = instance.containsKey(key) ? instance.getProperty(key) : defaultValue;
        return ret;
    }

    static class UrlPropertySource
    implements PropertySource {
        private final URL url;
        private long lastModified;

        UrlPropertySource(URL url) {
            this.url = url;
        }

        private URLConnection getConnection() {
            try {
                return this.url.openConnection();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while opening properties file '" + this.url + "'", e);
            }
        }

        public InputStream openStream() {
            try {
                URLConnection connection = this.getConnection();
                this.lastModified = connection.getLastModified();
                return connection.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while opening properties file '" + this.url + "'", e);
            }
        }

        public boolean isStale() {
            long lastModified = this.getConnection().getLastModified();
            return lastModified > this.lastModified;
        }

        public String getDescription() {
            return this.url.toExternalForm();
        }
    }

    static class FilePropertySource
    implements PropertySource {
        private final File file;
        private long lastModified;

        FilePropertySource(File file) {
            this.file = file;
            this.lastModified = 0L;
        }

        public InputStream openStream() {
            try {
                this.lastModified = this.file.lastModified();
                FileInputStream in = new FileInputStream(this.file);
                log.info("Opening properties file: '" + this.file + "'");
                return in;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Error while opening properties file: '" + this.file + "'", e);
            }
        }

        public boolean isStale() {
            return this.file.exists() && this.file.lastModified() > this.lastModified;
        }

        public String getDescription() {
            return "file=" + this.file.getAbsolutePath() + " (exists=" + this.file.exists() + ")";
        }
    }

    public static interface PropertySource {
        public InputStream openStream();

        public boolean isStale();

        public String getDescription();
    }
}

