/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.highligher;

import de.statspez.pleditor.ui.highligher.ExpandingArray;
import de.statspez.pleditor.ui.highligher.PLToken;
import de.statspez.pleditor.ui.highligher.PLTokenScanner;
import de.statspez.pleditor.ui.settings.SettingsProvider;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class PLSyntaxDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = -8656031905033093131L;
    private boolean writeProtected;
    private Element root;
    private SimpleAttributeSet[] simpleAttributeSet = new SimpleAttributeSet[10];
    private PLTokenScanner scanner = new PLTokenScanner();
    private ExpandingArray lineTokens = new ExpandingArray(1);
    public static final String[] MISC_SYMBOLS = new String[]{"..", "--", "-+", "+-", "++", ":=", "#", ",", ";", "(", ")", "[", "]", "{", "}", "&", "."};
    public static final String[] OPERATOR_SYMBOLS = new String[]{"/=", "<=", ">=", "*", "/", "+", "-", "=", "<", ">"};
    public static final String[] OPERATOR_KEYWORDS = new String[]{"NICHT", "ODER", "UND", "IN"};
    public static final String[] KEYWORDS = new String[]{"THEMENBEREICH", "WAHRHEITSWERT", "SCHRITTWEITE", "ZEICHENKETTE", "EIGENSCHAFT", "DATUMSWERT", "HOECHSTENS", "MINDESTENS", "WIEDERHOLE", "EXISTIERT", "IDENTISCH", "KATEGORIE", "KOMMAZAHL", "RUECKGABE", "FUNKTION", "GANZZAHL", "MATERIAL", "ABBRUCH", "ELEMENT", "SOLANGE", "VARIANZ", "ABLAUF", "FEHLER", "FALSCH", "ANZAHL", "GLOBAL", "MAPPEN", "MADIAN", "MITTEL", "PRUEFE", "DATUM", "GENAU", "INDEX", "JEDES", "REIHE", "SONST", "STABW", "SUMME", "ALLE", "DANN", "ENDE", "FELD", "FUER", "GILT", "LEER", "NACH", "WAHR", "WENN", "WERT", "ZEIT", "AUS", "BIS", "GIB", "HAT", "IST", "MAX", "MIN", "MIT", "TYP", "VAR", "VON"};

    public PLSyntaxDocument() {
        this.root = this.getDefaultRootElement();
        this.scanner.setKeywords(KEYWORDS);
        this.scanner.setOperatorKeyword(OPERATOR_KEYWORDS);
        this.scanner.setMiscSymbol(MISC_SYMBOLS);
        this.scanner.setOperatorSymbol(OPERATOR_SYMBOLS);
        int i = 0;
        while (i < this.simpleAttributeSet.length) {
            this.simpleAttributeSet[i] = new SimpleAttributeSet();
            ++i;
        }
        this.loadColorProfile();
        this.writeProtected = false;
    }

    public void setWriteProtected(boolean writeProtected) {
        this.writeProtected = writeProtected;
    }

    public boolean isWriteProtected() {
        return this.writeProtected;
    }

    private void highlight(PLToken token) {
        this.setCharacterAttributes(token.getStart(), token.getEnd() - token.getStart() + 1, this.simpleAttributeSet[token.getId()], true);
    }

    private void highlightAffectedText(int scanBegin, int scanEnd, int highlightBegin, int firstLine) {
        PLToken token = null;
        PLToken lastLineToken = null;
        int lastLineIndex = -1;
        boolean endOfText = false;
        int currentPosition = 0;
        this.scanner.setDocument(this);
        this.scanner.setInterval(scanBegin, scanEnd);
        if (firstLine > 0 && this.lineTokens.getItems()[firstLine - 1] != null) {
            PLToken t = (PLToken)this.lineTokens.getItems()[firstLine - 1];
            this.scanner.setState(t.getId(), t.getStart());
        }
        while (true) {
            if (this.scanner.nextToken()) {
                token = this.scanner.getToken();
                currentPosition = this.scanner.getCurrentPos();
                endOfText = this.scanner.endOfText();
                if (currentPosition >= highlightBegin) {
                    this.highlight(token);
                }
                if (token.isMultiline()) {
                    int firstTokenLinePosition = this.root.getElementIndex(token.getStart());
                    int lastTokenLinePosition = this.root.getElementIndex(token.getEnd()) - 1;
                    if (endOfText) {
                        ++lastTokenLinePosition;
                    }
                    this.lineTokens.fill(firstTokenLinePosition, lastTokenLinePosition, new PLToken(token.getId(), token.getStart(), token.getEnd()));
                }
                if (endOfText || !this.scanner.endOfLine()) continue;
                lastLineIndex = this.root.getElementIndex(token.getEnd());
                lastLineToken = (PLToken)this.lineTokens.getItems()[lastLineIndex];
                this.lineTokens.getItems()[lastLineIndex] = null;
                continue;
            }
            if (lastLineToken == null || (endOfText = this.scanner.endOfText())) break;
            this.scanner.setInterval(currentPosition + 1, this.root.getElement(this.root.getElementIndex(lastLineToken.getEnd())).getEndOffset() - 1);
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (!this.writeProtected) {
            super.insertString(offset, str, this.simpleAttributeSet[5]);
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        if (!this.writeProtected) {
            super.remove(offset, length);
        }
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent e) {
        super.fireInsertUpdate(e);
        Element line = this.root.getElement(this.root.getElementIndex(e.getOffset()));
        int scanBegin = line.getStartOffset();
        Element endLine = this.root.getElement(this.root.getElementIndex(scanBegin + e.getLength()));
        int scanEnd = endLine.getEndOffset() - 1;
        int firstLine = this.root.getElementIndex(scanBegin);
        int linesInserted = 0;
        DocumentEvent.ElementChange change = e.getChange(this.root);
        if (change != null && change.getChildrenAdded() != null) {
            linesInserted = change.getChildrenAdded().length;
        }
        if (linesInserted > 0) {
            this.lineTokens.shift(firstLine, linesInserted);
        }
        this.highlightAffectedText(scanBegin, scanEnd, e.getOffset(), firstLine);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent e) {
        super.fireRemoveUpdate(e);
        Element line = this.root.getElement(this.root.getElementIndex(e.getOffset()));
        int scanBegin = line.getStartOffset();
        Element endLine = this.root.getElement(this.root.getElementIndex(scanBegin + e.getLength() - 1));
        int scanEnd = endLine.getEndOffset() - 1;
        int firstLine = this.root.getElementIndex(scanBegin);
        int linesDeleted = 0;
        DocumentEvent.ElementChange change = e.getChange(this.root);
        if (change != null && change.getChildrenRemoved() != null) {
            linesDeleted = change.getChildrenRemoved().length - 1;
        }
        if (linesDeleted > 0) {
            this.lineTokens.unshift(firstLine, linesDeleted);
        }
        this.highlightAffectedText(scanBegin, scanEnd, e.getOffset(), firstLine);
    }

    public void loadColorProfile() {
        StyleConstants.setForeground(this.simpleAttributeSet[0], SettingsProvider.getInstance().getColor("string.color"));
        StyleConstants.setForeground(this.simpleAttributeSet[2], SettingsProvider.getInstance().getColor("comment.color"));
        StyleConstants.setForeground(this.simpleAttributeSet[3], SettingsProvider.getInstance().getColor("keyword.color"));
        StyleConstants.setForeground(this.simpleAttributeSet[4], SettingsProvider.getInstance().getColor("operator.keyword.color"));
        StyleConstants.setForeground(this.simpleAttributeSet[8], SettingsProvider.getInstance().getColor("operator.symbol.color"));
        StyleConstants.setForeground(this.simpleAttributeSet[7], SettingsProvider.getInstance().getColor("misc.symbol.color"));
        StyleConstants.setForeground(this.simpleAttributeSet[6], SettingsProvider.getInstance().getColor("number.color"));
    }

    public void reScan() {
        this.highlightAffectedText(0, this.getLength(), 0, 0);
    }
}

