/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DateParser
extends SubParser {
    private MetaStatspezObjekt currentElement = null;
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private int halfOfYear = 0;
    private int quarterOfYear = 0;
    private int weekOfYear = 0;
    private int dayOfWeek = 0;
    private int dayOfYear = 0;

    public DateParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "date".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("date".equalsIgnoreCase(localName)) {
            this.enable();
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("date".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("year".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.year = Integer.parseInt(chars);
                return handled;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ILParseException("Fehlerhafte Jahrangabe!");
            }
        } else {
            if ("halfOfYear".equalsIgnoreCase(localName)) {
                try {
                    if (chars.length() <= 0) return handled;
                    this.halfOfYear = Integer.parseInt(chars);
                    if (this.halfOfYear < 1) throw new ILParseException("Fehlerhafte Halbjahresangabe!");
                    if (this.halfOfYear <= 2) return handled;
                    throw new ILParseException("Fehlerhafte Halbjahresangabe!");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ILParseException("Fehlerhafte Halbjahresangabe!");
                }
            }
            if ("quarterOfYear".equalsIgnoreCase(localName)) {
                try {
                    if (chars.length() <= 0) return handled;
                    this.quarterOfYear = Integer.parseInt(chars);
                    if (this.quarterOfYear < 1) throw new ILParseException("Fehlerhafter Index des Quartals relativ zum Jahr!");
                    if (this.quarterOfYear <= 4) return handled;
                    throw new ILParseException("Fehlerhafter Index des Quartals relativ zum Jahr!");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ILParseException("Fehlerhafter Index des Quartals relativ zum Jahr!");
                }
            }
            if ("month".equalsIgnoreCase(localName)) {
                try {
                    if (chars.length() <= 0) return handled;
                    this.month = Integer.parseInt(chars);
                    if (this.month < 1) throw new ILParseException("Fehlerhafte Monatangabe!");
                    if (this.month <= 12) return handled;
                    throw new ILParseException("Fehlerhafte Monatangabe!");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ILParseException("Fehlerhafte Monatangabe!");
                }
            }
            if ("day".equalsIgnoreCase(localName)) {
                try {
                    if (chars.length() <= 0) return handled;
                    this.day = Integer.parseInt(chars);
                    if (this.day < 1) throw new ILParseException("Fehlerhafte Tagangabe!");
                    if (this.day <= 31) return handled;
                    throw new ILParseException("Fehlerhafte Tagangabe!");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ILParseException("Fehlerhafte Tagangabe!");
                }
            }
            if ("weekOfYear".equalsIgnoreCase(localName)) {
                try {
                    if (chars.length() <= 0) return handled;
                    this.weekOfYear = Integer.parseInt(chars);
                    if (this.weekOfYear < 1) throw new ILParseException("Fehlerhafter Index der Woche relativ zum Jahr!");
                    if (this.weekOfYear <= 53) return handled;
                    throw new ILParseException("Fehlerhafter Index der Woche relativ zum Jahr!");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ILParseException("Fehlerhafter Index der Woche relativ zum Jahr!");
                }
            }
            if ("dayOfWeek".equalsIgnoreCase(localName)) {
                try {
                    if (chars.length() <= 0) return handled;
                    this.dayOfWeek = Integer.parseInt(chars);
                    if (this.dayOfWeek < 1) throw new ILParseException("Fehlerhafter Index des Tages relativ zur Woche!");
                    if (this.dayOfWeek <= 7) return handled;
                    throw new ILParseException("Fehlerhafter Index des Tages relativ zur Woche!");
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ILParseException("Fehlerhafter Index des Tages relativ zur Woche!");
                }
            }
            if (!"dayOfYear".equalsIgnoreCase(localName)) return false;
            try {
                if (chars.length() <= 0) return handled;
                this.dayOfYear = Integer.parseInt(chars);
                if (this.dayOfYear < 1) throw new ILParseException("Fehlerhafter Index des Tages relativ zum Jahr!");
                if (this.dayOfYear <= 366) return handled;
                throw new ILParseException("Fehlerhafter Index des Tages relativ zum Jahr!");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ILParseException("Fehlerhafter Index des Tages relativ zum Jahr!");
            }
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void setCurrentElement(MetaStatspezObjekt objekt) {
        this.currentElement = objekt;
    }

    public int getDay() {
        return this.day;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int getDayOfYear() {
        return this.dayOfYear;
    }

    public int getHalfOfYear() {
        return this.halfOfYear;
    }

    public int getMonth() {
        return this.month;
    }

    public int getQuarterOfYear() {
        return this.quarterOfYear;
    }

    public int getWeekOfYear() {
        return this.weekOfYear;
    }

    public int getYear() {
        return this.year;
    }
}

