/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.common.ErrorMessage;
import de.statspez.pleditor.generator.common.WarningMessage;
import java.util.Iterator;
import java.util.Vector;

public class CodegenException
extends RuntimeException {
    private Vector errors = new Vector();
    private Vector warnings = new Vector();

    public CodegenException(String message) {
        super(message);
    }

    public void addError(ErrorMessage error) {
        this.errors.addElement(error);
    }

    public void addWarning(WarningMessage warning) {
        this.warnings.addElement(warning);
    }

    public void addMessagesFrom(CodegenException exc) {
        Iterator errorIt = exc.errorIterator();
        while (errorIt.hasNext()) {
            this.errors.add(errorIt.next());
        }
        Iterator warningIt = exc.warningIterator();
        while (warningIt.hasNext()) {
            this.warnings.add(warningIt.next());
        }
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public Iterator errorIterator() {
        return this.errors.iterator();
    }

    public Iterator warningIterator() {
        return this.warnings.iterator();
    }

    public ErrorMessage[] errors() {
        return this.errors.toArray(new ErrorMessage[0]);
    }

    public WarningMessage[] warnings() {
        return this.warnings.toArray(new WarningMessage[0]);
    }

    public String errorsAsText() {
        StringBuffer text = new StringBuffer();
        Iterator it = this.errorIterator();
        while (it.hasNext()) {
            ErrorMessage anError = (ErrorMessage)it.next();
            text.append(anError.toString());
            text.append('\n');
        }
        return text.toString();
    }

    public String errorsAsTextHTML() {
        StringBuffer text = new StringBuffer();
        Iterator it = this.errorIterator();
        int i = 0;
        while (it.hasNext()) {
            ErrorMessage anError = (ErrorMessage)it.next();
            if (i > 0) {
                text.append("<BR></BR>");
            }
            text.append(anError.toStringHTML());
            ++i;
        }
        return text.toString();
    }

    public String warningsAsText() {
        StringBuffer text = new StringBuffer();
        Iterator it = this.warningIterator();
        while (it.hasNext()) {
            WarningMessage aWarning = (WarningMessage)it.next();
            text.append(aWarning.toString());
            text.append('\n');
        }
        return text.toString();
    }

    public String warningsAsTextHTML() {
        StringBuffer text = new StringBuffer();
        Iterator it = this.warningIterator();
        int i = 0;
        while (it.hasNext()) {
            WarningMessage aWarning = (WarningMessage)it.next();
            if (i > 0) {
                text.append("<BR></BR>");
            }
            text.append(aWarning.toStringHTML());
            ++i;
        }
        return text.toString();
    }
}

