/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html.filters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.filters.DefaultFilter;

public class NamespaceBinder
extends DefaultFilter {
    public static final String XHTML_1_0_URI = "http://www.w3.org/1999/xhtml";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String OVERRIDE_NAMESPACES = "http://cyberneko.org/html/features/override-namespaces";
    protected static final String INSERT_NAMESPACES = "http://cyberneko.org/html/features/insert-namespaces";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://cyberneko.org/html/features/override-namespaces", "http://cyberneko.org/html/features/insert-namespaces"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, Boolean.FALSE, Boolean.FALSE};
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String NAMESPACES_URI = "http://cyberneko.org/html/properties/namespaces-uri";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/names/attrs", "http://cyberneko.org/html/properties/namespaces-uri"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, "http://www.w3.org/1999/xhtml"};
    protected static final short NAMES_NO_CHANGE = 0;
    protected static final short NAMES_UPPERCASE = 1;
    protected static final short NAMES_LOWERCASE = 2;
    protected boolean fNamespaces;
    protected boolean fNamespacePrefixes;
    protected boolean fOverrideNamespaces;
    protected boolean fInsertNamespaces;
    protected short fNamesElems;
    protected short fNamesAttrs;
    protected String fNamespacesURI;
    protected final NamespaceSupport fNamespaceContext = new NamespaceSupport();
    private static final QName fQName = new QName();
    static /* synthetic */ Class class$java$lang$String;

    public String[] getRecognizedFeatures() {
        return NamespaceBinder.merge(super.getRecognizedFeatures(), RECOGNIZED_FEATURES);
    }

    public Boolean getFeatureDefault(String string) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(string)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return super.getFeatureDefault(string);
    }

    public String[] getRecognizedProperties() {
        return NamespaceBinder.merge(super.getRecognizedProperties(), RECOGNIZED_PROPERTIES);
    }

    public Object getPropertyDefault(String string) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(string)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return super.getPropertyDefault(string);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        super.reset(xMLComponentManager);
        this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        this.fOverrideNamespaces = xMLComponentManager.getFeature(OVERRIDE_NAMESPACES);
        this.fInsertNamespaces = xMLComponentManager.getFeature(INSERT_NAMESPACES);
        this.fNamesElems = NamespaceBinder.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ELEMS)));
        this.fNamesAttrs = NamespaceBinder.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ATTRS)));
        this.fNamespacesURI = String.valueOf(xMLComponentManager.getProperty(NAMESPACES_URI));
        this.fNamespaceContext.reset();
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        super.startDocument(xMLLocator, string, this.fNamespaceContext, augmentations);
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.fNamespaceContext.pushContext();
            this.bindNamespaces(qName, xMLAttributes);
            int n = this.fNamespaceContext.getDeclaredPrefixCount();
            if (this.fDocumentHandler != null && n > 0) {
                try {
                    Class<?> clazz = this.fDocumentHandler.getClass();
                    Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String};
                    Method method = clazz.getMethod("startPrefixMapping", classArray);
                    for (int i = 0; i < n; ++i) {
                        String string = this.fNamespaceContext.getDeclaredPrefixAt(i);
                        String string2 = this.fNamespaceContext.getURI(string);
                        Object[] objectArray = new Object[]{string, string2};
                        method.invoke((Object)this.fDocumentHandler, objectArray);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        super.startElement(qName, xMLAttributes, augmentations);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Object[] objectArray;
        String string;
        int n;
        Method method;
        Class[] classArray;
        Class<?> clazz;
        int n2;
        if (this.fNamespaces) {
            this.fNamespaceContext.pushContext();
            this.bindNamespaces(qName, xMLAttributes);
            n2 = this.fNamespaceContext.getDeclaredPrefixCount();
            if (this.fDocumentHandler != null && n2 > 0) {
                try {
                    clazz = this.fDocumentHandler.getClass();
                    classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String};
                    method = clazz.getMethod("startPrefixMapping", classArray);
                    for (n = 0; n < n2; ++n) {
                        string = this.fNamespaceContext.getDeclaredPrefixAt(n);
                        objectArray = this.fNamespaceContext.getURI(string);
                        Object[] objectArray2 = new Object[]{string, objectArray};
                        method.invoke((Object)this.fDocumentHandler, objectArray2);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        super.emptyElement(qName, xMLAttributes, augmentations);
        if (this.fNamespaces) {
            n2 = this.fNamespaceContext.getDeclaredPrefixCount();
            if (this.fDocumentHandler != null && n2 > 0) {
                try {
                    clazz = this.fDocumentHandler.getClass();
                    classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String};
                    method = clazz.getMethod("endPrefixMapping", classArray);
                    for (n = n2 - 1; n >= 0; --n) {
                        string = this.fNamespaceContext.getDeclaredPrefixAt(n);
                        objectArray = new Object[]{string};
                        method.invoke((Object)this.fDocumentHandler, objectArray);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.fNamespaceContext.popContext();
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.bindNamespaces(qName, null);
        }
        super.endElement(qName, augmentations);
        if (this.fNamespaces) {
            int n = this.fNamespaceContext.getDeclaredPrefixCount();
            if (this.fDocumentHandler != null && n > 0) {
                try {
                    Class<?> clazz = this.fDocumentHandler.getClass();
                    Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String};
                    Method method = clazz.getMethod("endPrefixMapping", classArray);
                    for (int i = n - 1; i >= 0; --i) {
                        String string = this.fNamespaceContext.getDeclaredPrefixAt(i);
                        Object[] objectArray = new Object[]{string};
                        method.invoke((Object)this.fDocumentHandler, objectArray);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.fNamespaceContext.popContext();
        }
    }

    protected static void splitQName(QName qName) {
        int n = qName.rawname.indexOf(58);
        if (n != -1) {
            qName.prefix = qName.rawname.substring(0, n);
            qName.localpart = qName.rawname.substring(n + 1);
        }
    }

    protected static final short getNamesValue(String string) {
        if (string.equals("lower")) {
            return 2;
        }
        if (string.equals("upper")) {
            return 1;
        }
        return 0;
    }

    protected static final String modifyName(String string, short s) {
        switch (s) {
            case 1: {
                return string.toUpperCase();
            }
            case 2: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    protected void bindNamespaces(QName qName, XMLAttributes xMLAttributes) {
        String string;
        NamespaceBinder.splitQName(qName);
        int n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        for (int i = n - 1; i >= 0; --i) {
            String string2;
            xMLAttributes.getName(i, fQName);
            string = NamespaceBinder.fQName.rawname;
            String string3 = string.toUpperCase();
            if (!string3.startsWith("XMLNS:") && !string3.equals("XMLNS")) continue;
            int n2 = string.length();
            String string4 = n2 > 5 ? string.substring(0, 5) : null;
            String string5 = n2 > 5 ? string.substring(6) : string;
            String string6 = xMLAttributes.getValue(i);
            if (n2 > 5) {
                string4 = NamespaceBinder.modifyName(string4, (short)2);
                string5 = NamespaceBinder.modifyName(string5, this.fNamesElems);
                string = string4 + ':' + string5;
            } else {
                string = string5 = NamespaceBinder.modifyName(string5, (short)2);
            }
            fQName.setValues(string4, string5, string, null);
            xMLAttributes.setName(i, fQName);
            String string7 = string5 != string ? string5 : "";
            String string8 = string2 = string6.length() > 0 ? string6 : null;
            if (this.fOverrideNamespaces && string7.equals(qName.prefix) && HTMLElements.getElement(qName.localpart, null) != null) {
                string2 = this.fNamespacesURI;
            }
            this.fNamespaceContext.declarePrefix(string7, string2);
        }
        String string9 = qName.prefix != null ? qName.prefix : "";
        qName.uri = this.fNamespaceContext.getURI(string9);
        if (qName.uri != null && qName.prefix == null) {
            qName.prefix = "";
        }
        if (this.fInsertNamespaces && HTMLElements.getElement(qName.localpart, null) != null && (qName.prefix == null || this.fNamespaceContext.getURI(qName.prefix) == null)) {
            string = "xmlns" + (qName.prefix != null ? ":" + qName.prefix : "");
            fQName.setValues(null, string, string, null);
            xMLAttributes.addAttribute(fQName, "CDATA", this.fNamespacesURI);
            this.bindNamespaces(qName, xMLAttributes);
            return;
        }
        n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            xMLAttributes.getName(i, fQName);
            NamespaceBinder.splitQName(fQName);
            string9 = !NamespaceBinder.fQName.rawname.equals("xmlns") ? (NamespaceBinder.fQName.prefix != null ? NamespaceBinder.fQName.prefix : "") : "xmlns";
            NamespaceBinder.fQName.uri = this.fNamespaceContext.getURI(string9);
            xMLAttributes.setName(i, fQName);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NamespaceSupport
    implements NamespaceContext {
        protected int fTop = 0;
        protected int[] fLevels = new int[10];
        protected Entry[] fEntries = new Entry[10];

        public NamespaceSupport() {
            this.pushContext();
            this.declarePrefix("xml", NamespaceContext.XML_URI);
            this.declarePrefix("xmlns", NamespaceContext.XMLNS_URI);
        }

        public String getURI(String string) {
            for (int i = this.fLevels[this.fTop] - 1; i >= 0; --i) {
                Entry entry = this.fEntries[i];
                if (!entry.prefix.equals(string)) continue;
                return entry.uri;
            }
            return null;
        }

        public int getDeclaredPrefixCount() {
            return this.fLevels[this.fTop] - this.fLevels[this.fTop - 1];
        }

        public String getDeclaredPrefixAt(int n) {
            return this.fEntries[this.fLevels[this.fTop - 1] + n].prefix;
        }

        public NamespaceContext getParentContext() {
            return this;
        }

        public void reset() {
            this.fTop = 1;
            this.fLevels[1] = this.fLevels[this.fTop - 1];
        }

        public void pushContext() {
            if (++this.fTop == this.fLevels.length) {
                int[] nArray = new int[this.fLevels.length + 10];
                System.arraycopy(this.fLevels, 0, nArray, 0, this.fLevels.length);
                this.fLevels = nArray;
            }
            this.fLevels[this.fTop] = this.fLevels[this.fTop - 1];
        }

        public void popContext() {
            --this.fTop;
        }

        public boolean declarePrefix(String string, String string2) {
            Entry[] entryArray;
            int n = this.getDeclaredPrefixCount();
            for (int i = 0; i < n; ++i) {
                entryArray = this.getDeclaredPrefixAt(i);
                if (!entryArray.equals(string)) continue;
                return false;
            }
            Entry entry = new Entry(string, string2);
            if (this.fLevels[this.fTop] == this.fEntries.length) {
                entryArray = new Entry[this.fEntries.length + 10];
                System.arraycopy(this.fEntries, 0, entryArray, 0, this.fEntries.length);
                this.fEntries = entryArray;
            }
            int n2 = this.fTop;
            int n3 = this.fLevels[n2];
            this.fLevels[n2] = n3 + 1;
            this.fEntries[n3] = entry;
            return true;
        }

        public String getPrefix(String string) {
            for (int i = this.fLevels[this.fTop] - 1; i >= 0; --i) {
                Entry entry = this.fEntries[i];
                if (!entry.uri.equals(string)) continue;
                return entry.prefix;
            }
            return null;
        }

        public Enumeration getAllPrefixes() {
            Vector<String> vector = new Vector<String>();
            for (int i = this.fLevels[1]; i < this.fLevels[this.fTop]; ++i) {
                String string = this.fEntries[i].prefix;
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
            return vector.elements();
        }

        static class Entry {
            public String prefix;
            public String uri;

            public Entry(String string, String string2) {
                this.prefix = string;
                this.uri = string2;
            }
        }
    }
}

