/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import com.bitmechanic.maxq.HttpRequestHeader;
import com.bitmechanic.maxq.ProxyObserver;
import com.bitmechanic.maxq.RequestHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class ProxyServer
extends Thread {
    private Vector listeners;
    private ServerSocket srvSock;
    private int count;

    public ProxyServer() throws IOException {
        this(0);
    }

    public ProxyServer(int port) throws IOException {
        this.srvSock = new ServerSocket(port);
        this.listeners = new Vector();
    }

    public void addObserver(ProxyObserver proxy) {
        this.listeners.addElement(proxy);
    }

    public void removeObserver(ProxyObserver proxy) {
        this.listeners.removeElement(proxy);
    }

    public void processRequest(HttpRequestHeader header, byte[] requestBody) throws IOException {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ProxyObserver pl = (ProxyObserver)e.nextElement();
            pl.processRequest(header, requestBody);
        }
    }

    public void processResponse(HttpRequestHeader header, byte[] response) throws IOException {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ProxyObserver pl = (ProxyObserver)e.nextElement();
            pl.processResponse(header, response);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket s = this.srvSock.accept();
                    RequestHandler handler = new RequestHandler(this, s);
                    Thread t = new Thread((Runnable)handler, "MaxQRequestHandler #" + this.count);
                    t.start();
                    ++this.count;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    int getLocalPort() {
        return this.srvSock.getLocalPort();
    }
}

