/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mavenplugins.sourceforge;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPBean {
    private String _site;
    private String _destDir;
    private List _files;
    private String _userEmail;

    public String getSite() {
        return this._site;
    }

    public void setSite(String site) {
        this._site = site;
    }

    public String getDestDir() {
        return this._destDir;
    }

    public void setDestDir(String destDir) {
        this._destDir = destDir;
    }

    public List getFiles() {
        return this._files;
    }

    public void setFiles(List files) {
        this._files = files;
    }

    public void setFilesIterator(Iterator iterator) {
        this._files = new ArrayList();
        while (iterator.hasNext()) {
            this._files.add(iterator.next());
        }
    }

    public String getUserEmail() {
        return this._userEmail;
    }

    public void setUserEmail(String userEmail) {
        this._userEmail = userEmail;
    }

    public void execute() throws SocketException, IOException {
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(this._site);
            ftp.enterLocalPassiveMode();
            System.out.println("Connected to " + this._site + ".");
            this.checkReply(ftp);
            ftp.login("anonymous", this._userEmail);
            this.checkReply(ftp);
            ftp.setFileType(2);
            ftp.changeWorkingDirectory(this._destDir);
            this.checkReply(ftp);
            Iterator i = this._files.iterator();
            while (i.hasNext()) {
                File file = (File)i.next();
                System.out.println("copying file " + file.getName());
                ftp.storeFile(file.getName(), (InputStream)new FileInputStream(file));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {}
            }
        }
    }

    private void checkReply(FTPClient ftp) throws IOException {
        System.out.print(ftp.getReplyString());
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftp.disconnect();
            throw new IOException("FTP server refused connection.");
        }
    }
}

