/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.destatis.core.inspector.util.DatmlRawResources;
import de.destatis.core.inspector.util.Inspection;
import java.io.IOException;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SyntaxInspection
extends Inspection {
    private static final String SYNTAX_PROBLEM_NUM = "001";
    private Vector openedReaders = new Vector();
    private boolean firstElementReaded = false;

    public SyntaxInspection() {
        this.inspectionLevel = 1;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.firstElementReaded = false;
    }

    @Override
    public void startElement(String uri, String localName, String raw, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, raw, attributes);
        if (!this.firstElementReaded) {
            if (DatmlRawResources.isRootElement(raw)) {
                try {
                    DatmlRawResources.validateRootElement(attributes, this.getReporter());
                }
                catch (Exception exc) {
                    this.errorProblem(1, SYNTAX_PROBLEM_NUM, exc.getMessage());
                }
            } else {
                this.fatalProblem(1, SYNTAX_PROBLEM_NUM, "Das Root-Element 'DatML-RAW-D' konnte nicht gefunden werden!");
            }
            this.firstElementReaded = true;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (int idx = 0; idx < this.openedReaders.size(); ++idx) {
            try {
                ((Reader)this.openedReaders.get(idx)).close();
                continue;
            }
            catch (IOException exc) {
                LOG.error((Object)"Fehler beim Schliessen eines Streams:", (Throwable)exc);
            }
        }
        this.openedReaders.removeAllElements();
        super.endDocument();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource result = null;
        try {
            Reader reader = DatmlRawResources.getSchema(systemId, this.getConfig().getSchemaDir());
            if (reader != null) {
                this.openedReaders.add(reader);
                result = new InputSource(reader);
            } else {
                result = super.resolveEntity(publicId, systemId);
            }
        }
        catch (Exception exc) {
            throw new SAXException(exc);
        }
        return result;
    }

    @Override
    public void warning(SAXParseException exc) throws SAXException {
        this.warningProblem(1, SYNTAX_PROBLEM_NUM, this.getSAXParseMessage(exc));
    }

    @Override
    public void error(SAXParseException exc) throws SAXException {
        this.errorProblem(1, SYNTAX_PROBLEM_NUM, this.getSAXParseMessage(exc));
    }

    @Override
    public void fatalError(SAXParseException exc) throws SAXException {
        this.fatalProblem(1, SYNTAX_PROBLEM_NUM, this.getSAXParseMessage(exc));
    }

    @Override
    protected void parse(InputSource document) throws IOException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setContentHandler(this);
            reader.setErrorHandler(this);
            reader.setEntityResolver(this);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", DatmlRawResources.getSchemaLocation());
            reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", DatmlRawResources.getNoNamespaceSchemaLocation());
            reader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", DatmlRawResources.getGrammarPool());
            reader.parse(document);
        }
        catch (SAXException e) {
            this.fatalProblem(1, SYNTAX_PROBLEM_NUM, e.getMessage());
        }
        catch (UTFDataFormatException e) {
            this.fatalProblem(1, SYNTAX_PROBLEM_NUM, e.getMessage());
        }
    }

    private String getSAXParseMessage(SAXParseException exc) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(Zeile ");
        buffer.append(exc.getLineNumber());
        buffer.append(", Spalte ");
        buffer.append(exc.getColumnNumber());
        buffer.append(") ");
        buffer.append(exc.getMessage());
        return buffer.toString();
    }
}

