/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.inspector.InspectionProblem;
import de.destatis.core.inspector.InspectionReport;
import de.destatis.core.inspector.ProblemPosition;
import de.destatis.core.inspector.util.FatalException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class InspectionReporter {
    protected static final int MAX_PROBLEMS_DOCUMENT_PER_LEVEL_PER_PROBLEM_CLASS = 100;
    protected static final int MAX_PROBLEMS_MESSAGE_PER_LEVEL_PER_PROBLEM_CLASS = 100;
    protected static final int MAX_PROBLEMS_DECLARATION_PER_LEVEL_PER_PROBLEM_CLASS = 100;
    protected static final int MAX_PROBLEMS_TOTAL = 10000;
    private int level = 0;
    private Date date = null;
    private int msgnum = 0;
    private int declnum = 0;
    private int declid = 0;
    private int recno = 0;
    private String datMlRawVersion;
    private boolean statisticAndReportingPeriodSpecificInspection = false;
    private boolean unitIdVerificationUsed = false;
    private InspectionProblemList problemList = new InspectionProblemList();
    private ProblemCounter problemCounter = new ProblemCounter();
    private DeclarationInfos declarationInfos = new DeclarationInfos();
    private String charset;

    public void setLevel(int level) {
        this.level = level;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDatMlRawVersion(String datMlRawVersion) {
        this.datMlRawVersion = datMlRawVersion;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setStatisticAndReportingPeriodSpecificInspection(boolean statisticAndReportingPeriodSpecificInspection) {
        this.statisticAndReportingPeriodSpecificInspection = statisticAndReportingPeriodSpecificInspection;
    }

    public void setUnitIdVerificationUsed() {
        this.unitIdVerificationUsed = true;
    }

    protected void setTestLevelDataInspection(int msgId, int declId) {
        this.declarationInfos.setTestLevelDataInspection(msgId, declId);
    }

    protected void setTestLevelDataInspectionWithoutReportRejection(int msgId, int declId) {
        this.declarationInfos.setTestLevelDataInspectionWithoutReportRejection(msgId, declId);
    }

    protected void setDataInspectionSDFResourceId(int msgId, int declId, String sdfResourceId) {
        this.declarationInfos.setDataInspectionSDFResourceId(msgId, declId, sdfResourceId);
    }

    protected void setCollectorCorrection(int msgId, int declId, String collectorCorrection) {
        this.declarationInfos.setCollectorCorrection(msgId, declId, collectorCorrection);
    }

    public void nextMessage() {
        ++this.msgnum;
        this.declid = 0;
    }

    public int getNumOfMessages() {
        return this.msgnum;
    }

    public void nextDeclaration() {
        ++this.declnum;
        ++this.declid;
        this.recno = 0;
    }

    public int getNumOfDeclarations() {
        return this.declnum;
    }

    public int getDeclarationID() {
        return this.declid;
    }

    public void nextRecord() {
        ++this.recno;
    }

    public int getRecordNo() {
        return this.recno;
    }

    public void addProblem(InspectionProblem problem) {
        this.problemList.addProblem(problem);
        this.problemCounter.addProblem(problem);
        if (problem.getProblemClass() == 4) {
            throw new FatalException();
        }
    }

    public InspectionReport getReport() {
        return new InspectionReport(this.level, this.date, this.msgnum, this.declnum, this.problemList.getProblemList(), this.problemCounter, this.datMlRawVersion, this.statisticAndReportingPeriodSpecificInspection, this.unitIdVerificationUsed, this.declarationInfos, this.charset);
    }

    protected ProblemCounter getProblemCounter() {
        return this.problemCounter;
    }

    protected InspectionProblemList getProblemList() {
        return this.problemList;
    }

    public static class DeclarationInfo {
        private boolean testLevelDataInspection = false;
        private boolean testLevelDataInspectionWithoutReportRejection = false;
        private String dataInspectionSDFResourceId = null;
        private String collectorCorrection = null;

        public boolean isTestLevelDataInspection() {
            return this.testLevelDataInspection;
        }

        public void setTestLevelDataInspection() {
            this.testLevelDataInspection = true;
        }

        public boolean isTestLevelDataInspectionWithoutReportRejection() {
            return this.testLevelDataInspectionWithoutReportRejection;
        }

        public void setTestLevelDataInspectionWithoutReportRejection() {
            this.testLevelDataInspectionWithoutReportRejection = true;
        }

        public String getDataInspectionSDFResourceId() {
            return this.dataInspectionSDFResourceId;
        }

        public void setDataInspectionSDFResourceId(String sdfResourceId) {
            this.dataInspectionSDFResourceId = sdfResourceId;
        }

        public String getCollectorCorrection() {
            return this.collectorCorrection;
        }

        public void setCollectorCorrection(String collectorCorrection) {
            this.collectorCorrection = collectorCorrection;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("DataInsp: ").append(this.testLevelDataInspection);
            result.append(", DataInspw/oRepRej: ").append(this.testLevelDataInspectionWithoutReportRejection);
            result.append(", SDFResId: ").append(this.dataInspectionSDFResourceId);
            result.append(", CollCorr: ").append(this.collectorCorrection);
            return result.toString();
        }
    }

    public static class DeclarationInfos {
        private Vector msgList = new Vector(100, 100);

        private DeclarationInfos() {
        }

        public DeclarationInfo getDeclarationInfo(int msgId, int declId) {
            DeclarationInfo result = null;
            Contract.verify((msgId > 0 ? 1 : 0) != 0, (String)"msgId muss > 0 sein.");
            Contract.verify((declId > 0 ? 1 : 0) != 0, (String)"declId muss > 0 sein.");
            int msgIdx = msgId - 1;
            int declIdx = declId - 1;
            Vector declarationList = null;
            if (msgIdx < this.msgList.size() && (declarationList = (Vector)this.msgList.get(msgIdx)) != null && declIdx < declarationList.size()) {
                result = (DeclarationInfo)declarationList.elementAt(declIdx);
            }
            return result;
        }

        private void setTestLevelDataInspection(int msgId, int declId) {
            DeclarationInfo declInfo = this.getAndCreateDeclarationInfo(msgId, declId);
            declInfo.setTestLevelDataInspection();
        }

        private void setTestLevelDataInspectionWithoutReportRejection(int msgId, int declId) {
            DeclarationInfo declInfo = this.getAndCreateDeclarationInfo(msgId, declId);
            declInfo.setTestLevelDataInspectionWithoutReportRejection();
        }

        private void setDataInspectionSDFResourceId(int msgId, int declId, String sdfResourceId) {
            DeclarationInfo declInfo = this.getAndCreateDeclarationInfo(msgId, declId);
            declInfo.setDataInspectionSDFResourceId(sdfResourceId);
        }

        private void setCollectorCorrection(int msgId, int declId, String collectorCorrection) {
            DeclarationInfo declInfo = this.getAndCreateDeclarationInfo(msgId, declId);
            declInfo.setCollectorCorrection(collectorCorrection);
        }

        private DeclarationInfo getAndCreateDeclarationInfo(int msgId, int declId) {
            Contract.verify((msgId > 0 ? 1 : 0) != 0, (String)"msgId muss > 0 sein.");
            Contract.verify((declId > 0 ? 1 : 0) != 0, (String)"declId muss > 0 sein.");
            int msgIdx = msgId - 1;
            int declIdx = declId - 1;
            Vector<DeclarationInfo> declarationList = null;
            if (msgIdx < this.msgList.size()) {
                declarationList = (Vector<DeclarationInfo>)this.msgList.get(msgIdx);
            }
            if (declarationList == null) {
                declarationList = new Vector<DeclarationInfo>(100, 100);
                if (msgIdx >= this.msgList.size()) {
                    this.msgList.setSize(msgId);
                }
                this.msgList.setElementAt(declarationList, msgIdx);
            }
            DeclarationInfo declInfo = null;
            if (declIdx < declarationList.size()) {
                declInfo = (DeclarationInfo)declarationList.elementAt(declIdx);
            }
            if (declInfo == null) {
                declInfo = new DeclarationInfo();
                if (declIdx >= declarationList.size()) {
                    declarationList.setSize(declId);
                }
                declarationList.setElementAt(declInfo, declIdx);
            }
            return declInfo;
        }
    }

    public static class ProblemCounter {
        private static final Integer INSPECTION_LEVEL_SYNTAX = new Integer(1);
        private static final Integer INSPECTION_LEVEL_SEMANTICS = new Integer(2);
        private static final Integer INSPECTION_LEVEL_AUTHORIZING = new Integer(3);
        private static final Integer INSPECTION_LEVEL_DATA = new Integer(4);
        private static final Integer PROBLEM_CLASS_INFO = new Integer(1);
        private static final Integer PROBLEM_CLASS_WARN = new Integer(2);
        private static final Integer PROBLEM_CLASS_ERROR = new Integer(3);
        private static final Integer PROBLEM_CLASS_FATAL = new Integer(4);
        private Map msgErrorList = new HashMap();

        private ProblemCounter() {
        }

        public void addProblem(InspectionProblem problem) {
            Counter counter;
            HashMap<Object, Counter> problemMap;
            Map levelMap;
            Object problemTestLevel = this.getInspectionLevelKey(problem);
            Object problemClass = this.getProblemClassKey(problem);
            ProblemPosition problemPosition = problem.getPosition();
            int msgId = problemPosition.getMessageID();
            Integer msgIdObj = new Integer(msgId);
            int declId = problemPosition.getDeclarationID();
            Integer declIdObj = new Integer(declId);
            if (msgId == 0) {
                levelMap = (HashMap)this.msgErrorList.get(msgIdObj);
                if (levelMap == null) {
                    levelMap = new HashMap();
                    this.msgErrorList.put(msgIdObj, levelMap);
                }
            } else {
                HashMap declarationMap = (HashMap)this.msgErrorList.get(msgIdObj);
                if (declarationMap == null) {
                    declarationMap = new HashMap();
                    this.msgErrorList.put(msgIdObj, declarationMap);
                }
                if ((levelMap = (Map)declarationMap.get(declIdObj)) == null) {
                    levelMap = new HashMap();
                    declarationMap.put(declIdObj, levelMap);
                }
            }
            if ((problemMap = (HashMap<Object, Counter>)levelMap.get(problemTestLevel)) == null) {
                problemMap = new HashMap<Object, Counter>();
                levelMap.put(problemTestLevel, problemMap);
            }
            if ((counter = (Counter)problemMap.get(problemClass)) == null) {
                counter = new Counter();
                problemMap.put(problemClass, counter);
            }
            counter.counter++;
        }

        public int getProblemCount(int msgId, int declId, int testLevel, int problemClass) {
            Contract.verify((msgId >= 0 || msgId == -1 ? 1 : 0) != 0, (String)"msgId muss >= 0 oder -1 sein.");
            if (msgId > 0) {
                Contract.verify((declId >= 0 || declId == -1 ? 1 : 0) != 0, (String)"declId muss >= 0 oder -1 sein.");
            }
            Contract.verify((testLevel == -1 || testLevel >= 1 && testLevel <= 4 ? 1 : 0) != 0, (String)("Ungueltige Pruefstufe " + testLevel + "."));
            Contract.verify((problemClass == -1 || problemClass >= 1 && problemClass <= 4 ? 1 : 0) != 0, (String)("Ungueltige Problemklasse " + problemClass + "."));
            Integer problemTestLevelObj = new Integer(testLevel);
            Integer problemClassObj = new Integer(problemClass);
            int count = 0;
            if (msgId == -1) {
                Map noMsgLevelMap = (Map)this.msgErrorList.get(new Integer(0));
                count += this.getCountForLevelMap(noMsgLevelMap, problemTestLevelObj, problemClassObj);
                for (Map tmp : this.msgErrorList.values()) {
                    if (tmp == noMsgLevelMap) continue;
                    Map msgMap = tmp;
                    for (Map levelMap : msgMap.values()) {
                        count += this.getCountForLevelMap(levelMap, problemTestLevelObj, problemClassObj);
                    }
                }
            } else if (msgId == 0) {
                Map noMsgLevelMap = (Map)this.msgErrorList.get(new Integer(0));
                count += this.getCountForLevelMap(noMsgLevelMap, problemTestLevelObj, problemClassObj);
            } else {
                Integer msgIdObj = new Integer(msgId);
                Map msgMap = (Map)this.msgErrorList.get(msgIdObj);
                if (msgMap != null) {
                    if (declId == -1) {
                        Map noDeclLevelMap = (Map)msgMap.get(new Integer(0));
                        count += this.getCountForLevelMap(noDeclLevelMap, problemTestLevelObj, problemClassObj);
                        for (Map check : msgMap.values()) {
                            if (check == noDeclLevelMap) continue;
                            Map levelMap = check;
                            count += this.getCountForLevelMap(levelMap, problemTestLevelObj, problemClassObj);
                        }
                    } else if (declId == 0) {
                        Map noDeclLevelMap = (Map)msgMap.get(new Integer(0));
                        count += this.getCountForLevelMap(noDeclLevelMap, problemTestLevelObj, problemClassObj);
                    } else {
                        Integer declIdObj = new Integer(declId);
                        Map levelMap = (Map)msgMap.get(declIdObj);
                        count += this.getCountForLevelMap(levelMap, problemTestLevelObj, problemClassObj);
                    }
                }
            }
            return count;
        }

        private int getCountForLevelMap(Map levelMap, Integer problemTestLevel, Integer problemClass) {
            int count = 0;
            if (levelMap != null) {
                if (problemTestLevel == -1) {
                    for (Map problemMap : levelMap.values()) {
                        count += this.getCountForProblemMap(problemMap, problemClass);
                    }
                } else {
                    Map problemMap = (Map)levelMap.get(problemTestLevel);
                    count += this.getCountForProblemMap(problemMap, problemClass);
                }
            }
            return count;
        }

        private int getCountForProblemMap(Map problemMap, Integer problemClass) {
            int count = 0;
            if (problemMap != null) {
                if (problemClass == -1) {
                    for (Counter counter : problemMap.values()) {
                        count += counter.counter;
                    }
                } else {
                    Counter counter = (Counter)problemMap.get(problemClass);
                    if (counter != null) {
                        count += counter.counter;
                    }
                }
            }
            return count;
        }

        private Object getInspectionLevelKey(InspectionProblem problem) {
            Integer result;
            int inspectionLevel = problem.getTestLevel();
            if (inspectionLevel == 1) {
                result = INSPECTION_LEVEL_SYNTAX;
            } else if (inspectionLevel == 2) {
                result = INSPECTION_LEVEL_SEMANTICS;
            } else if (inspectionLevel == 3) {
                result = INSPECTION_LEVEL_AUTHORIZING;
            } else if (inspectionLevel == 4) {
                result = INSPECTION_LEVEL_DATA;
            } else {
                throw new IllegalArgumentException("Ung\u00fcltiges Inspectionlevel: " + inspectionLevel + ".");
            }
            return result;
        }

        private Object getProblemClassKey(InspectionProblem problem) {
            Integer result;
            int problemClass = problem.getProblemClass();
            if (problemClass == 1) {
                result = PROBLEM_CLASS_INFO;
            } else if (problemClass == 2) {
                result = PROBLEM_CLASS_WARN;
            } else if (problemClass == 3) {
                result = PROBLEM_CLASS_ERROR;
            } else if (problemClass == 4) {
                result = PROBLEM_CLASS_FATAL;
            } else {
                throw new IllegalArgumentException("Ung\u00fcltige Problemklasse: " + problemClass + ".");
            }
            return result;
        }
    }

    private static class Counter {
        private int counter = 0;

        private Counter() {
        }

        public String toString() {
            return String.valueOf(this.counter);
        }
    }

    protected class InspectionProblemList {
        private List problems = new LinkedList();

        public void addProblem(InspectionProblem problem) {
            boolean isSpaceInList;
            ProblemPosition pos = problem.getPosition();
            int msgId = pos.getMessageID();
            int declId = pos.getDeclarationID();
            int levelProblemClassMax = msgId == 0 ? 100 : (declId == 0 ? 100 : 100);
            int problemTestLevel = problem.getTestLevel();
            int problemClass = problem.getProblemClass();
            int levelCount = InspectionReporter.this.problemCounter.getProblemCount(msgId, declId, problemTestLevel, problemClass);
            if (levelCount >= levelProblemClassMax) {
                return;
            }
            boolean bl = isSpaceInList = this.problems.size() < 10000;
            if (!isSpaceInList) {
                return;
            }
            this.problems.add(problem);
        }

        public List getProblemList() {
            return this.problems;
        }
    }
}

