/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.destatis.core.inspector.util.InspectionReporter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class DatmlRawResources {
    public static final String DATML_RAW_ENCODING = new String("UTF-8");
    public static final String ROOT_ELEMENT = "DatML-RAW-D";
    public static final String TAG_TEST_ID_DE = "test";
    public static final String TAG_TIMESTAMP_DE = "eingangsstempel";
    public static final String TAG_ID_DE = "kennung";
    public static final String TAG_SENDER_DE = "absender";
    public static final String TAG_RECEIVER_DE = "empfaenger";
    public static final String TAG_MESSAGE_DE = "nachricht";
    public static final String TAG_SEGMENT_DE = "segment";
    public static final String TAG_SURVEY_DE = "erhebung";
    public static final String TAG_RESSOURCE_DE = "ressource";
    public static final String TAG_REPORTING_PERIOD_DE = "berichtszeitraum";
    public static final String TAG_YEAR_DE = "jahr";
    public static final String TAG_HALF_YEAR_DE = "halbjahr";
    public static final String TAG_TERM_DE = "semester";
    public static final String TAG_QUARTER_DE = "quartal";
    public static final String TAG_MONTH_DE = "monat";
    public static final String TAG_WEEK_DE = "woche";
    public static final String TAG_DAY_DE = "tag";
    public static final String TAG_DECLARANT_DE = "berichtspflichtiger";
    public static final String TAG_COLLECTOR_DE = "berichtsempfaenger";
    public static final String TAG_CONTACT_DE = "kontakt";
    public static final String TAG_PERSON_DE = "person";
    public static final String TAG_ORGANISATION_DE = "organisation";
    public static final String TAG_NAME_DE = "name";
    public static final String TAG_SURNAME_DE = "nachname";
    public static final String TAG_ADDRESS_DE = "adresse";
    public static final String TAG_ZIP_CODE_DE = "postleitzahl";
    public static final String TAG_CITY_DE = "ort";
    public static final String TAG_MATERIAL_DE = "material";
    public static final String TAG_DATA_ATTRIBUTES_DE = "datenattribute";
    public static final String TAG_DECLARATION_DE = "datensegment";
    public static final String TAG_RECORD_DE = "satz";
    public static final String TAG_HELP_FEATURE_DE = "hmm";
    public static final String TAG_FEATURE_GROUP_DE = "mmgr";
    public static final String TAG_FEATURE_DE = "mm";
    public static final String TAG_VALUE_DE = "wert";
    public static final String TAG_NO_VALUE_DE = "na";
    public static final String TAG_NUMBER_OF_MESSAGES_DE = "anzahl";
    public static final String TAG_IDENTIFICATION_DE = "identifikation";
    public static final String TAG_STREET_DE = "strasse";
    public static final String TAG_HOUSENUMBER_DE = "hausnummer";
    public static final String TAG_POSTOFFICEBOX_DE = "postfach";
    public static final String TAG_PHONE_DE = "telefon";
    public static final String TAG_EMAIL_DE = "email";
    public static final String TAG_FAX_DE = "fax";
    public static final String TAG_FORENAME_DE = "vorname";
    public static final String ATTRIBUTE_DECIMAL_CHAR_DE = "dezimalzeichen";
    public static final String ATTRIBUTE_THOUSEND_DIV_CHAR_DE = "tausender-trennzeichen";
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_2_0 = "2.0";
    public static final String VERSION_2_1 = "2.1";
    public static final String XMLNS_1_0 = "http://www.destatis.de/schema/datml-raw/1.0/d";
    public static final String XMLNS_2_0_DE = "http://www.destatis.de/schema/datml-raw/2.0/de";
    public static final String XMLNS_2_0_EN = "http://www.destatis.de/schema/datml-raw/2.0/en";
    public static final String XMLNS_2_1_DE = "http://www.destatis.de/schema/datml-raw/2.0/de";
    public static final String XMLNS_2_1_EN = "http://www.destatis.de/schema/datml-raw/2.0/en";
    private static final String ATTRIBUTE_XML_VERSION = "version";
    private static final String ATTRIBUTE_XML_XMLNS = "xmlns";
    private static final String SCHEMA_DIR = "schema/raw/";
    private static final String SCHEMA_1_0_DE = "datml-raw-de-1_0.xsd";
    private static final String SCHEMA_NO_NAMESPACE_DE = "datml-raw-de-1_0-nons.xsd";
    private static final String SCHEMA_2_1_DE = "xstatistik-nachrichten.xsd";
    private static final String SCHEMA_2_1_DE_BASISDATENTYPEN = "xoev-basisdatentypen.xsd";
    private static final String SCHEMA_2_1_DE_BASISTYPEN = "xstatistik-basistypen.xsd";
    private static final String SCHEMA_2_1_DE_BAUKASTEN = "xstatistik-baukasten.xsd";
    private static Map SCHEMA_FILES_CHARSET;
    private static XMLGrammarPool grammarPool;

    public static boolean isRootElement(String tag) {
        return ROOT_ELEMENT.equals(tag);
    }

    public static boolean isTestID(String tag) {
        return TAG_TEST_ID_DE.equals(tag);
    }

    public static boolean isID(String tag) {
        return TAG_ID_DE.equals(tag);
    }

    public static boolean isTimestamp(String tag) {
        return TAG_TIMESTAMP_DE.equals(tag);
    }

    public static boolean isSender(String tag) {
        return TAG_SENDER_DE.equals(tag);
    }

    public static boolean isReceiver(String tag) {
        return TAG_RECEIVER_DE.equals(tag);
    }

    public static boolean isMessage(String tag) {
        return TAG_MESSAGE_DE.equals(tag);
    }

    public static boolean isSegment(String tag) {
        return TAG_SEGMENT_DE.equals(tag);
    }

    public static boolean isSurvey(String tag) {
        return TAG_SURVEY_DE.equals(tag);
    }

    public static boolean isRessource(String tag) {
        return TAG_RESSOURCE_DE.equals(tag);
    }

    public static boolean isReportingPeriod(String tag) {
        return TAG_REPORTING_PERIOD_DE.equals(tag);
    }

    public static boolean isYear(String tag) {
        return TAG_YEAR_DE.equals(tag);
    }

    public static boolean isHalfYear(String tag) {
        return TAG_HALF_YEAR_DE.equals(tag);
    }

    public static boolean isTerm(String tag) {
        return TAG_TERM_DE.equals(tag);
    }

    public static boolean isQuarter(String tag) {
        return TAG_QUARTER_DE.equals(tag);
    }

    public static boolean isMonth(String tag) {
        return TAG_MONTH_DE.equals(tag);
    }

    public static boolean isWeek(String tag) {
        return TAG_WEEK_DE.equals(tag);
    }

    public static boolean isDeclarant(String tag) {
        return TAG_DECLARANT_DE.equals(tag);
    }

    public static boolean isCollector(String tag) {
        return TAG_COLLECTOR_DE.equals(tag);
    }

    public static boolean isContact(String tag) {
        return TAG_CONTACT_DE.equals(tag);
    }

    public static boolean isPerson(String tag) {
        return TAG_PERSON_DE.equals(tag);
    }

    public static boolean isOrganisation(String tag) {
        return TAG_ORGANISATION_DE.equals(tag);
    }

    public static boolean isName(String tag) {
        return TAG_NAME_DE.equals(tag);
    }

    public static boolean isSurname(String tag) {
        return TAG_SURNAME_DE.equals(tag);
    }

    public static boolean isAddress(String tag) {
        return TAG_ADDRESS_DE.equals(tag);
    }

    public static boolean isZipCode(String tag) {
        return TAG_ZIP_CODE_DE.equals(tag);
    }

    public static boolean isCity(String tag) {
        return TAG_CITY_DE.equals(tag);
    }

    public static boolean isMaterial(String tag) {
        return TAG_MATERIAL_DE.equals(tag);
    }

    public static boolean isDataAttributes(String tag) {
        return TAG_DATA_ATTRIBUTES_DE.equals(tag);
    }

    public static boolean isDeclaration(String tag) {
        return TAG_DECLARATION_DE.equals(tag);
    }

    public static boolean isRecord(String tag) {
        return TAG_RECORD_DE.equals(tag);
    }

    public static boolean isHelpFeature(String tag) {
        return TAG_HELP_FEATURE_DE.equals(tag);
    }

    public static boolean isFeatureGroup(String tag) {
        return TAG_FEATURE_GROUP_DE.equals(tag);
    }

    public static boolean isFeature(String tag) {
        return TAG_FEATURE_DE.equals(tag);
    }

    public static boolean isValue(String tag) {
        return TAG_VALUE_DE.equals(tag);
    }

    public static boolean isNoValue(String tag) {
        return TAG_NO_VALUE_DE.equals(tag);
    }

    public static boolean isNumOfMessages(String tag) {
        return TAG_NUMBER_OF_MESSAGES_DE.equals(tag);
    }

    public static Attributes validateRootElement(Attributes attributes, InspectionReporter inspectionReporter) throws Exception {
        String message = null;
        String version = attributes.getValue(ATTRIBUTE_XML_VERSION);
        if (version == null) {
            message = "Keine Versionsangabe enthalten";
        } else {
            String xmlns = attributes.getValue(ATTRIBUTE_XML_XMLNS);
            boolean isValidDatMlRawVersion = true;
            if (VERSION_1_0.equals(version)) {
                if (xmlns == null) {
                    AttributesImpl attrs = new AttributesImpl(attributes);
                    attrs.addAttribute(null, null, ATTRIBUTE_XML_XMLNS, null, XMLNS_1_0);
                    attributes = attrs;
                } else if (!XMLNS_1_0.equals(xmlns)) {
                    message = "Falscher Namensraum enthalten: " + xmlns;
                }
            } else if (VERSION_2_0.equals(version)) {
                if (xmlns == null) {
                    message = "Kein Namensraum angegeben";
                } else if (!"http://www.destatis.de/schema/datml-raw/2.0/de".equals(xmlns) && !"http://www.destatis.de/schema/datml-raw/2.0/en".equals(xmlns)) {
                    message = "Falscher Namensraum enthalten: " + xmlns;
                }
            } else if (VERSION_2_1.equals(version)) {
                if (xmlns == null) {
                    message = "Kein Namensraum angegeben";
                } else if (!"http://www.destatis.de/schema/datml-raw/2.0/de".equals(xmlns) && !"http://www.destatis.de/schema/datml-raw/2.0/en".equals(xmlns)) {
                    message = "Falscher Namensraum enthalten: " + xmlns;
                }
            } else {
                isValidDatMlRawVersion = false;
                message = "Unbekannte DatML/RAW-Version: " + version;
            }
            if (isValidDatMlRawVersion) {
                inspectionReporter.setDatMlRawVersion(version);
            }
        }
        if (message != null) {
            throw new Exception(message);
        }
        return attributes;
    }

    public static final String getSchemaLocation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(XMLNS_1_0);
        buffer.append(" ");
        buffer.append(SCHEMA_1_0_DE);
        buffer.append(" ");
        buffer.append("http://www.destatis.de/schema/datml-raw/2.0/de");
        buffer.append(" ");
        buffer.append(SCHEMA_2_1_DE);
        return buffer.toString();
    }

    public static final String getNoNamespaceSchemaLocation() {
        return SCHEMA_NO_NAMESPACE_DE;
    }

    public static final Reader getSchema(String systemId) throws Exception {
        return DatmlRawResources.getSchema(systemId, null);
    }

    public static final Reader getSchema(String systemId, String extResourceDir) throws Exception {
        File schemaFile;
        String schemaFileName = null;
        InputStreamReader reader = null;
        if (systemId.endsWith(SCHEMA_NO_NAMESPACE_DE)) {
            schemaFileName = SCHEMA_NO_NAMESPACE_DE;
        } else if (systemId.endsWith(SCHEMA_1_0_DE)) {
            schemaFileName = SCHEMA_1_0_DE;
        } else if (systemId.endsWith(SCHEMA_2_1_DE)) {
            schemaFileName = SCHEMA_2_1_DE;
        } else if (systemId.endsWith(SCHEMA_2_1_DE_BASISDATENTYPEN)) {
            schemaFileName = SCHEMA_2_1_DE_BASISDATENTYPEN;
        } else if (systemId.endsWith(SCHEMA_2_1_DE_BASISTYPEN)) {
            schemaFileName = SCHEMA_2_1_DE_BASISTYPEN;
        } else if (systemId.endsWith(SCHEMA_2_1_DE_BAUKASTEN)) {
            schemaFileName = SCHEMA_2_1_DE_BAUKASTEN;
        } else {
            int idx = systemId.lastIndexOf(47);
            if (idx >= 0 && idx < systemId.length() - 1) {
                schemaFileName = systemId.substring(idx + 1);
            }
        }
        String charset = DatmlRawResources.getSchemaFileCharset(schemaFileName);
        if (extResourceDir != null && extResourceDir.length() > 0 && (schemaFile = extResourceDir.endsWith("/") || extResourceDir.endsWith("\\") ? new File(extResourceDir + schemaFileName) : new File(extResourceDir + System.getProperty("file.separator") + schemaFileName)).exists()) {
            reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(schemaFile)), charset);
        }
        if (reader == null) {
            schemaFileName = SCHEMA_DIR + schemaFileName;
            reader = new InputStreamReader((InputStream)new BufferedInputStream(DatmlRawResources.class.getResourceAsStream(schemaFileName)), charset);
        }
        return reader;
    }

    protected static String getSchemaFileCharset(String schemaFileName) {
        String charset = (String)SCHEMA_FILES_CHARSET.get(schemaFileName);
        if (charset == null) {
            charset = "UTF-8";
        }
        return charset;
    }

    public static XMLGrammarPool getGrammarPool() {
        if (grammarPool == null) {
            grammarPool = new XMLGrammarPoolImpl();
        }
        return grammarPool;
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put(SCHEMA_1_0_DE, "ISO-8859-1");
        temp.put(SCHEMA_2_1_DE, "UTF-8");
        temp.put(SCHEMA_2_1_DE_BASISDATENTYPEN, "UTF-8");
        temp.put(SCHEMA_2_1_DE_BASISTYPEN, "UTF-8");
        temp.put(SCHEMA_2_1_DE_BAUKASTEN, "UTF-8");
        temp.put(SCHEMA_NO_NAMESPACE_DE, "ISO-8859-1");
        SCHEMA_FILES_CHARSET = temp;
        grammarPool = null;
    }
}

