/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector;

public class UnitIDVerifierResult {
    public static final int BAD_UNIT_ID = new Integer(-1);
    public static final int UNIT_ID_AVAILABLE_AND_COLLECTOR_OK = new Integer(0);
    public static final int UNIT_ID_AVAILABLE_AND_BAD_COLLECTOR = new Integer(1);
    public static final int UNIT_ID_UNCHECKED = new Integer(2);
    private int resultStatus;
    private String collectorCorrection;
    private String additionalInfo;

    public UnitIDVerifierResult(int resultStatus, String collectorCorrection) {
        if (resultStatus != BAD_UNIT_ID && resultStatus != UNIT_ID_AVAILABLE_AND_COLLECTOR_OK && resultStatus != UNIT_ID_AVAILABLE_AND_BAD_COLLECTOR && resultStatus != UNIT_ID_UNCHECKED) {
            throw new IllegalArgumentException("Ungueltiger Ergebnisstatus: " + resultStatus + ".");
        }
        if (resultStatus == UNIT_ID_AVAILABLE_AND_BAD_COLLECTOR && collectorCorrection == null) {
            throw new IllegalArgumentException("Laenderkennzeichenkorrektur ist erforderlich.");
        }
        this.resultStatus = resultStatus;
        this.collectorCorrection = collectorCorrection;
    }

    public int getResultStatus() {
        return this.resultStatus;
    }

    public boolean isBadUnitId() {
        return this.resultStatus == BAD_UNIT_ID;
    }

    public boolean isUnitIdAvailableAndCollectorOk() {
        return this.resultStatus == UNIT_ID_AVAILABLE_AND_COLLECTOR_OK;
    }

    public boolean isUnitIdAvailableAndBadCollector() {
        return this.resultStatus == UNIT_ID_AVAILABLE_AND_BAD_COLLECTOR;
    }

    public boolean isUnitIdUnchecked() {
        return this.resultStatus == UNIT_ID_UNCHECKED;
    }

    public String getCollectorCorrection() {
        return this.collectorCorrection;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }
}

