/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.inspector.InspectionProblem;
import de.destatis.core.inspector.util.InspectionReporter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class InspectionReport {
    private int level;
    private Date date;
    private int msgnum;
    private int declnum;
    private List problems;
    private InspectionReporter.ProblemCounter problemCounter;
    private String datMlRawVersion;
    private boolean isStatisticAndReferencePeriodSpecificInspection;
    private boolean unitIdVerificationUsed;
    private InspectionReporter.DeclarationInfos declarationInfos;
    private String charset;

    public InspectionReport(int level, Date date, int msgnum, int declnum, List problems, InspectionReporter.ProblemCounter problemCounter, String datMlRawVersion, boolean isStatisticAndReferencePeriodSpecificInspection, boolean unitIdVerificationUsed, InspectionReporter.DeclarationInfos declarationInfos, String charset) {
        Contract.verify((level >= 1 && level <= 4 ? 1 : 0) != 0, (String)"Pr\u00fcfstufe muss zwischen 1 und 4 sein.");
        Contract.verify((msgnum >= 0 ? 1 : 0) != 0, (String)"Anzahl der Nachrichten muss eine positive Zahl sein.");
        Contract.verify((declnum >= 0 ? 1 : 0) != 0, (String)"Anzahl der Meldungen muss eine positive Zahl sein.");
        Contract.verify((problemCounter != null ? 1 : 0) != 0, (String)"ProblemCounter muss angegeben werden.");
        this.level = level;
        this.date = date != null ? date : new Date();
        this.msgnum = msgnum;
        this.declnum = declnum;
        this.problems = problems != null ? problems : new Vector();
        this.problemCounter = problemCounter;
        this.datMlRawVersion = datMlRawVersion;
        this.isStatisticAndReferencePeriodSpecificInspection = isStatisticAndReferencePeriodSpecificInspection;
        this.unitIdVerificationUsed = unitIdVerificationUsed;
        this.declarationInfos = declarationInfos;
        this.charset = charset;
    }

    public boolean isOk() {
        return this.getNumOfProblems(3) + this.getNumOfProblems(4) == 0;
    }

    public int getInspectionLevel() {
        return this.level;
    }

    public Date getInspectionDate() {
        return this.date;
    }

    public int getNumOfMessages() {
        return this.msgnum;
    }

    public int getNumOfDeclarations() {
        return this.declnum;
    }

    public int getNumOfProblems() {
        return this.getNumOfProblems(-1, -1, -1, -1);
    }

    public int getNumOfProblems(int problemClass) {
        return this.getNumOfProblems(-1, -1, -1, problemClass);
    }

    public List getProblemList() {
        return Collections.unmodifiableList(this.problems);
    }

    public List getProblemList(int problemClass) {
        Vector<InspectionProblem> problemsOfClass = new Vector<InspectionProblem>();
        for (int i = 0; i < this.problems.size(); ++i) {
            InspectionProblem problem = (InspectionProblem)this.problems.get(i);
            if (problem.getProblemClass() != problemClass) continue;
            problemsOfClass.add(problem);
        }
        return Collections.unmodifiableList(problemsOfClass);
    }

    public String getDatMlRawVersion() {
        return this.datMlRawVersion;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean unitIdVerificationUsed() {
        return this.unitIdVerificationUsed;
    }

    public int getNumOfProblems(int msgId, int declId, int testLevel, int problemClass) {
        return this.problemCounter.getProblemCount(msgId, declId, testLevel, problemClass);
    }

    public List getProblemList(int msgId, int declId, int testLevel, int problemClass) {
        Contract.verify((msgId >= 0 || msgId == -1 ? 1 : 0) != 0, (String)"msgId muss >= 0 oder -1 sein.");
        if (msgId > 0) {
            Contract.verify((declId >= 0 || declId == -1 ? 1 : 0) != 0, (String)"declId muss >= 0 oder -1 sein.");
        }
        Contract.verify((testLevel == -1 || testLevel >= 1 && testLevel <= 4 ? 1 : 0) != 0, (String)("Ungueltige Pruefstufe " + testLevel + "."));
        Contract.verify((problemClass == -1 || problemClass >= 1 && problemClass <= 4 ? 1 : 0) != 0, (String)("Ungueltige Problemklasse " + problemClass + "."));
        Vector<InspectionProblem> filteredProblems = new Vector<InspectionProblem>(100, 100);
        for (InspectionProblem problem : this.problems) {
            boolean add = false;
            int checkTestLevel = problem.getTestLevel();
            if (testLevel == -1 || testLevel == checkTestLevel) {
                int checkProblemClass = problem.getProblemClass();
                if (problemClass == -1 || problemClass == checkProblemClass) {
                    if (msgId == -1) {
                        add = true;
                    } else if (msgId == 0) {
                        if (problem.getPosition().getMessageID() == 0) {
                            add = true;
                        }
                    } else {
                        int checkMsgId = problem.getPosition().getMessageID();
                        if (msgId == checkMsgId) {
                            int checkDeclId;
                            if (declId == -1) {
                                add = true;
                            } else if (declId == 0) {
                                checkDeclId = problem.getPosition().getDeclarationID();
                                if (checkDeclId == 0) {
                                    add = true;
                                }
                            } else {
                                checkDeclId = problem.getPosition().getDeclarationID();
                                if (declId == checkDeclId) {
                                    add = true;
                                }
                            }
                        }
                    }
                }
            }
            if (!add) continue;
            filteredProblems.add(problem);
        }
        return Collections.unmodifiableList(filteredProblems);
    }

    public boolean isTestLevelDataInspection(int msgId, int declId) {
        InspectionReporter.DeclarationInfo declInfo;
        boolean result = this.isStatisticAndReferencePeriodSpecificInspection && this.declarationInfos != null ? ((declInfo = this.declarationInfos.getDeclarationInfo(msgId, declId)) != null ? declInfo.isTestLevelDataInspection() : false) : this.getInspectionLevel() >= 4;
        return result;
    }

    public boolean isDataInspectionWithoutReportRejection(int msgId, int declId) {
        InspectionReporter.DeclarationInfo declInfo;
        boolean result = this.isStatisticAndReferencePeriodSpecificInspection && this.declarationInfos != null ? ((declInfo = this.declarationInfos.getDeclarationInfo(msgId, declId)) != null ? declInfo.isTestLevelDataInspectionWithoutReportRejection() : false) : false;
        return result;
    }

    public String getDataInspectionSDFResourceId(int msgId, int declId) {
        InspectionReporter.DeclarationInfo declInfo;
        Contract.verify((msgId > 0 ? 1 : 0) != 0, (String)"msgId muss > 0 sein.");
        Contract.verify((declId > 0 ? 1 : 0) != 0, (String)"declId muss > 0 sein.");
        String result = null;
        if (this.declarationInfos != null && (declInfo = this.declarationInfos.getDeclarationInfo(msgId, declId)) != null) {
            result = declInfo.getDataInspectionSDFResourceId();
        }
        return result;
    }

    public String getCollectorCorrection(int msgId, int declId) {
        InspectionReporter.DeclarationInfo declInfo;
        Contract.verify((msgId > 0 ? 1 : 0) != 0, (String)"msgId muss > 0 sein.");
        Contract.verify((declId > 0 ? 1 : 0) != 0, (String)"declId muss > 0 sein.");
        String result = null;
        if (this.declarationInfos != null && (declInfo = this.declarationInfos.getDeclarationInfo(msgId, declId)) != null) {
            result = declInfo.getCollectorCorrection();
        }
        return result;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Pr\u00fcfstufe:                      ");
        buffer.append(this.level);
        buffer.append(lineSeparator);
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        buffer.append("Zeitpunkt der Erstellung:       ");
        buffer.append(formatter.format(this.date));
        buffer.append(lineSeparator);
        buffer.append("Pr\u00fcfergebnis:                   ");
        if (this.isOk()) {
            buffer.append("ok");
        } else {
            buffer.append("fehlerhaft");
        }
        buffer.append(lineSeparator);
        buffer.append("DatML/RAW-Version:              ");
        buffer.append(this.datMlRawVersion);
        buffer.append(lineSeparator);
        buffer.append("Zeichensatz:                    ");
        buffer.append(this.charset);
        buffer.append(lineSeparator);
        buffer.append("Anzahl der Nachrichten:         ");
        buffer.append(this.msgnum);
        buffer.append(lineSeparator);
        buffer.append("Anzahl der Meldungen:           ");
        buffer.append(this.declnum);
        buffer.append(lineSeparator);
        buffer.append("Anzahl der gefundenen Probleme: ");
        buffer.append(this.getNumOfProblems());
        if (this.problems.size() > 0) {
            buffer.append(lineSeparator);
            buffer.append(lineSeparator);
            buffer.append("Problemliste:");
            buffer.append(lineSeparator);
            buffer.append("--------------------------------------------------------");
            for (int i = 0; i < this.problems.size(); ++i) {
                InspectionProblem problem = (InspectionProblem)this.problems.get(i);
                buffer.append(lineSeparator);
                buffer.append(problem);
                buffer.append(lineSeparator);
                buffer.append("--------------------------------------------------------");
            }
        }
        return buffer.toString();
    }
}

