/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;

public class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    byte[] stringToFullByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[i * 2] = (byte)((c & 0xFF00) >> 8);
            byArray[i * 2 + 1] = (byte)(c & 0xFF);
        }
        return byArray;
    }

    public static byte[] hexToByte(String string) throws IOException {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        if (string.length() % 2 != 0) {
            throw new IOException("hexadecimal string with odd number of characters");
        }
        for (int i = 0; i < n; ++i) {
            char c;
            int n3;
            if ((n3 = HEXINDEX.indexOf(c = string.charAt(n2++))) == -1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            int n4 = (n3 & 0xF) << 4;
            c = string.charAt(n2++);
            n3 = HEXINDEX.indexOf(c);
            byArray[i] = (byte)(n4 += n3 & 0xF);
        }
        return byArray;
    }

    public static String byteToHex(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[i] & 0xFF;
            cArray[n2++] = HEXCHAR[n3 >> 4 & 0xF];
            cArray[n2++] = HEXCHAR[n3 & 0xF];
        }
        return new String(cArray);
    }

    public static String byteToString(byte[] byArray, String string) {
        try {
            return string == null ? new String(byArray) : new String(byArray, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String unicodeToHexString(String string) {
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        try {
            StringConverter.writeUTF(string, hsqlByteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return StringConverter.byteToHex(hsqlByteArrayOutputStream.toByteArray());
    }

    public static String hexStringToUnicode(String string) throws IOException {
        byte[] byArray = StringConverter.hexToByte(string);
        return StringConverter.readUTF(byArray, 0, byArray.length);
    }

    public static int unicodeToAscii(OutputStream outputStream, String string, boolean bl) throws IOException {
        int n = 0;
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (i < n2 - 1 && string.charAt(i + 1) == 'u') {
                    outputStream.write(c);
                    outputStream.write(117);
                    outputStream.write(48);
                    outputStream.write(48);
                    outputStream.write(53);
                    outputStream.write(99);
                    n += 6;
                    continue;
                }
                outputStream.write(c);
                ++n;
                continue;
            }
            if (c >= ' ' && c <= '\u007f') {
                outputStream.write(c);
                ++n;
                if (c != '\'' || !bl) continue;
                outputStream.write(c);
                ++n;
                continue;
            }
            outputStream.write(92);
            outputStream.write(117);
            outputStream.write(HEXCHAR[c >> 12 & 0xF]);
            outputStream.write(HEXCHAR[c >> 8 & 0xF]);
            outputStream.write(HEXCHAR[c >> 4 & 0xF]);
            outputStream.write(HEXCHAR[c & 0xF]);
            n += 6;
        }
        return n;
    }

    public static String asciiToUnicode(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            if (by == 92 && i < n2 - 5) {
                byte by2 = byArray[n + i + 1];
                if (by2 == 117) {
                    ++i;
                    int n4 = HEXINDEX.indexOf(byArray[n + ++i]) << 12;
                    n4 += HEXINDEX.indexOf(byArray[n + ++i]) << 8;
                    n4 += HEXINDEX.indexOf(byArray[n + ++i]) << 4;
                    cArray[n3++] = (char)(n4 += HEXINDEX.indexOf(byArray[n + ++i]));
                    continue;
                }
                cArray[n3++] = (char)by;
                continue;
            }
            cArray[n3++] = (char)by;
        }
        return new String(cArray, 0, n3);
    }

    public static String asciiToUnicode(String string) {
        if (string == null || string.indexOf("\\u") == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < n - 5) {
                char c2 = string.charAt(i + 1);
                if (c2 == 'u') {
                    ++i;
                    int n3 = HEXINDEX.indexOf(string.charAt(++i)) << 12;
                    n3 += HEXINDEX.indexOf(string.charAt(++i)) << 8;
                    n3 += HEXINDEX.indexOf(string.charAt(++i)) << 4;
                    cArray[n2++] = (char)(n3 += HEXINDEX.indexOf(string.charAt(++i)));
                    continue;
                }
                cArray[n2++] = c;
                continue;
            }
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }

    public static String readUTF(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        block4: while (n4 < n2) {
            int n5 = byArray[n + n4];
            if (n3 > cArray.length - 4) {
                cArray = (char[])ArrayUtil.resizeArray(cArray, cArray.length + n2);
            }
            if (n5 > 0) {
                ++n4;
                cArray[n3++] = (char)n5;
                continue;
            }
            switch ((n5 &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((n4 += 2) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n4 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n5 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
                case 14: {
                    if ((n4 += 3) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n4 - 2];
                    byte by2 = byArray[n + n4 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n5 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block4;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n3);
    }

    public static int writeUTF(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
                n2 += 3;
                continue;
            }
            outputStream.write(0xC0 | c >> 6 & 0x1F);
            outputStream.write(0x80 | c >> 0 & 0x3F);
            n2 += 2;
        }
        return n2;
    }

    public static int getUTFSize(String string) {
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static String inputStreamToString(InputStream inputStream, int n) throws IOException {
        int n2;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        int n3 = 8192;
        char[] cArray = new char[n3];
        for (int i = n; i > 0 && (n2 = inputStreamReader.read(cArray, 0, i > n3 ? n3 : i)) != -1; i -= n2) {
            stringWriter.write(cArray, 0, n2);
        }
        stringWriter.close();
        return stringWriter.toString();
    }

    public static String toQuotedString(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = bl ? StringConverter.count(string, c) : 0;
        int n2 = string.length();
        char[] cArray = new char[2 + n + n2];
        int n3 = 0;
        cArray[n3++] = c;
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            cArray[n3++] = c2;
            if (!bl || c2 != c) continue;
            cArray[n3++] = c2;
        }
        cArray[n3] = c;
        return new String(cArray);
    }

    static int count(String string, char c) {
        int n = 0;
        int n2 = 0;
        if (string != null) {
            while ((n = string.indexOf(c, n)) > -1) {
                ++n2;
                ++n;
            }
        }
        return n2;
    }
}

