/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.EventInfo;
import org.dbforms.config.Table;
import org.dbforms.config.TableEvents;
import org.dbforms.event.DatabaseEvent;
import org.dbforms.event.DatabaseEventFactory;
import org.dbforms.event.KeyInfo;
import org.dbforms.event.WebEvent;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.StringUtil;

public class DatabaseEventFactoryImpl
extends DatabaseEventFactory {
    private static final Class[] keyInfoConstructorArgsTypes = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = DatabaseEventFactoryImpl.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = DatabaseEventFactoryImpl.class$("java.lang.String")) : class$java$lang$String, class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = DatabaseEventFactoryImpl.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest, class$org$dbforms$config$DbFormsConfig == null ? (class$org$dbforms$config$DbFormsConfig = DatabaseEventFactoryImpl.class$("org.dbforms.config.DbFormsConfig")) : class$org$dbforms$config$DbFormsConfig};
    private static DatabaseEventFactory instance = null;
    private static Log logCat = LogFactory.getLog((Class)(class$org$dbforms$event$NavEventFactoryImpl == null ? (class$org$dbforms$event$NavEventFactoryImpl = DatabaseEventFactoryImpl.class$("org.dbforms.event.NavEventFactoryImpl")) : class$org$dbforms$event$NavEventFactoryImpl));
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$org$dbforms$config$DbFormsConfig;
    static /* synthetic */ Class class$org$dbforms$event$NavEventFactoryImpl;

    public static synchronized DatabaseEventFactory instance() {
        if (instance == null) {
            instance = new DatabaseEventFactoryImpl();
        }
        return instance;
    }

    public WebEvent createEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        WebEvent event = null;
        Object[] constructorArgs = null;
        String eventId = this.getEventIdFromDestinationTable(request, action);
        EventInfo einfo = this.getEventInfo(eventId);
        logCat.info((Object)("::createEvent - got event [" + einfo + "] from action [" + action + "]"));
        if (!this.isKeyInfoEvent(action)) {
            constructorArgs = new Object[]{action, request, config};
            event = this.getEvent(einfo, constructorArgsTypes, constructorArgs);
        } else {
            KeyInfo kInfo = this.getKeyInfo(action, request);
            constructorArgs = new Object[]{new Integer(kInfo.getTableId()), kInfo.getKeyId(), request, config};
            event = this.getEvent(einfo, keyInfoConstructorArgsTypes, constructorArgs);
        }
        return event;
    }

    public DatabaseEvent createInsertEvent(int tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        DatabaseEvent event = null;
        Object[] constructorArgs = new Object[]{new Integer(tableId), keyId, request, config};
        Table table = config.getTable(tableId);
        TableEvents tableEvents = table.getTableEvents();
        String eventId = tableEvents.getEventId("insert");
        EventInfo einfo = this.getEventInfo(eventId);
        event = (DatabaseEvent)this.getEvent(einfo, keyInfoConstructorArgsTypes, constructorArgs);
        return event;
    }

    public DatabaseEvent createUpdateEvent(int tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        DatabaseEvent event = null;
        Object[] constructorArgs = new Object[]{new Integer(tableId), keyId, request, config};
        Table table = config.getTable(tableId);
        TableEvents tableEvents = table.getTableEvents();
        String eventId = tableEvents.getEventId("update");
        EventInfo einfo = this.getEventInfo(eventId);
        event = (DatabaseEvent)this.getEvent(einfo, keyInfoConstructorArgsTypes, constructorArgs);
        return event;
    }

    protected void initializeEvents() throws Exception {
        this.addEventInfo(new EventInfo("delete", "org.dbforms.event.datalist.DeleteEvent"));
        this.addEventInfo(new EventInfo("insert", "org.dbforms.event.datalist.InsertEvent"));
        this.addEventInfo(new EventInfo("update", "org.dbforms.event.datalist.UpdateEvent"));
    }

    private KeyInfo getKeyInfo(String action, HttpServletRequest request) {
        KeyInfo keyInfo = null;
        String associatedRadioName = ParseUtil.getParameter(request, "data" + action + "_arname");
        String keyString = ParseUtil.getParameter(request, associatedRadioName);
        if (keyString != null) {
            int tableId = StringUtil.getEmbeddedStringAsInteger(keyString, 0, '_');
            String keyId = StringUtil.getEmbeddedString(keyString, 1, '_');
            keyInfo = new KeyInfo();
            keyInfo.setTableId(tableId);
            keyInfo.setKeyId(keyId);
        }
        return keyInfo;
    }

    private boolean isKeyInfoEvent(String action) {
        boolean keyInfo = false;
        if (action.startsWith("ac_updatear_") || action.startsWith("ac_deletear_")) {
            keyInfo = true;
        }
        return keyInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

