/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.dom;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.domapi.XPathEvaluatorImpl;
import org.dbforms.dom.DOMFactory;
import org.dbforms.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.xpath.XPathEvaluator;
import org.xml.sax.InputSource;

public class DOMFactoryXALANImpl
extends DOMFactory {
    private DocumentBuilder builder = this.createDOMBuilder();
    private Log logCat = LogFactory.getLog((String)this.getClass().getName());
    private Transformer transformer = this.createDOMWriter();

    public String DOM2String(Document doc) {
        StringWriter writer = new StringWriter();
        try {
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(doc);
            this.transformer.transform(source, result);
        }
        catch (Exception e) {
            this.logCat.error((Object)"write", (Throwable)e);
        }
        String s = writer.toString();
        return s;
    }

    public Document String2DOM(String data) {
        Document doc = null;
        if (!Util.isNull(data)) {
            try {
                InputSource in = new InputSource(new StringReader(data));
                doc = this.builder.parse(in);
            }
            catch (Exception e) {
                this.logCat.error((Object)(e.getMessage() + "\n" + data));
            }
        }
        return doc;
    }

    public Document newDOMDocument() {
        return this.builder.newDocument();
    }

    public XPathEvaluator newXPathEvaluator() {
        return new XPathEvaluatorImpl();
    }

    public Document read(InputStream in) {
        Document doc = null;
        try {
            InputSource src = new InputSource(in);
            doc = this.builder.parse(src);
        }
        catch (Exception e) {
            this.logCat.error((Object)e);
        }
        return doc;
    }

    public void write(OutputStream out, Element root) {
        try {
            StreamResult result = new StreamResult(out);
            DOMSource source = new DOMSource(root);
            this.transformer.transform(source, result);
        }
        catch (Exception e) {
            this.logCat.error((Object)"write", (Throwable)e);
        }
    }

    private DocumentBuilder createDOMBuilder() {
        DocumentBuilder res = null;
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setValidating(false);
            dfactory.setNamespaceAware(false);
            res = dfactory.newDocumentBuilder();
        }
        catch (Exception e) {
            this.logCat.error((Object)e);
        }
        return res;
    }

    private Transformer createDOMWriter() {
        Transformer res = null;
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            res = transFactory.newTransformer();
        }
        catch (Exception e) {
            this.logCat.error((Object)"createDOMWriter", (Throwable)e);
        }
        return res;
    }
}

