/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.FieldValue;
import org.dbforms.config.Table;
import org.dbforms.util.IEscaper;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.ReflectionUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class Field
implements Serializable {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$config$Field == null ? (class$org$dbforms$config$Field = Field.class$("org.dbforms.config.Field")) : class$org$dbforms$config$Field).getName());
    private IEscaper escaper = null;
    private String directory = null;
    private String escaperClass = null;
    private String expression = null;
    private String fieldType = null;
    private String key = "false";
    private String name;
    private Table table = null;
    private boolean encoded = false;
    private boolean isAutoInc = false;
    private boolean isSortable = false;
    private int id;
    private int size = -1;
    private int type;
    static /* synthetic */ Class class$org$dbforms$config$Field;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void setAutoInc(String autoInc) {
        this.isAutoInc = Util.getTrue(autoInc);
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setEncoding(String encoding) {
        this.encoded = Util.getTrue(encoding);
    }

    public IEscaper getEscaper() {
        if (this.escaper == null) {
            String s = this.getEscaperClass();
            if (!Util.isNull(s)) {
                try {
                    this.escaper = (IEscaper)ReflectionUtil.newInstance(s);
                }
                catch (Exception e) {
                    logCat.error((Object)("cannot create the new escaper [" + s + "]"), (Throwable)e);
                }
            }
            if (this.escaper == null) {
                if (this.getTable() == null) {
                    try {
                        this.escaper = DbFormsConfigRegistry.instance().lookup().getEscaper();
                    }
                    catch (Exception e) {
                        logCat.error((Object)"cannot create the new default escaper", (Throwable)e);
                    }
                } else {
                    this.escaper = this.getTable().getEscaper();
                }
            }
        }
        return this.escaper;
    }

    public void setEscaperClass(String string) {
        this.escaperClass = string;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getFieldName(String core) {
        StringBuffer sb = new StringBuffer(core);
        sb.append(this.getTable().getId());
        sb.append("_");
        sb.append(this.getId());
        return sb.toString();
    }

    public void setFieldType(String aFieldType) {
        this.fieldType = aFieldType.toLowerCase();
        if (this.fieldType.startsWith("char") || this.fieldType.startsWith("varchar") || this.fieldType.startsWith("nvarchar") || this.fieldType.startsWith("longchar") || this.fieldType.startsWith("long varchar") || this.fieldType.startsWith("text")) {
            this.type = 1;
        } else if (this.fieldType.startsWith("int") || this.fieldType.startsWith("smallint") || this.fieldType.startsWith("long") || this.fieldType.startsWith("tinyint")) {
            this.type = 4;
        } else if (this.fieldType.startsWith("numeric") || this.fieldType.startsWith("number") || this.fieldType.startsWith("decimal")) {
            this.type = 2;
        } else if (this.fieldType.startsWith("date")) {
            this.type = 91;
        } else if (this.fieldType.startsWith("timestamp")) {
            this.type = 93;
        } else if (this.fieldType.startsWith("time")) {
            this.type = 92;
        } else if (this.fieldType.startsWith("double") || this.fieldType.startsWith("float")) {
            this.type = 8;
        } else if (this.fieldType.startsWith("real")) {
            this.type = 6;
        } else if (this.fieldType.startsWith("blob") || this.fieldType.startsWith("image")) {
            this.type = 2004;
        } else if (this.fieldType.startsWith("diskblob")) {
            this.type = 4200;
        } else if (this.fieldType.startsWith("bool")) {
            this.type = 16;
        }
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public Format getFormat(String pattern, Locale locale) {
        switch (this.getType()) {
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            default: {
                return null;
            }
        }
        Format res = null;
        int dateStyle = 2;
        int timeStyle = 3;
        if (Util.isNull(pattern)) {
            pattern = MessageResourcesInternal.getMessage("dbforms.pattern." + this.getFieldType(), locale);
        }
        if (!Util.isNull(pattern)) {
            if ("short".startsWith(pattern.toLowerCase())) {
                dateStyle = 3;
                pattern = MessageResourcesInternal.getMessage("dbforms.pattern." + this.getFieldType() + "." + pattern, locale);
            } else if ("medium".startsWith(pattern.toLowerCase())) {
                dateStyle = 2;
                pattern = MessageResourcesInternal.getMessage("dbforms.pattern." + this.getFieldType() + "." + pattern, locale);
            } else if ("long".startsWith(pattern.toLowerCase())) {
                dateStyle = 1;
                pattern = MessageResourcesInternal.getMessage("dbforms.pattern." + this.getFieldType() + "." + pattern, locale);
            } else if ("full".startsWith(pattern.toLowerCase())) {
                dateStyle = 0;
                pattern = MessageResourcesInternal.getMessage("dbforms.pattern." + this.getFieldType() + "." + pattern, locale);
            }
        }
        switch (this.getType()) {
            case 4: {
                try {
                    res = NumberFormat.getIntegerInstance(locale);
                }
                catch (NoSuchMethodError nsme) {
                    res = NumberFormat.getNumberInstance(locale);
                }
                ((DecimalFormat)res).setParseIntegerOnly(true);
                if (Util.isNull(pattern)) break;
                try {
                    ((DecimalFormat)res).applyPattern(pattern);
                }
                catch (Exception e) {
                    logCat.error((Object)pattern, (Throwable)e);
                }
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                res = NumberFormat.getNumberInstance(locale);
                if (Util.isNull(pattern)) break;
                try {
                    ((DecimalFormat)res).applyPattern(pattern);
                }
                catch (Exception e) {
                    logCat.error((Object)pattern, (Throwable)e);
                }
                break;
            }
            case 91: {
                res = DateFormat.getDateInstance(dateStyle, locale);
                if (Util.isNull(pattern)) break;
                try {
                    ((SimpleDateFormat)res).applyPattern(pattern);
                }
                catch (Exception e) {
                    logCat.error((Object)pattern, (Throwable)e);
                }
                break;
            }
            case 92: {
                res = DateFormat.getTimeInstance(timeStyle, locale);
                if (Util.isNull(pattern)) break;
                try {
                    ((SimpleDateFormat)res).applyPattern(pattern);
                }
                catch (Exception e) {
                    logCat.error((Object)pattern, (Throwable)e);
                }
                break;
            }
            case 93: {
                res = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                if (Util.isNull(pattern)) break;
                try {
                    ((SimpleDateFormat)res).applyPattern(pattern);
                }
                catch (Exception e) {
                    logCat.error((Object)pattern, (Throwable)e);
                }
                break;
            }
        }
        return res;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setIsKey(String value) {
        this.key = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSortable(String sortable) {
        this.isSortable = Util.getTrue(sortable);
    }

    public int getType() {
        return this.type;
    }

    public void setTypeByObject(Object obj) {
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        Vector v = StringUtil.splitString(clazz.getName().toLowerCase(), ".");
        this.fieldType = (String)v.lastElement();
        if (clazz.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = Field.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            this.type = 4;
        } else if (clazz.isAssignableFrom(class$java$lang$Long == null ? (class$java$lang$Long = Field.class$("java.lang.Long")) : class$java$lang$Long)) {
            this.type = 4;
        } else if (clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = Field.class$("java.lang.String")) : class$java$lang$String)) {
            this.type = 1;
        } else if (clazz.isAssignableFrom(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Field.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            this.type = 2;
        } else if (clazz.isAssignableFrom(class$java$sql$Date == null ? (class$java$sql$Date = Field.class$("java.sql.Date")) : class$java$sql$Date)) {
            this.type = 91;
        } else if (clazz.isAssignableFrom(class$java$sql$Time == null ? (class$java$sql$Time = Field.class$("java.sql.Time")) : class$java$sql$Time)) {
            this.type = 92;
        } else if (clazz.isAssignableFrom(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Field.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            this.type = 93;
        } else if (clazz.isAssignableFrom(class$java$lang$Double == null ? (class$java$lang$Double = Field.class$("java.lang.Double")) : class$java$lang$Double)) {
            this.type = 8;
        } else if (clazz.isAssignableFrom(class$java$lang$Float == null ? (class$java$lang$Float = Field.class$("java.lang.Float")) : class$java$lang$Float)) {
            this.type = 6;
        } else if (clazz.isAssignableFrom(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Field.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            this.type = 16;
        }
    }

    public static final String dumpFieldValueArray(FieldValue[] fv) {
        String s = null;
        if (fv != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < fv.length; ++i) {
                FieldValue f = fv[i];
                sb.append("  fv[").append(i).append("] = {").append(f.toString()).append("}\n");
            }
            s = sb.toString();
        }
        return s;
    }

    public String getEscaperClass() {
        return this.escaperClass;
    }

    public String getSearchAlgoName() {
        return this.getFieldName("searchalgo_");
    }

    public String getSearchFieldName() {
        return this.getFieldName("search_");
    }

    public String getSearchModeName() {
        return this.getFieldName("searchmode_");
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public String getSortFieldName() {
        return this.getFieldName("sort_");
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean hasAutoIncSet() {
        return this.isAutoInc;
    }

    public boolean hasEncodedSet() {
        return this.encoded;
    }

    public boolean hasIsKeySet() {
        return Util.getTrue(this.key);
    }

    public boolean hasSortableSet() {
        return this.isSortable;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("name=");
        buf.append(this.name);
        buf.append(" type=");
        buf.append(this.type);
        buf.append(" key=");
        buf.append(this.key);
        buf.append(" isAutoinc=");
        buf.append(this.isAutoInc);
        buf.append(" issortable=");
        buf.append(this.isSortable);
        buf.append(" directory=");
        buf.append(this.directory);
        buf.append(" expression=");
        buf.append(this.expression);
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

