/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource.util;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.resource.DatmlSdfSource;
import de.destatis.core.resource.Resource;
import de.destatis.core.resource.ResourceType;
import de.destatis.core.resource.SDFMetaResource;
import de.destatis.core.resource.util.GetResourceQuery;
import de.destatis.core.resource.util.SDFResourceConstants;
import java.util.regex.Pattern;

public abstract class AbstractGetSurveyResourceQuery
extends GetResourceQuery {
    protected Pattern resourceTypePattern;

    public AbstractGetSurveyResourceQuery(ResourceType type) {
        super(type);
        this.resourceTypePattern = AbstractGetSurveyResourceQuery.getTypePattern(type);
    }

    @Override
    public Resource createResource(String resourceId, byte[] resourceData) {
        Resource resource = null;
        ResourceType type = this.getResourceType();
        if (ResourceType.TYPE_DATML_SDF.equals(type)) {
            resource = new DatmlSdfSource(resourceId, resourceData);
        } else if (ResourceType.TYPE_SDFMETA.equals(type)) {
            resource = new SDFMetaResource(resourceId, resourceData);
        } else {
            throw new IllegalStateException("Unbekannter Ressourcetyp '" + type + "'.");
        }
        return resource;
    }

    private static Pattern getTypePattern(ResourceType type) {
        Pattern pattern = null;
        if (ResourceType.TYPE_DATML_SDF.equals(type)) {
            pattern = SDFResourceConstants.SDF_RESOURCE_TYPE_PATTERN;
        }
        Contract.verify(pattern != null, "Unbekannter ResourceTyp");
        return pattern;
    }
}

