/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.document;

import de.destatis.core.connect.document.DocumentSource;
import de.destatis.core.connect.document.util.ReadXmlEncodingParser;
import de.destatis.core.connect.util.Contract;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class StringDocumentSource
implements DocumentSource {
    private String content;
    private Long length;
    private String charset;

    protected StringDocumentSource(String content) {
        Contract.verify(content != null, "content ist erforderlich");
        this.content = content;
        ReadXmlEncodingParser parser = new ReadXmlEncodingParser();
        try {
            String charset = parser.getEncoding(new ByteArrayInputStream(this.getUTF8Bytes()));
            if (charset == null) {
                throw new IllegalArgumentException("Der Zeichensatz des XML-Dokuments konnte nicht ermittelt werden.");
            }
            this.charset = charset;
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
    }

    @Override
    public InputStream getInputStream() {
        byte[] bytes = this.getBytes();
        this.length = new Long(bytes.length);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return in;
    }

    @Override
    public String getEncoding() {
        return this.charset;
    }

    @Override
    public long getLength() {
        if (this.length == null) {
            byte[] bytes = this.getBytes();
            this.length = new Long(bytes.length);
        }
        return this.length;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void release() {
        this.content = null;
        this.length = null;
    }

    private byte[] getBytes() {
        return this.getBytes(this.charset);
    }

    private byte[] getUTF8Bytes() {
        return this.getBytes("UTF-8");
    }

    private byte[] getBytes(String charset) {
        try {
            return this.content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

