/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.CheckDeliveryRequest;
import de.destatis.core.connect.Client;
import de.destatis.core.connect.DataDelivery;
import de.destatis.core.connect.GetSurveyDefinitionResourceRequest;
import de.destatis.core.connect.InspectionLevel;
import de.destatis.core.connect.PingRequest;
import de.destatis.core.connect.ProtocolRequest;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToCheckDeliveryRequest;
import de.destatis.core.connect.ResponseToDataDelivery;
import de.destatis.core.connect.ResponseToGetResourceRequest;
import de.destatis.core.connect.ResponseToPingRequest;
import de.destatis.core.connect.ResponseToProtocolRequest;
import de.destatis.core.connect.SimpleClientResponseException;
import de.destatis.core.connect.document.DatMLRawDocument;
import de.destatis.core.connect.document.DatMLResDocument;
import de.destatis.core.connect.document.DocumentSource;
import de.destatis.core.connect.document.DocumentSourceFactory;
import de.destatis.core.connect.document.ValidationException;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.resource.DatmlSdfSource;
import de.werum.sis.xmlgen.XMLGeneratorUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Properties;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SimpleClient {
    private static final String XML_USERNAME = "username";
    private static final String XML_PASSWORD = "password";
    private static final String XML_PROTOCOL = "protocol";
    private static final String XML_COMPRESSION = "compression";
    private static final String XML_ADDRESS_PRESELECTION = "addresspreselection";
    private static final String XML_ADDRESS_USE_URI = "addressuseuri";
    private static final String XML_PROXY_HOST = "proxyhost";
    private static final String XML_PROXY_PORT = "proxyport";
    private static final String XML_PROXY_USER = "proxyuser";
    private static final String XML_PROXY_PASSWORD = "proxypassword";
    private static final String XML_PROXY_DOMAIN = "proxydomain";
    private static final String XML_PROXY_AUTH_METHOD = "proxyauthmethod";
    private static final String XML_ROOT = "connprops";
    private static final String XML_NEWLINE = System.getProperty("line.separator");
    private final BASE64Encoder encoder = new BASE64Encoder();
    private final BASE64Decoder decoder = new BASE64Decoder();

    public SimpleClient() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
    }

    public void validate(String datmlXml) throws ValidationException {
        DatMLRawDocument document = new DatMLRawDocument();
        document.setDocument(datmlXml);
        document.validate();
    }

    public String makeConnectionProperties(String id, String password) {
        Properties properties = new Properties();
        properties.setProperty("client.username", id);
        properties.setProperty("client.password", password);
        return this.getPropertiesAsXml(properties);
    }

    public String makeConnectionProperties(String configFileName) throws Exception {
        FileInputStream stream = new FileInputStream(configFileName);
        Properties properties = new Properties();
        properties.load(stream);
        try {
            stream.close();
        }
        catch (Exception exc) {
            ClientLogger logger = ClientLogger.getLogger(this.getClass());
            logger.error("Fehler beim Schliessen der Eingabedatei:", exc);
        }
        return this.getPropertiesAsXml(properties);
    }

    public String makeConnectionProperties(String id, String password, String configFileName) throws Exception {
        FileInputStream stream = new FileInputStream(configFileName);
        Properties properties = new Properties();
        properties.load(stream);
        properties.setProperty("client.username", id);
        properties.setProperty("client.password", password);
        try {
            stream.close();
        }
        catch (Exception exc) {
            ClientLogger logger = ClientLogger.getLogger(this.getClass());
            logger.error("Fehler beim Schliessen der Eingabedatei:", exc);
        }
        return this.getPropertiesAsXml(properties);
    }

    public String sendMessage(String datmlXml, String connProps) throws Exception {
        String result = null;
        Client client = null;
        DatMLRawDocument document = null;
        DataDelivery delivery = null;
        ResponseToDataDelivery response = null;
        ClientConfig config = new ClientConfig(this.readPropertiesFromXml(connProps));
        client = new Client(config.getUserName(), config.getPassword(), config.getProperties());
        document = new DatMLRawDocument();
        document.setDocument(datmlXml);
        delivery = new DataDelivery(document);
        response = client.send(delivery);
        if (response != null) {
            if (response.getStatus() == ResponseStatus.OK) {
                result = response.getEntryStamp();
            } else {
                throw new SimpleClientResponseException(response.getErrorText(), response.getStatus());
            }
        }
        return result;
    }

    public String sendMessageAndGetProtocol(String datmlXml, String connProps) throws Exception {
        String result = null;
        Client client = null;
        DatMLRawDocument document = null;
        DataDelivery delivery = null;
        ResponseToDataDelivery response = null;
        ClientConfig config = new ClientConfig(this.readPropertiesFromXml(connProps));
        client = new Client(config.getUserName(), config.getPassword(), config.getProperties());
        document = new DatMLRawDocument();
        document.setDocument(datmlXml);
        delivery = new DataDelivery(document);
        response = client.send(delivery);
        if (response != null) {
            if (response.getStatus() == ResponseStatus.OK) {
                DatMLResDocument protocol = response.getProtocol();
                result = protocol == null ? response.getEntryStamp() : protocol.getDocument();
            } else {
                throw new SimpleClientResponseException(response.getErrorText(), response.getStatus());
            }
        }
        return result;
    }

    public String sendFile(String filePath, String connProps) throws Exception {
        String result = null;
        Client client = null;
        DatMLRawDocument document = null;
        DataDelivery delivery = null;
        ResponseToDataDelivery response = null;
        ClientConfig config = new ClientConfig(this.readPropertiesFromXml(connProps));
        client = new Client(config.getUserName(), config.getPassword(), config.getProperties());
        File file = new File(filePath);
        DocumentSource documentSource = DocumentSourceFactory.createDocumentSource(file);
        document = new DatMLRawDocument();
        document.setDocument(documentSource);
        delivery = new DataDelivery(document, file.getName());
        response = client.send(delivery);
        if (response != null) {
            if (response.getStatus() == ResponseStatus.OK) {
                DatMLResDocument protocol = response.getProtocol();
                result = protocol == null ? response.getEntryStamp() : protocol.getDocument();
            } else {
                throw new SimpleClientResponseException(response.getErrorText(), response.getStatus());
            }
        }
        return result;
    }

    public String fetchProtocol(String entryStamp, String datmlResVersion, String connProps) throws Exception {
        ResponseToProtocolRequest response;
        String result = null;
        ClientConfig config = new ClientConfig(this.readPropertiesFromXml(connProps));
        Client client = new Client(config.getUserName(), config.getPassword(), config.getProperties());
        ProtocolRequest protocolRequest = new ProtocolRequest(entryStamp);
        if (datmlResVersion != null) {
            protocolRequest.setDatMLResVersion(datmlResVersion);
        }
        if ((response = client.send(protocolRequest)) != null) {
            if (response.getStatus() == ResponseStatus.OK) {
                result = response.getProtocol().getDocument();
            } else {
                throw new SimpleClientResponseException(response.getErrorText(), response.getStatus());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetchSurveyDefinition(String statisticId, String referencePeriod, String collector, String resourceId, String connProps) throws Exception {
        GetSurveyDefinitionResourceRequest surveyRequest;
        String result = null;
        ClientConfig config = new ClientConfig(this.readPropertiesFromXml(connProps));
        Client client = new Client(config.getUserName(), config.getPassword(), config.getProperties());
        ResponseToGetResourceRequest response = client.send(surveyRequest = new GetSurveyDefinitionResourceRequest(statisticId, collector, referencePeriod, resourceId));
        if (response != null) {
            if (response.getStatus() == ResponseStatus.OK) {
                byte[] data = response.getResourceData();
                DatmlSdfSource resource = new DatmlSdfSource(response.getResourceId(), data);
                StringWriter writer = null;
                Reader reader = null;
                try {
                    int len;
                    writer = new StringWriter(data.length);
                    reader = resource.getReader();
                    char[] buffer = new char[4096];
                    while ((len = reader.read(buffer)) > 0) {
                        writer.write(buffer, 0, len);
                    }
                    writer.close();
                    try {
                        reader.close();
                        reader = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    result = writer.toString();
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception e) {}
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            throw new SimpleClientResponseException(response.getErrorText(), response.getStatus());
        }
        return result;
    }

    public String checkMessage(String datmlXml, String connProps) throws Exception {
        return this.checkMessage(datmlXml, connProps, -1);
    }

    public String checkMessage(String datmlXml, String connProps, int inspectionLevel) throws Exception {
        String result = null;
        Client client = null;
        DatMLRawDocument document = null;
        CheckDeliveryRequest checkRequest = null;
        ResponseToCheckDeliveryRequest response = null;
        ClientConfig config = new ClientConfig(this.readPropertiesFromXml(connProps));
        client = new Client(config.getUserName(), config.getPassword(), config.getProperties());
        document = new DatMLRawDocument();
        document.setDocument(datmlXml);
        checkRequest = new CheckDeliveryRequest(document);
        if (inspectionLevel != -1) {
            if (inspectionLevel == 1) {
                checkRequest.setInspectionLevel(InspectionLevel.SYNTAX);
            } else if (inspectionLevel == 2) {
                checkRequest.setInspectionLevel(InspectionLevel.SEMANTICS);
            } else if (inspectionLevel == 3) {
                checkRequest.setInspectionLevel(InspectionLevel.AUTHORIZATION);
            } else if (inspectionLevel == 4) {
                checkRequest.setInspectionLevel(InspectionLevel.DATA);
            } else {
                throw new IllegalArgumentException("Ungueltige Pruefstufe: " + inspectionLevel);
            }
        }
        if ((response = client.send(checkRequest)) != null) {
            if (response.getStatus() == ResponseStatus.OK) {
                result = response.getProtocol().getDocument();
            } else {
                throw new SimpleClientResponseException(response.getErrorText(), response.getStatus());
            }
        }
        return result;
    }

    public String checkFile(String filePath, String connProps, int inspectionLevel) throws Exception {
        String result = null;
        Client client = null;
        DatMLRawDocument document = null;
        CheckDeliveryRequest checkRequest = null;
        ResponseToCheckDeliveryRequest response = null;
        ClientConfig config = new ClientConfig(this.readPropertiesFromXml(connProps));
        client = new Client(config.getUserName(), config.getPassword(), config.getProperties());
        File file = new File(filePath);
        DocumentSource documentSource = DocumentSourceFactory.createDocumentSource(file);
        document = new DatMLRawDocument();
        document.setDocument(documentSource);
        checkRequest = new CheckDeliveryRequest(document);
        if (inspectionLevel != -1) {
            if (inspectionLevel == 1) {
                checkRequest.setInspectionLevel(InspectionLevel.SYNTAX);
            } else if (inspectionLevel == 2) {
                checkRequest.setInspectionLevel(InspectionLevel.SEMANTICS);
            } else if (inspectionLevel == 3) {
                checkRequest.setInspectionLevel(InspectionLevel.AUTHORIZATION);
            } else if (inspectionLevel == 4) {
                checkRequest.setInspectionLevel(InspectionLevel.DATA);
            } else {
                throw new IllegalArgumentException("Ungueltige Pruefstufe: " + inspectionLevel);
            }
        }
        if ((response = client.send(checkRequest)) != null) {
            if (response.getStatus() == ResponseStatus.OK) {
                result = response.getProtocol().getDocument();
            } else {
                throw new SimpleClientResponseException(response.getErrorText(), response.getStatus());
            }
        }
        return result;
    }

    public void ping(String connProps) throws Exception {
        PingRequest pingRequest;
        Client client;
        ResponseToPingRequest response;
        ClientConfig config = new ClientConfig(this.readPropertiesFromXml(connProps));
        String userName = config.getUserName();
        char[] password = config.getPassword();
        if (userName == null) {
            userName = "ping_kennung";
        }
        if (password == null) {
            password = "ping_password".toCharArray();
        }
        if ((response = (client = new Client(userName, password, config.getProperties())).send(pingRequest = new PingRequest())) != null && response.getStatus() != ResponseStatus.OK) {
            throw new SimpleClientResponseException(response.getErrorText(), response.getStatus());
        }
    }

    protected String getPropertiesAsXml(Properties properties) {
        StringBuffer xmlBuffer = new StringBuffer();
        xmlBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlBuffer.append(XML_NEWLINE);
        xmlBuffer.append("<connprops version=\"1.0\">");
        xmlBuffer.append(XML_NEWLINE);
        this.generateXml(xmlBuffer, XML_USERNAME, properties.getProperty("client.username"));
        this.generatePasswordXml(xmlBuffer, XML_PASSWORD, properties.getProperty("client.password"));
        this.generateXml(xmlBuffer, XML_PROTOCOL, properties.getProperty("client.protocol"));
        this.generateXml(xmlBuffer, XML_COMPRESSION, properties.getProperty("client.compression"));
        this.generateXml(xmlBuffer, XML_ADDRESS_PRESELECTION, properties.getProperty("client.address.preselection"));
        this.generateXml(xmlBuffer, XML_ADDRESS_USE_URI, properties.getProperty("client.address.useURI"));
        this.generateXml(xmlBuffer, XML_PROXY_HOST, properties.getProperty("client.proxy.host"));
        this.generateXml(xmlBuffer, XML_PROXY_PORT, properties.getProperty("client.proxy.port"));
        this.generateXml(xmlBuffer, XML_PROXY_USER, properties.getProperty("client.proxy.user"));
        this.generatePasswordXml(xmlBuffer, XML_PROXY_PASSWORD, properties.getProperty("client.proxy.password"));
        this.generateXml(xmlBuffer, XML_PROXY_DOMAIN, properties.getProperty("client.proxy.domain"));
        this.generateXml(xmlBuffer, XML_PROXY_AUTH_METHOD, properties.getProperty("client.proxy.authmethod"));
        xmlBuffer.append("</connprops>");
        xmlBuffer.append(XML_NEWLINE);
        return xmlBuffer.toString();
    }

    protected Properties readPropertiesFromXml(String connprops) throws Exception {
        ConnPropsXmlParser parser = new ConnPropsXmlParser();
        return parser.parseXmlProperties(connprops);
    }

    private void generateXml(StringBuffer buffer, String xmlElement, String value) {
        if (value != null && value.length() > 0) {
            buffer.append("   <" + xmlElement + ">");
            buffer.append(XMLGeneratorUtil.escapeStringXML((String)value));
            buffer.append("</" + xmlElement + ">");
            buffer.append(XML_NEWLINE);
        }
    }

    private void generatePasswordXml(StringBuffer buffer, String xmlElement, String password) {
        if (password != null && password.length() > 0) {
            buffer.append("   <" + xmlElement + ">");
            buffer.append(XMLGeneratorUtil.escapeStringXML((String)("[" + this.encoder.encode(password.getBytes()) + "]")));
            buffer.append("</" + xmlElement + ">");
            buffer.append(XML_NEWLINE);
        }
    }

    protected class ConnPropsXmlParser
    extends DefaultHandler {
        private char[] textBuffer = new char[4096];
        private int bufferIndex = 0;
        private static final int maxChars = 4096;
        Properties properties = null;

        public ConnPropsXmlParser() {
            Arrays.fill(this.textBuffer, ' ');
        }

        public Properties parseXmlProperties(String connProps) throws Exception {
            this.properties = new Properties();
            SAXParser parser = new SAXParser();
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            StringReader reader = new StringReader(connProps);
            parser.parse(new InputSource(reader));
            this.convertPasswords();
            return this.properties;
        }

        @Override
        public void endElement(String uri, String name, String raw) {
            String value = this.bufferIndex > 0 ? String.copyValueOf(this.textBuffer, 0, this.bufferIndex).trim() : "";
            if (SimpleClient.XML_USERNAME.equals(raw)) {
                this.properties.setProperty("client.username", value);
            } else if (SimpleClient.XML_PASSWORD.equals(raw)) {
                this.properties.setProperty("client.password", value);
            } else if (SimpleClient.XML_PROTOCOL.equals(raw)) {
                this.properties.setProperty("client.protocol", value);
            } else if (SimpleClient.XML_COMPRESSION.equals(raw)) {
                this.properties.setProperty("client.compression", value);
            } else if (SimpleClient.XML_ADDRESS_PRESELECTION.equals(raw)) {
                this.properties.setProperty("client.address.preselection", value);
            } else if (SimpleClient.XML_ADDRESS_USE_URI.equals(raw)) {
                this.properties.setProperty("client.address.useURI", value);
            } else if (SimpleClient.XML_PROXY_HOST.equals(raw)) {
                this.properties.setProperty("client.proxy.host", value);
            } else if (SimpleClient.XML_PROXY_PORT.equals(raw)) {
                this.properties.setProperty("client.proxy.port", value);
            } else if (SimpleClient.XML_PROXY_USER.equals(raw)) {
                this.properties.setProperty("client.proxy.user", value);
            } else if (SimpleClient.XML_PROXY_PASSWORD.equals(raw)) {
                this.properties.setProperty("client.proxy.password", value);
            } else if (SimpleClient.XML_PROXY_DOMAIN.equals(raw)) {
                this.properties.setProperty("client.proxy.domain", value);
            } else if (SimpleClient.XML_PROXY_AUTH_METHOD.equals(raw)) {
                this.properties.setProperty("client.proxy.authmethod", value);
            }
            this.clearTextBuffer();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            block4: for (int i = start; i < start + length && this.bufferIndex < 4096; ++i) {
                switch (ch[i]) {
                    case '\t': 
                    case '\r': {
                        continue block4;
                    }
                    case '\n': {
                        this.textBuffer[this.bufferIndex++] = 32;
                        continue block4;
                    }
                    default: {
                        this.textBuffer[this.bufferIndex++] = ch[i];
                    }
                }
            }
        }

        private void clearTextBuffer() {
            this.bufferIndex = 0;
        }

        protected void convertPasswords() throws IOException {
            String proxyPassword;
            String password = this.properties.getProperty("client.password");
            if (password != null && password.startsWith("[") && password.endsWith("]")) {
                password = password.substring(1, password.length() - 1);
                password = new String(SimpleClient.this.decoder.decodeBuffer(password));
                this.properties.setProperty("client.password", password);
            }
            if ((proxyPassword = this.properties.getProperty("client.proxy.password")) != null && proxyPassword.startsWith("[") && proxyPassword.endsWith("]")) {
                proxyPassword = proxyPassword.substring(1, proxyPassword.length() - 1);
                proxyPassword = new String(SimpleClient.this.decoder.decodeBuffer(proxyPassword));
                this.properties.setProperty("client.proxy.password", proxyPassword);
            }
        }
    }
}

