/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.util.Contract;

public abstract class Response {
    ResponseStatus status = null;
    String errorText = null;

    public Response(ResponseStatus status, String errorText) {
        Contract.verify(status != null, "Status ist nicht angegeben");
        Contract.verify(status.equals(ResponseStatus.OK) || errorText != null, "Kein Fehlertext angegeben");
        this.status = status;
        this.errorText = errorText;
    }

    public boolean isOK() {
        return this.status.equals(ResponseStatus.OK);
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public String getErrorText() throws IllegalStateException {
        if (this.status.equals(ResponseStatus.OK)) {
            throw new IllegalStateException("Es ist kein Fehler vorhanden");
        }
        return this.errorText;
    }
}

