/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.RenderFileAction;
import com.atlassian.clover.reporters.html.source.SourceRenderHelper;
import com.atlassian.clover.reporters.json.JSONObject;
import com.atlassian.clover.reporters.json.JSONReportUtils;
import com.atlassian.clover.spi.reporters.html.source.LineRenderInfo;
import com.atlassian.clover.util.CloverUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderFileJSONAction
extends RenderFileAction {
    public RenderFileJSONAction(FullFileInfo fileInfo, HtmlRenderingSupportImpl renderingHelper, Current report, VelocityContext velocity, CloverDatabase database, FullProjectInfo fullModel) {
        super(fileInfo, renderingHelper, report, velocity, database, fullModel, null);
    }

    @Override
    public void render() throws Exception {
        String basename = new File(this.fileInfo.getName()).getName();
        try {
            Map<String, Number> columnValues = JSONReportUtils.collectColumnValuesFor((List)columnsTL.get(), this.fileInfo, this.renderingHelper);
            SourceRenderHelper srh = new SourceRenderHelper(this.database, this.report, this.renderingHelper);
            FullFileInfo fcopy = this.fileInfo.copy((FullPackageInfo)this.fileInfo.getContainingPackage(), HasMetricsFilter.ACCEPT_ALL);
            LineRenderInfo[] lineInfos = srh.gatherSrcRenderInfo(this.velocity, fcopy, this.getContextSet(), "", this.testLineInfo);
            String apiJsonOutFilename = RenderFileJSONAction.createOutFileBaseName(basename) + "java.js";
            File apiJsonOutfile = CloverUtils.createOutFile(fcopy, apiJsonOutFilename, this.report.getOutFile());
            Collection<String> hitCounts = this.collectHitCounts(lineInfos);
            JSONObject json = new JSONObject();
            json.put("id", this.renderingHelper.getFileIdentifier(fcopy));
            json.put("stats", columnValues);
            json.put("lines", hitCounts);
            this.velocity.put("json", json.toString(2));
            this.velocity.put("callback", this.report.getFormat().getCallback());
            HtmlReportUtil.mergeTemplateToFile(apiJsonOutfile, this.velocity, "html_res/api-json.vm");
        }
        catch (Exception e) {
            Logger.getInstance().error("Invalid Java source found or Clover failed to parse it: " + this.fileInfo.getPhysicalFile().getAbsolutePath(), e);
        }
    }

    private Collection<String> collectHitCounts(LineRenderInfo[] lineInfos) {
        ArrayList<String> hitCounts = new ArrayList<String>();
        for (int i = 0; i < lineInfos.length; ++i) {
            LineRenderInfo lineInfo = lineInfos[i];
            hitCounts.add(lineInfo.getCoverageStr());
        }
        return hitCounts;
    }
}

