/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.ContextSet;
import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.FileInfoRegion;
import com.atlassian.clover.registry.entities.BasicElementInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FullElementInfo<T extends BasicElementInfo>
implements CoverageDataReceptor,
FileInfoRegion,
ElementInfo {
    protected final T sharedInfo;
    protected ContextSet context;

    protected FullElementInfo(ContextSet context, T sharedInfo) {
        this.context = context;
        this.sharedInfo = sharedInfo;
    }

    @Override
    public ContextSet getContext() {
        return this.context;
    }

    public void setContext(ContextSet context) {
        this.context = context;
    }

    public boolean isFiltered(ContextSet filter) {
        return filter != null && filter.intersects(this.context);
    }

    public void addContext(NamedContext ctx) {
        this.context = this.context.set(ctx.getIndex());
    }

    @Override
    public int getComplexity() {
        return ((BasicElementInfo)this.sharedInfo).getComplexity();
    }

    public void setComplexity(int complexity) {
        ((BasicElementInfo)this.sharedInfo).setComplexity(complexity);
    }

    @Override
    public int getHitCount() {
        CoverageDataProvider data = this.getDataProvider();
        if (data == null) {
            return 0;
        }
        return data.getHitCount(this.getDataIndex());
    }

    public int getRelativeDataIndex() {
        return ((BasicElementInfo)this.sharedInfo).getRelativeDataIndex();
    }

    @Override
    public int getDataIndex() {
        return ((FullFileInfo)this.getContainingFile()).dataIndex + ((BasicElementInfo)this.sharedInfo).getRelativeDataIndex();
    }

    @Override
    public int getStartLine() {
        return ((BasicElementInfo)this.sharedInfo).getStartLine();
    }

    @Override
    public int getStartColumn() {
        return ((BasicElementInfo)this.sharedInfo).getStartColumn();
    }

    @Override
    public int getEndLine() {
        return ((BasicElementInfo)this.sharedInfo).getEndLine();
    }

    @Override
    public int getEndColumn() {
        return ((BasicElementInfo)this.sharedInfo).getEndColumn();
    }

    @NotNull
    public LanguageConstruct getConstruct() {
        return ((BasicElementInfo)this.sharedInfo).getConstruct();
    }
}

