/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.ErrorInfo;
import com.atlassian.clover.RuntimeType;
import com.atlassian.clover.recorder.CoverageSnapshot;
import com.atlassian.clover.recorder.FileBasedPerTestRecording;
import com.atlassian.clover.recorder.LivePerTestRecording;
import com.atlassian.clover.util.CloverBitSet;
import com_cenqua_clover.CoverageRecorder;
import org.jetbrains.annotations.Nullable;

public interface PerTestRecorder {
    public static final int NO_EXIT_RESULT = -1;
    public static final int ABNORMAL_EXIT = 0;
    public static final int NORMAL_EXIT = 1;

    public void testStarted(String var1, long var2, int var4, int var5);

    public LivePerTestRecording testFinished(String var1, String var2, @Nullable String var3, long var4, int var6, int var7, int var8, ErrorInfo var9);

    public void set(int var1);

    public static class Diffing
    implements PerTestRecorder {
        protected final CoverageRecorder coverageRecorder;
        protected long start;
        protected CoverageSnapshot startingCoverage;

        public Diffing(CoverageRecorder coverageRecorder) {
            this.coverageRecorder = coverageRecorder;
        }

        public void set(int index) {
        }

        public void testStarted(String type, long start, int slice, int testRunID) {
            this.start = start;
            this.startingCoverage = this.coverageRecorder.getCoverageSnapshot();
        }

        public LivePerTestRecording testFinished(String type, String method, @Nullable String runtimeTestName, long end, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
            return new FileBasedPerTestRecording(this.coverageRecorder, this.coverageRecorder.compareCoverageWith(this.startingCoverage), method, runtimeTestName, this.start, end, new RuntimeType(type), slice, testRunId, exitStatus, errorInfo);
        }

        private CloverBitSet diff(CloverBitSet start, CloverBitSet end) {
            end.subtractInPlace(start);
            return end;
        }
    }

    public static class Null
    implements PerTestRecorder {
        public void testStarted(String runtimeType, long start, int slice, int testRunId) {
        }

        public LivePerTestRecording testFinished(String runtimeType, String method, @Nullable String runtimeTestName, long end, int slice, int testRunId, int exitStatus, ErrorInfo ei) {
            return LivePerTestRecording.NULL;
        }

        public void set(int index) {
        }
    }
}

