/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.io.tags;

import com.atlassian.clover.Logger;
import com.atlassian.clover.io.tags.TaggedInputReader;
import com.atlassian.clover.io.tags.TaggedOutputWriter;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.io.tags.Tags;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedIO {
    private static final boolean DEBUG;

    public static boolean isDebug() {
        return DEBUG;
    }

    public static <T extends TaggedPersistent> T read(FileChannel channel, Tags tags, Class<T> clazz) throws IOException {
        return new TaggedInputReader(new DataInputStream(new BufferedInputStream(Channels.newInputStream(channel))), tags).read(clazz);
    }

    public static <T extends TaggedPersistent> T read(DataInput in, Tags tags, Class<T> clazz) throws IOException {
        return new TaggedInputReader(in, tags).read(clazz);
    }

    public static <T extends TaggedPersistent> void write(FileChannel channel, Tags tags, Class<T> clazz, T object) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Channels.newOutputStream(channel)));
        new TaggedOutputWriter(out, tags).write(clazz, object);
        out.flush();
    }

    static {
        boolean shouldDebug = false;
        try {
            shouldDebug = Logger.isDebug() && AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("clover.logging.tagged.io");
                }
            }) != false;
        }
        catch (Exception e) {
            Logger.getInstance().warn("Unable to query if tagged IO should be logged", e);
        }
        DEBUG = shouldDebug;
    }
}

