/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ci;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.clover.api.ci.Integrator;
import com.atlassian.clover.ci.AntIntegrationListener;
import com.atlassian.clover.util.ClassPathUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntIntegrator
implements Integrator {
    private final CIOptions options;

    public AntIntegrator(CIOptions opts) {
        this.options = opts;
    }

    @Override
    public void decorateArguments(List<String> args) {
        if (this.options.isFullClean()) {
            args.add(0, "clover.fullclean");
        }
        if (!this.options.isJson()) {
            args.add("-Dclover.skip.json=true");
        }
        if (!this.options.isHistorical()) {
            args.add("-Dclover.skip.report=true");
        }
        if (this.options.isHistorical()) {
            args.add("-Dclover.skip.current=true");
        }
        if (this.options.getHistoryDir() != null) {
            args.add("-Dclover.historydir=\"" + this.options.getHistoryDir().getAbsolutePath() + "\"");
        }
        args.add("-Dclover.optimization.enabled=" + this.options.isOptimize());
        String cloverJarLocation = ClassPathUtil.getCloverJarPath();
        if (cloverJarLocation != null) {
            args.add("-lib");
            args.add("\"" + cloverJarLocation + "\"");
        } else {
            Logger.getInstance().warn("The location of the clover jar could not be determined. Please supply '-lib /path/to/clover.jar' directly.");
        }
        args.add("-listener");
        args.add(AntIntegrationListener.class.getName());
        if (this.options.getLicenseCert() != null && !this.options.getLicenseCert().trim().equals("")) {
            args.add("-Dclover.license.cert=\"" + this.options.getLicenseCert() + "\"");
        }
        if (this.options.getLicense() != null) {
            args.add("-Dclover.license.path=\"" + this.options.getLicense().getAbsolutePath() + "\"");
        }
    }
}

