/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Arrays;
import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import java.io.Serializable;
import java.lang.reflect.Array;

public class ObjectArrays {
    private static final long ONEOVERPHI = 106039L;
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private ObjectArrays() {
    }

    private static Object[] newArray(Object[] prototype, int length) {
        if (prototype == null) {
            if (length == 0) {
                return EMPTY_ARRAY;
            }
            return new Object[length];
        }
        return (Object[])Array.newInstance(prototype.getClass().getComponentType(), length);
    }

    public static Object[] ensureCapacity(Object[] array, int length) {
        if (length > array.length) {
            Object[] t = ObjectArrays.newArray(array, length);
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static Object[] ensureCapacity(Object[] array, int length, int preserve) {
        if (length > array.length) {
            Object[] t = ObjectArrays.newArray(array, length);
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static Object[] grow(Object[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            Object[] t = ObjectArrays.newArray(array, newLength);
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static Object[] grow(Object[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            try {
                Object[] t = ObjectArrays.newArray(array, newLength);
                System.arraycopy(array, 0, t, 0, preserve);
                return t;
            }
            catch (Error T) {
                System.err.println(newLength);
                throw T;
            }
        }
        return array;
    }

    public static Object[] trim(Object[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        Object[] t = ObjectArrays.newArray(array, length);
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static Object[] setLength(Object[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ObjectArrays.trim(array, length);
        }
        return ObjectArrays.ensureCapacity(array, length);
    }

    public static Object[] copy(Object[] array, int offset, int length) {
        ObjectArrays.ensureOffsetLength(array, offset, length);
        Object[] a = ObjectArrays.newArray(array, length);
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static Object[] copy(Object[] array) {
        return (Object[])array.clone();
    }

    public static void fill(Object[] array, Object value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(Object[] array, int from, int to, Object value) {
        ObjectArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] != null ? a1[i].equals(a2[i]) : a2[i] == null) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(Object[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(Object[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy,
    Serializable {
        private ArrayHashStrategy() {
        }

        public int hashCode(Object o) {
            if (o == null) {
                return 0;
            }
            if (o == HashCommon.REMOVED) {
                return HashCommon.REMOVED.hashCode();
            }
            Object[] a = (Object[])o;
            int i = a.length;
            int hashCode = -1;
            while (i-- != 0) {
                hashCode = 31 * hashCode + (a[i] == null ? 0 : a[i].hashCode());
            }
            return hashCode;
        }

        public boolean equals(Object a, Object b) {
            if (a == null) {
                return b == null;
            }
            if (a == HashCommon.REMOVED || b == HashCommon.REMOVED) {
                return a == b;
            }
            return ObjectArrays.equals((Object[])a, (Object[])b);
        }
    }
}

