/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.Arrays;
import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import java.io.Serializable;

public class LongArrays {
    private static final long ONEOVERPHI = 106039L;
    public static final long[] EMPTY_ARRAY = new long[0];
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private LongArrays() {
    }

    public static long[] ensureCapacity(long[] array, int length) {
        if (length > array.length) {
            long[] t = new long[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static long[] ensureCapacity(long[] array, int length, int preserve) {
        if (length > array.length) {
            long[] t = new long[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static long[] grow(long[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            long[] t = new long[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static long[] grow(long[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            try {
                long[] t = new long[newLength];
                System.arraycopy(array, 0, t, 0, preserve);
                return t;
            }
            catch (Error T) {
                System.err.println(newLength);
                throw T;
            }
        }
        return array;
    }

    public static long[] trim(long[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        long[] t = length == 0 ? EMPTY_ARRAY : new long[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static long[] setLength(long[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return LongArrays.trim(array, length);
        }
        return LongArrays.ensureCapacity(array, length);
    }

    public static long[] copy(long[] array, int offset, int length) {
        LongArrays.ensureOffsetLength(array, offset, length);
        long[] a = length == 0 ? EMPTY_ARRAY : new long[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static long[] copy(long[] array) {
        return (long[])array.clone();
    }

    public static void fill(long[] array, long value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(long[] array, int from, int to, long value) {
        LongArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(long[] a1, long[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(long[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(long[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy,
    Serializable {
        private ArrayHashStrategy() {
        }

        public int hashCode(Object o) {
            if (o == null) {
                return 0;
            }
            if (o == HashCommon.REMOVED) {
                return HashCommon.REMOVED.hashCode();
            }
            long[] a = (long[])o;
            int i = a.length;
            int hashCode = -1;
            while (i-- != 0) {
                hashCode = 31 * hashCode + HashCommon.long2int(a[i]);
            }
            return hashCode;
        }

        public boolean equals(Object a, Object b) {
            if (a == null) {
                return b == null;
            }
            if (a == HashCommon.REMOVED || b == HashCommon.REMOVED) {
                return a == b;
            }
            return LongArrays.equals((long[])a, (long[])b);
        }
    }
}

