/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.rtf;

import clover.com.lowagie.text.Anchor;
import clover.com.lowagie.text.Annotation;
import clover.com.lowagie.text.Chapter;
import clover.com.lowagie.text.Chunk;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.Element;
import clover.com.lowagie.text.Image;
import clover.com.lowagie.text.List;
import clover.com.lowagie.text.ListItem;
import clover.com.lowagie.text.Meta;
import clover.com.lowagie.text.Paragraph;
import clover.com.lowagie.text.Phrase;
import clover.com.lowagie.text.Section;
import clover.com.lowagie.text.SimpleTable;
import clover.com.lowagie.text.Table;
import clover.com.lowagie.text.rtf.RtfBasicElement;
import clover.com.lowagie.text.rtf.document.RtfDocument;
import clover.com.lowagie.text.rtf.document.RtfInfoElement;
import clover.com.lowagie.text.rtf.field.RtfAnchor;
import clover.com.lowagie.text.rtf.graphic.RtfImage;
import clover.com.lowagie.text.rtf.list.RtfList;
import clover.com.lowagie.text.rtf.list.RtfListItem;
import clover.com.lowagie.text.rtf.table.RtfTable;
import clover.com.lowagie.text.rtf.text.RtfAnnotation;
import clover.com.lowagie.text.rtf.text.RtfChapter;
import clover.com.lowagie.text.rtf.text.RtfChunk;
import clover.com.lowagie.text.rtf.text.RtfNewPage;
import clover.com.lowagie.text.rtf.text.RtfParagraph;
import clover.com.lowagie.text.rtf.text.RtfPhrase;
import clover.com.lowagie.text.rtf.text.RtfSection;

public class RtfMapper {
    RtfDocument rtfDoc;

    public RtfMapper(RtfDocument doc) {
        this.rtfDoc = doc;
    }

    public RtfBasicElement mapElement(Element element) throws DocumentException {
        RtfBasicElement rtfElement = null;
        if (element instanceof RtfBasicElement) {
            rtfElement = (RtfBasicElement)((Object)element);
            rtfElement.setRtfDocument(this.rtfDoc);
            return rtfElement;
        }
        switch (element.type()) {
            case 10: {
                if (((Chunk)element).getImage() != null) {
                    rtfElement = new RtfImage(this.rtfDoc, ((Chunk)element).getImage());
                    break;
                }
                if (((Chunk)element).hasAttributes() && ((Chunk)element).getAttributes().containsKey("NEWPAGE")) {
                    rtfElement = new RtfNewPage(this.rtfDoc);
                    break;
                }
                rtfElement = new RtfChunk(this.rtfDoc, (Chunk)element);
                break;
            }
            case 11: {
                rtfElement = new RtfPhrase(this.rtfDoc, (Phrase)element);
                break;
            }
            case 12: {
                rtfElement = new RtfParagraph(this.rtfDoc, (Paragraph)element);
                break;
            }
            case 17: {
                rtfElement = new RtfAnchor(this.rtfDoc, (Anchor)element);
                break;
            }
            case 29: {
                rtfElement = new RtfAnnotation(this.rtfDoc, (Annotation)element);
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                rtfElement = new RtfImage(this.rtfDoc, (Image)element);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                rtfElement = new RtfInfoElement(this.rtfDoc, (Meta)element);
                break;
            }
            case 14: {
                rtfElement = new RtfList(this.rtfDoc, (List)element);
                break;
            }
            case 15: {
                rtfElement = new RtfListItem(this.rtfDoc, (ListItem)element);
                break;
            }
            case 13: {
                rtfElement = new RtfSection(this.rtfDoc, (Section)element);
                break;
            }
            case 16: {
                rtfElement = new RtfChapter(this.rtfDoc, (Chapter)element);
                break;
            }
            case 22: {
                try {
                    rtfElement = new RtfTable(this.rtfDoc, (Table)element);
                    break;
                }
                catch (ClassCastException e) {
                    rtfElement = new RtfTable(this.rtfDoc, ((SimpleTable)element).createTable());
                }
            }
        }
        return rtfElement;
    }
}

