/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.pdf.BaseFont;
import clover.com.lowagie.text.pdf.GlyphList;
import clover.com.lowagie.text.pdf.PdfArray;
import clover.com.lowagie.text.pdf.PdfDictionary;
import clover.com.lowagie.text.pdf.PdfEncodings;
import clover.com.lowagie.text.pdf.PdfIndirectObject;
import clover.com.lowagie.text.pdf.PdfIndirectReference;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfRectangle;
import clover.com.lowagie.text.pdf.PdfStream;
import clover.com.lowagie.text.pdf.PdfWriter;
import clover.com.lowagie.text.pdf.Pfm2afm;
import clover.com.lowagie.text.pdf.RandomAccessFileOrArray;
import clover.com.lowagie.text.pdf.fonts.FontsResourceAnchor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

class Type1Font
extends BaseFont {
    private static FontsResourceAnchor resourceAnchor;
    protected byte[] pfb;
    private String FontName;
    private String FullName;
    private String FamilyName;
    private String Weight;
    private float ItalicAngle;
    private boolean IsFixedPitch;
    private String CharacterSet;
    private int llx;
    private int lly;
    private int urx;
    private int ury;
    private int UnderlinePosition;
    private int UnderlineThickness;
    private String EncodingScheme;
    private int CapHeight;
    private int XHeight;
    private int Ascender;
    private int Descender;
    private int StdHW;
    private int StdVW;
    private HashMap CharMetrics;
    private HashMap KernPairs;
    private String fileName;
    private boolean builtinFont;
    private static final int[] PFB_TYPES;

    static {
        PFB_TYPES = new int[]{1, 2, 1};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Type1Font(String afmFile, String enc, boolean emb, byte[] ttfAfm, byte[] pfb) throws DocumentException, IOException {
        block34: {
            block35: {
                super();
                this.Weight = "";
                this.ItalicAngle = 0.0f;
                this.IsFixedPitch = false;
                this.llx = -50;
                this.lly = -200;
                this.urx = 1000;
                this.ury = 900;
                this.UnderlinePosition = -100;
                this.UnderlineThickness = 50;
                this.EncodingScheme = "FontSpecific";
                this.CapHeight = 700;
                this.XHeight = 480;
                this.Ascender = 800;
                this.Descender = -200;
                this.StdVW = 80;
                this.CharMetrics = new HashMap<K, V>();
                this.KernPairs = new HashMap<K, V>();
                this.builtinFont = false;
                if (emb && ttfAfm != null && pfb == null) {
                    throw new DocumentException("Two byte arrays are needed if the Type1 font is embedded.");
                }
                if (emb && ttfAfm != null) {
                    this.pfb = pfb;
                }
                this.encoding = enc;
                this.embedded = emb;
                this.fileName = afmFile;
                this.fontType = 0;
                rf = null;
                is = null;
                if (!Type1Font.BuiltinFonts14.containsKey(afmFile)) break block35;
                this.embedded = false;
                this.builtinFont = true;
                buf = new byte[1024];
                try {
                    if (Type1Font.resourceAnchor == null) {
                        Type1Font.resourceAnchor = new FontsResourceAnchor();
                    }
                    if ((is = Type1Font.getResourceStream("clover/com/lowagie/text/pdf/fonts/" + afmFile + ".afm", Type1Font.resourceAnchor.getClass().getClassLoader())) == null) {
                        msg = String.valueOf(afmFile) + " not found as resource. (The *.afm files must exist as resources in the package com.lowagie.text.pdf.fonts)";
                        System.err.println(msg);
                        throw new DocumentException(msg);
                    }
                    out = new ByteArrayOutputStream();
                    while (true) {
                        block36: {
                            if ((size = is.read(buf)) >= 0) break block36;
                            buf = out.toByteArray();
                            break;
                        }
                        out.write(buf, 0, size);
                    }
                }
                catch (Throwable var11_22) {
                    var12_23 = null;
                    if (is == null) throw var11_22;
                    try {
                        is.close();
                        throw var11_22;
                    }
                    catch (Exception var13_27) {
                        // empty catch block
                    }
                    throw var11_22;
                }
                {
                    var12_24 = null;
                    if (is == null) ** GOTO lbl-1000
                }
                ** try [egrp 1[TRYBLOCK] [2 : 377->385)] { 
lbl62:
                // 1 sources

                is.close();
                ** GOTO lbl-1000
lbl64:
                // 1 sources

                catch (Exception var13_28) {
                    // empty catch block
                }
lbl-1000:
                // 3 sources

                {
                    rf = new RandomAccessFileOrArray(buf);
                    this.process(rf);
                    var9_13 = null;
                    if (rf != null) {
                        try {
                            rf.close();
                        }
                        catch (Exception var12_24) {}
                    }
                    break block34;
                }
            }
            if (afmFile.toLowerCase().endsWith(".afm")) {
                try {
                    rf = ttfAfm == null ? new RandomAccessFileOrArray(afmFile) : new RandomAccessFileOrArray(ttfAfm);
                    this.process(rf);
                }
                catch (Throwable var9_14) {
                    buf = null;
                    if (rf == null) throw var9_14;
                    try {
                        rf.close();
                        throw var9_14;
                    }
                    catch (Exception var10_19) {
                        // empty catch block
                    }
                    throw var9_14;
                }
                {
                    buf = null;
                    if (rf != null) {
                        try {}
                        catch (Exception var10_20) {}
                        rf.close();
                    }
                    break block34;
                }
            }
            if (afmFile.toLowerCase().endsWith(".pfm") == false) throw new DocumentException(String.valueOf(afmFile) + " is not an AFM or PFM font file.");
            try {
                ba = new ByteArrayOutputStream();
                rf = ttfAfm == null ? new RandomAccessFileOrArray(afmFile) : new RandomAccessFileOrArray(ttfAfm);
                Pfm2afm.convert(rf, ba);
                rf.close();
                rf = new RandomAccessFileOrArray(ba.toByteArray());
                this.process(rf);
            }
            catch (Throwable var10_21) {
                var9_15 = null;
                if (rf == null) throw var10_21;
                try {
                    rf.close();
                    throw var10_21;
                }
                catch (Exception var12_25) {
                    // empty catch block
                }
                throw var10_21;
            }
            {
                var9_16 = null;
                if (rf == null) break block34;
                try {}
                catch (Exception var12_26) {}
                rf.close();
            }
        }
        this.EncodingScheme = this.EncodingScheme.trim();
        if (this.EncodingScheme.equals("AdobeStandardEncoding") || this.EncodingScheme.equals("StandardEncoding")) {
            this.fontSpecific = false;
        }
        if (!this.encoding.startsWith("#")) {
            PdfEncodings.convertToBytes(" ", enc);
        }
        this.createEncoding();
    }

    int getRawWidth(int c, String name) {
        Object[] metrics;
        if (name == null) {
            metrics = (Object[])this.CharMetrics.get(new Integer(c));
        } else {
            if (name.equals(".notdef")) {
                return 0;
            }
            metrics = (Object[])this.CharMetrics.get(name);
        }
        if (metrics != null) {
            return (Integer)metrics[1];
        }
        return 0;
    }

    public int getKerning(char char1, char char2) {
        String first = GlyphList.unicodeToName(char1);
        if (first == null) {
            return 0;
        }
        String second = GlyphList.unicodeToName(char2);
        if (second == null) {
            return 0;
        }
        Object[] obj = (Object[])this.KernPairs.get(first);
        if (obj == null) {
            return 0;
        }
        int k = 0;
        while (k < obj.length) {
            if (second.equals(obj[k])) {
                return (Integer)obj[k + 1];
            }
            k += 2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void process(RandomAccessFileOrArray rf) throws DocumentException, IOException {
        isMetrics = false;
        while ((line = rf.readLine()) != null) {
            tok = new StringTokenizer(line, " ,\n\r\t\f");
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("FontName")) {
                this.FontName = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("FullName")) {
                this.FullName = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("FamilyName")) {
                this.FamilyName = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("Weight")) {
                this.Weight = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("ItalicAngle")) {
                this.ItalicAngle = Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("IsFixedPitch")) {
                this.IsFixedPitch = tok.nextToken().equals("true");
                continue;
            }
            if (ident.equals("CharacterSet")) {
                this.CharacterSet = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("FontBBox")) {
                this.llx = (int)Float.parseFloat(tok.nextToken());
                this.lly = (int)Float.parseFloat(tok.nextToken());
                this.urx = (int)Float.parseFloat(tok.nextToken());
                this.ury = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("UnderlinePosition")) {
                this.UnderlinePosition = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("UnderlineThickness")) {
                this.UnderlineThickness = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("EncodingScheme")) {
                this.EncodingScheme = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("CapHeight")) {
                this.CapHeight = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("XHeight")) {
                this.XHeight = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("Ascender")) {
                this.Ascender = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("Descender")) {
                this.Descender = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("StdHW")) {
                this.StdHW = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (ident.equals("StdVW")) {
                this.StdVW = (int)Float.parseFloat(tok.nextToken());
                continue;
            }
            if (!ident.equals("StartCharMetrics")) continue;
            isMetrics = true;
            break;
        }
        if (isMetrics) ** GOTO lbl98
        throw new DocumentException("Missing StartCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("EndCharMetrics")) {
                isMetrics = false;
                break;
            }
            C = new Integer(-1);
            WX = new Integer(250);
            N = "";
            B = null;
            tok = new StringTokenizer(line, ";");
            while (tok.hasMoreTokens()) {
                tokc = new StringTokenizer(tok.nextToken());
                if (!tokc.hasMoreTokens()) continue;
                ident = tokc.nextToken();
                if (ident.equals("C")) {
                    C = Integer.valueOf(tokc.nextToken());
                    continue;
                }
                if (ident.equals("WX")) {
                    WX = new Integer((int)Float.parseFloat(tokc.nextToken()));
                    continue;
                }
                if (ident.equals("N")) {
                    N = tokc.nextToken();
                    continue;
                }
                if (!ident.equals("B")) continue;
                B = new int[]{Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken())};
            }
            metrics = new Object[]{C, WX, N, B};
            if (C >= 0) {
                this.CharMetrics.put(C, metrics);
            }
            this.CharMetrics.put(N, metrics);
lbl98:
            // 3 sources

            ** while ((line = rf.readLine()) != null)
        }
lbl99:
        // 2 sources

        if (isMetrics) {
            throw new DocumentException("Missing EndCharMetrics in " + this.fileName);
        }
        if (!this.CharMetrics.containsKey("nonbreakingspace") && (space = (Object[])this.CharMetrics.get("space")) != null) {
            this.CharMetrics.put("nonbreakingspace", space);
        }
        while ((line = rf.readLine()) != null) {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("EndFontMetrics")) {
                return;
            }
            if (!ident.equals("StartKernPairs")) continue;
            isMetrics = true;
            break;
        }
        if (isMetrics) ** GOTO lbl138
        throw new DocumentException("Missing EndFontMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("KPX")) {
                first = tok.nextToken();
                second = tok.nextToken();
                width = new Integer((int)Float.parseFloat(tok.nextToken()));
                relates = (Object[])this.KernPairs.get(first);
                if (relates == null) {
                    this.KernPairs.put(first, new Object[]{second, width});
                    continue;
                }
                n = relates.length;
                relates2 = new Object[n + 2];
                System.arraycopy(relates, 0, relates2, 0, n);
                relates2[n] = second;
                relates2[n + 1] = width;
                this.KernPairs.put(first, relates2);
                continue;
            }
            if (!ident.equals("EndKernPairs")) continue;
            isMetrics = false;
            break;
lbl138:
            // 5 sources

            ** while ((line = rf.readLine()) != null)
        }
lbl139:
        // 2 sources

        if (isMetrics) {
            throw new DocumentException("Missing EndKernPairs in " + this.fileName);
        }
        rf.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PdfStream getFontStream() throws DocumentException {
        BaseFont.StreamFont streamFont;
        if (this.builtinFont) return null;
        if (!this.embedded) {
            return null;
        }
        RandomAccessFileOrArray rf = null;
        try {
            try {
                String filePfb = String.valueOf(this.fileName.substring(0, this.fileName.length() - 3)) + "pfb";
                rf = this.pfb == null ? new RandomAccessFileOrArray(filePfb) : new RandomAccessFileOrArray(this.pfb);
                int fileLength = rf.length();
                byte[] st = new byte[fileLength - 18];
                int[] lengths = new int[3];
                int bytePtr = 0;
                int k = 0;
                block7: while (true) {
                    if (k >= 3) {
                        streamFont = new BaseFont.StreamFont(st, lengths);
                        Object var12_12 = null;
                        if (rf == null) return streamFont;
                        break;
                    }
                    if (rf.read() != 128) {
                        throw new DocumentException("Start marker missing in " + filePfb);
                    }
                    if (rf.read() != PFB_TYPES[k]) {
                        throw new DocumentException("Incorrect segment type in " + filePfb);
                    }
                    int size = rf.read();
                    size += rf.read() << 8;
                    size += rf.read() << 16;
                    lengths[k] = size += rf.read() << 24;
                    while (true) {
                        if (size == 0) {
                            ++k;
                            continue block7;
                        }
                        int got = rf.read(st, bytePtr, size);
                        if (got < 0) {
                            throw new DocumentException("Premature end in " + filePfb);
                        }
                        bytePtr += got;
                        size -= got;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (rf == null) throw throwable;
            try {
                rf.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return streamFont;
        }
        rf.close();
        return streamFont;
    }

    private PdfDictionary getFontDescriptor(PdfIndirectReference fontStream) {
        if (this.builtinFont) {
            return null;
        }
        PdfDictionary dic = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        dic.put(PdfName.ASCENT, new PdfNumber(this.Ascender));
        dic.put(PdfName.CAPHEIGHT, new PdfNumber(this.CapHeight));
        dic.put(PdfName.DESCENT, new PdfNumber(this.Descender));
        dic.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        dic.put(PdfName.FONTNAME, new PdfName(this.FontName));
        dic.put(PdfName.ITALICANGLE, new PdfNumber(this.ItalicAngle));
        dic.put(PdfName.STEMV, new PdfNumber(this.StdVW));
        if (fontStream != null) {
            dic.put(PdfName.FONTFILE, fontStream);
        }
        int flags = 0;
        if (this.IsFixedPitch) {
            flags |= 1;
        }
        flags |= this.fontSpecific ? 4 : 32;
        if (this.ItalicAngle < 0.0f) {
            flags |= 0x40;
        }
        if (this.FontName.indexOf("Caps") >= 0 || this.FontName.endsWith("SC")) {
            flags |= 0x20000;
        }
        if (this.Weight.equals("Bold")) {
            flags |= 0x40000;
        }
        dic.put(PdfName.FLAGS, new PdfNumber(flags));
        return dic;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference fontDescriptor, int firstChar, int lastChar, byte[] shortTag) {
        boolean stdEncoding;
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
        dic.put(PdfName.BASEFONT, new PdfName(this.FontName));
        boolean bl = stdEncoding = this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman");
        if (!this.fontSpecific || this.specialMap != null) {
            int k = firstChar;
            while (k <= lastChar) {
                if (!this.differences[k].equals(".notdef")) {
                    firstChar = k;
                    break;
                }
                ++k;
            }
            if (stdEncoding) {
                dic.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary enc = new PdfDictionary(PdfName.ENCODING);
                PdfArray dif = new PdfArray();
                boolean gap = true;
                int k2 = firstChar;
                while (k2 <= lastChar) {
                    if (shortTag[k2] != 0) {
                        if (gap) {
                            dif.add(new PdfNumber(k2));
                            gap = false;
                        }
                        dif.add(new PdfName(this.differences[k2]));
                    } else {
                        gap = true;
                    }
                    ++k2;
                }
                enc.put(PdfName.DIFFERENCES, dif);
                dic.put(PdfName.ENCODING, enc);
            }
        }
        if (this.specialMap != null || this.forceWidthsOutput || !this.builtinFont || !this.fontSpecific && !stdEncoding) {
            dic.put(PdfName.FIRSTCHAR, new PdfNumber(firstChar));
            dic.put(PdfName.LASTCHAR, new PdfNumber(lastChar));
            PdfArray wd = new PdfArray();
            int k = firstChar;
            while (k <= lastChar) {
                if (shortTag[k] == 0) {
                    wd.add(new PdfNumber(0));
                } else {
                    wd.add(new PdfNumber(this.widths[k]));
                }
                ++k;
            }
            dic.put(PdfName.WIDTHS, wd);
        }
        if (!this.builtinFont && fontDescriptor != null) {
            dic.put(PdfName.FONTDESCRIPTOR, fontDescriptor);
        }
        return dic;
    }

    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        boolean subsetp;
        int firstChar = (Integer)params[0];
        int lastChar = (Integer)params[1];
        byte[] shortTag = (byte[])params[2];
        boolean bl = subsetp = (Boolean)params[3] != false && this.subset;
        if (!subsetp) {
            firstChar = 0;
            lastChar = shortTag.length - 1;
            int k = 0;
            while (k < shortTag.length) {
                shortTag[k] = 1;
                ++k;
            }
        }
        PdfIndirectReference ind_font = null;
        PdfDictionary pobj = null;
        PdfIndirectObject obj = null;
        pobj = this.getFontStream();
        if (pobj != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        if ((pobj = this.getFontDescriptor(ind_font)) != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        pobj = this.getFontBaseType(ind_font, firstChar, lastChar, shortTag);
        writer.addToBody((PdfObject)pobj, ref);
    }

    public float getFontDescriptor(int key, float fontSize) {
        switch (key) {
            case 1: 
            case 9: {
                return (float)this.Ascender * fontSize / 1000.0f;
            }
            case 2: {
                return (float)this.CapHeight * fontSize / 1000.0f;
            }
            case 3: 
            case 10: {
                return (float)this.Descender * fontSize / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return (float)this.llx * fontSize / 1000.0f;
            }
            case 6: {
                return (float)this.lly * fontSize / 1000.0f;
            }
            case 7: {
                return (float)this.urx * fontSize / 1000.0f;
            }
            case 8: {
                return (float)this.ury * fontSize / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (float)(this.urx - this.llx) * fontSize / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String getPostscriptFontName() {
        return this.FontName;
    }

    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.FullName}};
    }

    public String[][] getFamilyFontName() {
        return new String[][]{{"", "", "", this.FamilyName}};
    }

    public boolean hasKernPairs() {
        return !this.KernPairs.isEmpty();
    }

    public void setPostscriptFontName(String name) {
        this.FontName = name;
    }

    public boolean setKerning(char char1, char char2, int kern) {
        String first = GlyphList.unicodeToName(char1);
        if (first == null) {
            return false;
        }
        String second = GlyphList.unicodeToName(char2);
        if (second == null) {
            return false;
        }
        Object[] obj = (Object[])this.KernPairs.get(first);
        if (obj == null) {
            obj = new Object[]{second, new Integer(kern)};
            this.KernPairs.put(first, obj);
            return true;
        }
        int k = 0;
        while (k < obj.length) {
            if (second.equals(obj[k])) {
                obj[k + 1] = new Integer(kern);
                return true;
            }
            k += 2;
        }
        int size = obj.length;
        Object[] obj2 = new Object[size + 2];
        System.arraycopy(obj, 0, obj2, 0, size);
        obj2[size] = second;
        obj2[size + 1] = new Integer(kern);
        this.KernPairs.put(first, obj2);
        return true;
    }

    protected int[] getRawCharBBox(int c, String name) {
        Object[] metrics;
        if (name == null) {
            metrics = (Object[])this.CharMetrics.get(new Integer(c));
        } else {
            if (name.equals(".notdef")) {
                return null;
            }
            metrics = (Object[])this.CharMetrics.get(name);
        }
        if (metrics != null) {
            return (int[])metrics[3];
        }
        return null;
    }
}

