/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.common.collect;

import clover.com.google.common.base.Equivalence;
import clover.com.google.common.base.Equivalences;
import clover.com.google.common.base.FinalizableReferenceQueue;
import clover.com.google.common.base.FinalizableSoftReference;
import clover.com.google.common.base.FinalizableWeakReference;
import clover.com.google.common.base.Preconditions;
import clover.com.google.common.base.Ticker;
import clover.com.google.common.collect.AbstractLinkedIterator;
import clover.com.google.common.collect.AbstractMapEntry;
import clover.com.google.common.collect.ForwardingConcurrentMap;
import clover.com.google.common.collect.Iterators;
import clover.com.google.common.collect.MapEvictionListener;
import clover.com.google.common.collect.MapMaker;
import clover.com.google.common.primitives.Ints;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int DRAIN_THRESHOLD = 63;
    static final int CLEANUP_MAX = 16;
    final transient int segmentMask;
    final transient int segmentShift;
    final transient Segment[] segments;
    final int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    final Strength keyStrength;
    final Strength valueStrength;
    final int maximumSize;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final Queue<ReferenceEntry<K, V>> evictionNotificationQueue;
    final MapEvictionListener<? super K, ? super V> evictionListener;
    final transient EntryFactory entryFactory;
    final Executor cleanupExecutor;
    final Ticker ticker;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public ValueReference<Object, Object> copyFor(ReferenceEntry<Object, Object> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public Object waitForValue() {
            return null;
        }

        @Override
        public void notifyValueReclaimed() {
        }

        @Override
        public void clear() {
        }
    };
    static final Queue<? extends ReferenceEntry<?, ?>> DISCARDING_QUEUE = new AbstractQueue<ReferenceEntry<?, ?>>(){

        @Override
        public boolean offer(ReferenceEntry<?, ?> o) {
            return true;
        }

        @Override
        public ReferenceEntry<?, ?> peek() {
            return null;
        }

        @Override
        public ReferenceEntry<?, ?> poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<ReferenceEntry<?, ?>> iterator() {
            return Iterators.emptyIterator();
        }
    };
    Set<K> keySet;
    Collection<V> values;
    Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 4L;

    CustomConcurrentHashMap(MapMaker builder) {
        int segmentSize;
        int segmentCount;
        this.concurrencyLevel = Math.min(builder.getConcurrencyLevel(), 65536);
        this.keyStrength = builder.getKeyStrength();
        this.valueStrength = builder.getValueStrength();
        this.keyEquivalence = builder.getKeyEquivalence();
        this.valueEquivalence = builder.getValueEquivalence();
        this.maximumSize = builder.maximumSize;
        this.expireAfterAccessNanos = builder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = builder.getExpireAfterWriteNanos();
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.expires(), this.evictsBySize());
        this.cleanupExecutor = builder.getCleanupExecutor();
        this.ticker = builder.getTicker();
        this.evictionListener = builder.getEvictionListener();
        this.evictionNotificationQueue = this.evictionListener == MapMaker.NullListener.INSTANCE ? CustomConcurrentHashMap.discardingQueue() : new ConcurrentLinkedQueue();
        int initialCapacity = Math.min(builder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize()) {
            initialCapacity = Math.min(initialCapacity, this.maximumSize);
        }
        int segmentShift = 0;
        for (segmentCount = 1; !(segmentCount >= this.concurrencyLevel || this.evictsBySize() && segmentCount * 2 > this.maximumSize); segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        this.segments = this.newSegmentArray(segmentCount);
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * segmentCount < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        if (this.evictsBySize()) {
            int maximumSegmentSize = this.maximumSize / segmentCount + 1;
            int remainder = this.maximumSize % segmentCount;
            for (int i = 0; i < this.segments.length; ++i) {
                if (i == remainder) {
                    --maximumSegmentSize;
                }
                this.segments[i] = this.createSegment(segmentSize, maximumSegmentSize);
            }
        } else {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = this.createSegment(segmentSize, -1);
            }
        }
    }

    boolean evictsBySize() {
        return this.maximumSize != -1;
    }

    boolean expires() {
        return this.expiresAfterWrite() || this.expiresAfterAccess();
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    boolean isInlineCleanup() {
        return this.cleanupExecutor == MapMaker.DEFAULT_CLEANUP_EXECUTOR;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    private static int rehash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    @GuardedBy(value="Segment.this")
    ReferenceEntry<K, V> newEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
        return this.entryFactory.newEntry(this, key, hash, next);
    }

    @GuardedBy(value="Segment.this")
    ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
        ValueReference<K, V> valueReference = original.getValueReference();
        ReferenceEntry<K, V> newEntry = this.entryFactory.copyEntry(this, original, newNext);
        newEntry.setValueReference(valueReference.copyFor(newEntry));
        return newEntry;
    }

    @GuardedBy(value="Segment.this")
    ValueReference<K, V> newValueReference(ReferenceEntry<K, V> entry, V value) {
        return this.valueStrength.referenceValue(entry, value);
    }

    int hash(Object key) {
        int h = this.keyEquivalence.hash(Preconditions.checkNotNull(key));
        return CustomConcurrentHashMap.rehash(h);
    }

    void reclaimValue(ReferenceEntry<K, V> entry, ValueReference<K, V> valueReference) {
        int hash = entry.getHash();
        Segment segment = this.segmentFor(hash);
        segment.unsetValue(entry.getKey(), hash, valueReference);
        if (!segment.isHeldByCurrentThread()) {
            segment.postWriteCleanup();
        }
    }

    void reclaimKey(ReferenceEntry<K, V> entry) {
        int hash = entry.getHash();
        this.segmentFor(hash).unsetKey(entry, hash);
    }

    @VisibleForTesting
    boolean isLive(ReferenceEntry<K, V> entry) {
        return this.segmentFor(entry.getHash()).getLiveValue(entry) != null;
    }

    boolean isExpired(ReferenceEntry<K, V> entry) {
        return this.isExpired(entry, this.ticker.read());
    }

    boolean isExpired(ReferenceEntry<K, V> entry, long now) {
        return now - entry.getExpirationTime() > 0L;
    }

    boolean isCollected(ReferenceEntry<K, V> entry) {
        if (entry.getKey() == null) {
            return true;
        }
        ValueReference<K, V> valueReference = entry.getValueReference();
        if (valueReference.isComputingReference()) {
            return false;
        }
        return valueReference.get() == null;
    }

    boolean isUnset(ReferenceEntry<K, V> entry) {
        return this.isUnset(entry.getValueReference());
    }

    boolean isUnset(ValueReference<K, V> valueReference) {
        return valueReference == UNSET;
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void connectExpirables(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextExpirable(next);
        next.setPreviousExpirable(previous);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void nullifyExpirable(ReferenceEntry<K, V> nulled) {
        ReferenceEntry<K, V> nullEntry = CustomConcurrentHashMap.nullEntry();
        nulled.setNextExpirable(nullEntry);
        nulled.setPreviousExpirable(nullEntry);
    }

    void enqueueNotification(K key, int hash, ValueReference<K, V> valueReference) {
        if (this.evictionNotificationQueue == DISCARDING_QUEUE) {
            return;
        }
        ReferenceEntry<K, V> notifyEntry = this.newEntry(key, hash, null);
        notifyEntry.setValueReference(valueReference.copyFor(notifyEntry));
        this.evictionNotificationQueue.offer(notifyEntry);
    }

    void processPendingNotifications() {
        ReferenceEntry<K, V> entry;
        while ((entry = this.evictionNotificationQueue.poll()) != null) {
            this.evictionListener.onEviction(entry.getKey(), entry.getValueReference().get());
        }
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void connectEvictables(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextEvictable(next);
        next.setPreviousEvictable(previous);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void nullifyEvictable(ReferenceEntry<K, V> nulled) {
        ReferenceEntry<K, V> nullEntry = CustomConcurrentHashMap.nullEntry();
        nulled.setNextEvictable(nullEntry);
        nulled.setPreviousEvictable(nullEntry);
    }

    final Segment[] newSegmentArray(int ssize) {
        return (Segment[])Array.newInstance(Segment.class, ssize);
    }

    Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    Segment createSegment(int initialCapacity, int maxSegmentSize) {
        return new Segment(initialCapacity, maxSegmentSize);
    }

    @Override
    public boolean isEmpty() {
        int i;
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        for (int i = 0; i < segments.length; ++i) {
            sum += (long)segments[i].count;
        }
        return Ints.saturatedCast(sum);
    }

    @Override
    public V get(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).get(key, hash);
    }

    @VisibleForTesting
    ReferenceEntry<K, V> getEntry(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).getEntry(key, hash);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value);
        Segment[] segments = this.segments;
        for (int i = 0; i < segments.length; ++i) {
            int c = segments[i].count;
            if (!segments[i].containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash);
    }

    @Override
    public boolean remove(Object key, Object value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    Object writeReplace() {
        return new SerializationProxy<K, V>(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expireAfterWriteNanos, this.expireAfterAccessNanos, this.maximumSize, this.concurrencyLevel, this.evictionListener, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<K, V>
    extends AbstractSerializationProxy<K, V> {
        private static final long serialVersionUID = 2L;

        SerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, int maximumSize, int concurrencyLevel, MapEvictionListener<? super K, ? super V> evictionListener, ConcurrentMap<K, V> delegate) {
            super(keyStrength, valueStrength, keyEquivalence, valueEquivalence, expireAfterWriteNanos, expireAfterAccessNanos, maximumSize, concurrencyLevel, evictionListener, delegate);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            this.writeMapTo(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(in);
            this.delegate = mapMaker.makeMap();
            this.readEntries(in);
        }

        private Object readResolve() {
            return this.delegate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractSerializationProxy<K, V>
    extends ForwardingConcurrentMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 2L;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence<Object> keyEquivalence;
        final Equivalence<Object> valueEquivalence;
        final long expireAfterWriteNanos;
        final long expireAfterAccessNanos;
        final int maximumSize;
        final int concurrencyLevel;
        final MapEvictionListener<? super K, ? super V> evictionListener;
        transient ConcurrentMap<K, V> delegate;

        AbstractSerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, int maximumSize, int concurrencyLevel, MapEvictionListener<? super K, ? super V> evictionListener, ConcurrentMap<K, V> delegate) {
            this.keyStrength = keyStrength;
            this.valueStrength = valueStrength;
            this.keyEquivalence = keyEquivalence;
            this.valueEquivalence = valueEquivalence;
            this.expireAfterWriteNanos = expireAfterWriteNanos;
            this.expireAfterAccessNanos = expireAfterAccessNanos;
            this.maximumSize = maximumSize;
            this.concurrencyLevel = concurrencyLevel;
            this.evictionListener = evictionListener;
            this.delegate = delegate;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.delegate;
        }

        void writeMapTo(ObjectOutputStream out) throws IOException {
            out.writeInt(this.delegate.size());
            for (Map.Entry entry : this.delegate.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
            out.writeObject(null);
        }

        MapMaker readMapMaker(ObjectInputStream in) throws IOException {
            int size = in.readInt();
            MapMaker mapMaker = new MapMaker().initialCapacity(size).setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).privateKeyEquivalence(this.keyEquivalence).privateValueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel);
            mapMaker.evictionListener(this.evictionListener);
            if (this.expireAfterWriteNanos > 0L) {
                mapMaker.expireAfterWrite(this.expireAfterWriteNanos, TimeUnit.NANOSECONDS);
            }
            if (this.expireAfterAccessNanos > 0L) {
                mapMaker.expireAfterAccess(this.expireAfterAccessNanos, TimeUnit.NANOSECONDS);
            }
            if (this.maximumSize != -1) {
                mapMaker.maximumSize(this.maximumSize);
            }
            return mapMaker;
        }

        void readEntries(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Object key;
            while ((key = in.readObject()) != null) {
                Object value = in.readObject();
                this.delegate.put(key, value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = CustomConcurrentHashMap.this.get(key);
            return v != null && CustomConcurrentHashMap.this.valueEquivalence.equivalent(e.getValue(), v);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && CustomConcurrentHashMap.this.remove(key, e.getValue());
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CustomConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CustomConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CustomConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V newValue) {
            Object oldValue = CustomConcurrentHashMap.this.put(this.key, newValue);
            this.value = newValue;
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        ReferenceEntry<K, V> nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = CustomConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = CustomConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        boolean advanceTo(ReferenceEntry<K, V> entry) {
            Object key = entry.getKey();
            Object value = entry.getValueReference().get();
            if (!(key == null || value == null || CustomConcurrentHashMap.this.expires() && CustomConcurrentHashMap.this.isExpired(entry))) {
                this.nextExternal = new WriteThroughEntry(key, value);
                return true;
            }
            return false;
        }

        public boolean hasNext() {
            return this.nextExternal != null;
        }

        WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            Preconditions.checkState(this.lastReturned != null);
            CustomConcurrentHashMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Segment
    extends ReentrantLock {
        volatile int count;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        final int maxSegmentSize;
        final Queue<ReferenceEntry<K, V>> cleanupQueue = new ConcurrentLinkedQueue();
        final Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount = new AtomicInteger();
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> evictionQueue;
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> expirationQueue;
        final Runnable cleanupRunnable = new Runnable(){

            public void run() {
                Segment.this.runCleanup();
            }
        };

        Segment(int initialCapacity, int maxSegmentSize) {
            this.maxSegmentSize = maxSegmentSize;
            this.initTable(this.newEntryArray(initialCapacity));
            this.recencyQueue = CustomConcurrentHashMap.this.evictsBySize() || CustomConcurrentHashMap.this.expiresAfterAccess() ? new ConcurrentLinkedQueue() : CustomConcurrentHashMap.discardingQueue();
            this.evictionQueue = CustomConcurrentHashMap.this.evictsBySize() ? new EvictionQueue() : CustomConcurrentHashMap.discardingQueue();
            this.expirationQueue = CustomConcurrentHashMap.this.expires() ? new ExpirationQueue() : CustomConcurrentHashMap.discardingQueue();
        }

        AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int size) {
            return new AtomicReferenceArray(size);
        }

        void initTable(AtomicReferenceArray<ReferenceEntry<K, V>> newTable) {
            this.threshold = newTable.length() * 3 / 4;
            if (this.threshold == this.maxSegmentSize) {
                ++this.threshold;
            }
            this.table = newTable;
        }

        @GuardedBy(value="Segment.this")
        void setValue(ReferenceEntry<K, V> entry, V value) {
            this.recordWrite(entry);
            ValueReference valueReference = CustomConcurrentHashMap.this.newValueReference(entry, value);
            entry.setValueReference(valueReference);
        }

        void recordRead(ReferenceEntry<K, V> entry) {
            if (CustomConcurrentHashMap.this.expiresAfterAccess()) {
                this.recordExpirationTime(entry, CustomConcurrentHashMap.this.expireAfterAccessNanos);
            }
            this.recencyQueue.add(entry);
        }

        @GuardedBy(value="Segment.this")
        void recordLockedRead(ReferenceEntry<K, V> entry) {
            this.evictionQueue.add(entry);
            if (CustomConcurrentHashMap.this.expiresAfterAccess()) {
                this.recordExpirationTime(entry, CustomConcurrentHashMap.this.expireAfterAccessNanos);
                this.expirationQueue.add(entry);
            }
        }

        @GuardedBy(value="Segment.this")
        void recordWrite(ReferenceEntry<K, V> entry) {
            this.drainRecencyQueue();
            this.evictionQueue.add(entry);
            if (CustomConcurrentHashMap.this.expires()) {
                long expiration = CustomConcurrentHashMap.this.expiresAfterAccess() ? CustomConcurrentHashMap.this.expireAfterAccessNanos : CustomConcurrentHashMap.this.expireAfterWriteNanos;
                this.recordExpirationTime(entry, expiration);
                this.expirationQueue.add(entry);
            }
        }

        @GuardedBy(value="Segment.this")
        void drainRecencyQueue() {
            ReferenceEntry e;
            while ((e = this.recencyQueue.poll()) != null) {
                if (this.evictionQueue.contains(e)) {
                    this.evictionQueue.add(e);
                }
                if (!CustomConcurrentHashMap.this.expiresAfterAccess() || !this.expirationQueue.contains(e)) continue;
                this.expirationQueue.add(e);
            }
        }

        void recordExpirationTime(ReferenceEntry<K, V> entry, long expirationNanos) {
            entry.setExpirationTime(CustomConcurrentHashMap.this.ticker.read() + expirationNanos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void tryExpireEntries() {
            if (this.tryLock()) {
                try {
                    this.expireEntries();
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        void expireEntries() {
            ReferenceEntry e;
            this.drainRecencyQueue();
            if (this.expirationQueue.isEmpty()) {
                return;
            }
            long now = CustomConcurrentHashMap.this.ticker.read();
            while ((e = this.expirationQueue.peek()) != null && CustomConcurrentHashMap.this.isExpired(e, now)) {
                if (!this.unsetEntry(e, e.getHash())) {
                    throw new AssertionError();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        boolean evictEntries() {
            if (CustomConcurrentHashMap.this.evictsBySize() && this.count >= this.maxSegmentSize) {
                this.drainRecencyQueue();
                ReferenceEntry e = this.evictionQueue.remove();
                if (!this.unsetEntry(e, e.getHash())) {
                    throw new AssertionError();
                }
                return true;
            }
            return false;
        }

        ReferenceEntry<K, V> getFirst(int hash) {
            AtomicReferenceArray table = this.table;
            return table.get(hash & table.length() - 1);
        }

        @VisibleForTesting
        ReferenceEntry<K, V> getEntry(Object key, int hash) {
            for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                Object entryKey;
                if (e.getHash() != hash || (entryKey = e.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                return e;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V get(Object key, int hash) {
            try {
                if (this.count != 0) {
                    for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                        Object entryKey;
                        if (e.getHash() != hash || (entryKey = e.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                        Object value = this.getLiveValue(e);
                        if (value != null) {
                            this.recordRead(e);
                        }
                        Object v = value;
                        return v;
                    }
                }
                Object v = null;
                return v;
            }
            finally {
                this.postReadCleanup();
            }
        }

        boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey;
                    if (e.getHash() != hash || (entryKey = e.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    return this.getLiveValue(e) != null;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                AtomicReferenceArray table = this.table;
                int length = table.length();
                for (int i = 0; i < length; ++i) {
                    for (ReferenceEntry e = table.get(i); e != null; e = e.getNext()) {
                        Object entryValue = this.getLiveValue(e);
                        if (entryValue == null || !CustomConcurrentHashMap.this.valueEquivalence.equivalent(value, entryValue)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            Preconditions.checkNotNull(oldValue);
            Preconditions.checkNotNull(newValue);
            this.lock();
            try {
                this.preWriteCleanup();
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValueReference().get();
                    if (entryValue == null) {
                        this.unsetLiveEntry(e, hash);
                        boolean bl = false;
                        return bl;
                    }
                    if (CustomConcurrentHashMap.this.valueEquivalence.equivalent(oldValue, entryValue)) {
                        this.setValue(e, newValue);
                        boolean bl = true;
                        return bl;
                    }
                    this.recordLockedRead(e);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key, int hash, V newValue) {
            Preconditions.checkNotNull(newValue);
            this.lock();
            try {
                this.preWriteCleanup();
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValueReference().get();
                    if (entryValue == null) {
                        this.unsetLiveEntry(e, hash);
                        Object v = null;
                        return v;
                    }
                    this.setValue(e, newValue);
                    Object v = entryValue;
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent) {
            Preconditions.checkNotNull(value);
            this.lock();
            try {
                ReferenceEntry first;
                this.preWriteCleanup();
                int newCount = this.count + 1;
                if (newCount > this.threshold) {
                    this.expand();
                    newCount = this.count + 1;
                }
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference valueReference = e.getValueReference();
                    Object entryValue = valueReference.get();
                    if (entryValue == null) {
                        ++this.modCount;
                        valueReference.notifyValueReclaimed();
                        this.evictEntries();
                        this.count = newCount = this.count + 1;
                    } else if (onlyIfAbsent) {
                        this.recordLockedRead(e);
                        Object v = entryValue;
                        return v;
                    }
                    this.setValue(e, value);
                    Object v = entryValue;
                    return v;
                }
                if (this.evictEntries()) {
                    newCount = this.count + 1;
                    first = table.get(index);
                }
                ++this.modCount;
                ReferenceEntry newEntry = CustomConcurrentHashMap.this.newEntry(key, hash, first);
                this.setValue(newEntry, value);
                table.set(index, newEntry);
                this.count = newCount;
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        @GuardedBy(value="Segment.this")
        void expand() {
            AtomicReferenceArray oldTable = this.table;
            int oldCapacity = oldTable.length();
            if (oldCapacity >= 0x40000000) {
                return;
            }
            AtomicReferenceArray newTable = this.newEntryArray(oldCapacity << 1);
            this.threshold = newTable.length() * 3 / 4;
            int newMask = newTable.length() - 1;
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                int newIndex;
                ReferenceEntry e;
                ReferenceEntry head = oldTable.get(oldIndex);
                if (head == null) continue;
                ReferenceEntry next = head.getNext();
                int headIndex = head.getHash() & newMask;
                if (next == null) {
                    newTable.set(headIndex, head);
                    continue;
                }
                ReferenceEntry tail = head;
                int tailIndex = headIndex;
                for (e = next; e != null; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    if (newIndex == tailIndex) continue;
                    tailIndex = newIndex;
                    tail = e;
                }
                newTable.set(tailIndex, tail);
                for (e = head; e != tail; e = e.getNext()) {
                    if (CustomConcurrentHashMap.this.isCollected(e)) {
                        this.unsetLiveEntry(e, e.getHash());
                        continue;
                    }
                    newIndex = e.getHash() & newMask;
                    ReferenceEntry newNext = newTable.get(newIndex);
                    newTable.set(newIndex, CustomConcurrentHashMap.this.copyEntry(e, newNext));
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash) {
            this.lock();
            try {
                ReferenceEntry first;
                this.preWriteCleanup();
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValueReference().get();
                    if (entryValue == null) {
                        this.unsetLiveEntry(e, hash);
                    } else {
                        ++this.modCount;
                        ReferenceEntry newFirst = this.removeFromChain(first, e);
                        newCount = this.count - 1;
                        table.set(index, newFirst);
                        this.count = newCount;
                    }
                    Object v = entryValue;
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(Object key, int hash, Object value) {
            Preconditions.checkNotNull(value);
            this.lock();
            try {
                ReferenceEntry first;
                this.preWriteCleanup();
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValueReference().get();
                    if (entryValue == null) {
                        this.unsetLiveEntry(e, hash);
                    } else if (CustomConcurrentHashMap.this.valueEquivalence.equivalent(value, entryValue)) {
                        ++this.modCount;
                        ReferenceEntry newFirst = this.removeFromChain(first, e);
                        newCount = this.count - 1;
                        table.set(index, newFirst);
                        this.count = newCount;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> removeFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry) {
            this.evictionQueue.remove(entry);
            this.expirationQueue.remove(entry);
            ReferenceEntry newFirst = entry.getNext();
            for (ReferenceEntry e = first; e != entry; e = e.getNext()) {
                if (CustomConcurrentHashMap.this.isCollected(e)) {
                    this.unsetLiveEntry(e, e.getHash());
                    continue;
                }
                newFirst = CustomConcurrentHashMap.this.copyEntry(e, newFirst);
            }
            return newFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean unsetKey(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry first;
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    if (e != entry) continue;
                    ++this.modCount;
                    CustomConcurrentHashMap.this.enqueueNotification(e.getKey(), hash, e.getValueReference());
                    this.enqueueCleanup(e);
                    this.count = newCount;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean unsetValue(K key, int hash, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                int newCount = this.count - 1;
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference v = e.getValueReference();
                    if (v == valueReference) {
                        ++this.modCount;
                        CustomConcurrentHashMap.this.enqueueNotification(key, hash, valueReference);
                        this.enqueueCleanup(e);
                        this.count = newCount;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean clearValue(K key, int hash, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference v = e.getValueReference();
                    if (v == valueReference) {
                        this.enqueueCleanup(e);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        @GuardedBy(value="Segment.this")
        boolean unsetEntry(ReferenceEntry<K, V> entry, int hash) {
            for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                if (e != entry) continue;
                return this.unsetLiveEntry(entry, hash);
            }
            return false;
        }

        @GuardedBy(value="Segment.this")
        boolean unsetLiveEntry(ReferenceEntry<K, V> entry, int hash) {
            if (CustomConcurrentHashMap.this.isUnset(entry)) {
                return false;
            }
            int newCount = this.count - 1;
            ++this.modCount;
            ValueReference valueReference = entry.getValueReference();
            if (valueReference.isComputingReference()) {
                return false;
            }
            Object key = entry.getKey();
            CustomConcurrentHashMap.this.enqueueNotification(key, hash, valueReference);
            this.enqueueCleanup(entry);
            this.count = newCount;
            return true;
        }

        @GuardedBy(value="Segment.this")
        void enqueueCleanup(ReferenceEntry<K, V> entry) {
            ValueReference unset = CustomConcurrentHashMap.unset();
            entry.setValueReference(unset);
            this.cleanupQueue.offer(entry);
            this.evictionQueue.remove(entry);
            this.expirationQueue.remove(entry);
        }

        V getLiveValue(ReferenceEntry<K, V> entry) {
            if (entry.getKey() == null) {
                return null;
            }
            Object value = entry.getValueReference().get();
            if (value == null) {
                return null;
            }
            if (CustomConcurrentHashMap.this.expires() && CustomConcurrentHashMap.this.isExpired(entry)) {
                this.tryExpireEntries();
                return null;
            }
            return value;
        }

        @GuardedBy(value="Segment.this")
        void processPendingCleanup() {
            ReferenceEntry entry;
            AtomicReferenceArray table = this.table;
            int cleanedUp = 0;
            block0: while (cleanedUp < 16 && (entry = this.cleanupQueue.poll()) != null) {
                ReferenceEntry first;
                int index = entry.getHash() & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    if (e != entry) continue;
                    if (!CustomConcurrentHashMap.this.isUnset(e)) continue block0;
                    ReferenceEntry newFirst = this.removeFromChain(first, e);
                    table.set(index, newFirst);
                    ++cleanedUp;
                    continue block0;
                }
            }
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                if (CustomConcurrentHashMap.this.isInlineCleanup()) {
                    this.runCleanup();
                } else if (!this.isHeldByCurrentThread()) {
                    CustomConcurrentHashMap.this.cleanupExecutor.execute(this.cleanupRunnable);
                }
            }
        }

        @GuardedBy(value="Segment.this")
        void preWriteCleanup() {
            if (CustomConcurrentHashMap.this.isInlineCleanup()) {
                this.runLockedCleanup();
            } else {
                this.expireEntries();
            }
        }

        void postWriteCleanup() {
            if (CustomConcurrentHashMap.this.isInlineCleanup()) {
                if (this.isHeldByCurrentThread()) {
                    this.runLockedCleanup();
                } else {
                    this.runUnlockedCleanup();
                }
            } else if (!this.isHeldByCurrentThread()) {
                CustomConcurrentHashMap.this.cleanupExecutor.execute(this.cleanupRunnable);
            }
        }

        void runCleanup() {
            this.runLockedCleanup();
            this.runUnlockedCleanup();
        }

        void runUnlockedCleanup() {
            CustomConcurrentHashMap.this.processPendingNotifications();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runLockedCleanup() {
            this.lock();
            try {
                this.expireEntries();
                this.processPendingCleanup();
                this.readCount.set(0);
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    AtomicReferenceArray table = this.table;
                    for (int i = 0; i < table.length(); ++i) {
                        table.set(i, null);
                    }
                    this.evictionQueue.clear();
                    this.expirationQueue.clear();
                    this.readCount.set(0);
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @VisibleForTesting
        class ExpirationQueue
        extends AbstractQueue<ReferenceEntry<K, V>> {
            @VisibleForTesting
            final ReferenceEntry<K, V> head = new ReferenceEntry<K, V>(){
                ReferenceEntry<K, V> nextExpirable = this;
                ReferenceEntry<K, V> previousExpirable = this;

                @Override
                public long getExpirationTime() {
                    return Long.MAX_VALUE;
                }

                @Override
                public void setExpirationTime(long time) {
                }

                @Override
                public ReferenceEntry<K, V> getNextExpirable() {
                    return this.nextExpirable;
                }

                @Override
                public void setNextExpirable(ReferenceEntry<K, V> next) {
                    this.nextExpirable = next;
                }

                @Override
                public ReferenceEntry<K, V> getPreviousExpirable() {
                    return this.previousExpirable;
                }

                @Override
                public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
                    this.previousExpirable = previous;
                }

                @Override
                public ValueReference<K, V> getValueReference() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setValueReference(ValueReference<K, V> valueReference) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void notifyKeyReclaimed() {
                }

                @Override
                public void notifyValueReclaimed(ValueReference<K, V> valueReference) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ReferenceEntry<K, V> getNext() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int getHash() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public K getKey() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ReferenceEntry<K, V> getNextEvictable() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setNextEvictable(ReferenceEntry<K, V> next) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ReferenceEntry<K, V> getPreviousEvictable() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
                    throw new UnsupportedOperationException();
                }
            };

            ExpirationQueue() {
            }

            @Override
            public boolean offer(ReferenceEntry<K, V> entry) {
                CustomConcurrentHashMap.connectExpirables(entry.getPreviousExpirable(), entry.getNextExpirable());
                CustomConcurrentHashMap.connectExpirables(this.head.getPreviousExpirable(), entry);
                CustomConcurrentHashMap.connectExpirables(entry, this.head);
                return true;
            }

            @Override
            public ReferenceEntry<K, V> peek() {
                ReferenceEntry next = this.head.getNextExpirable();
                return next == this.head ? null : next;
            }

            @Override
            public ReferenceEntry<K, V> poll() {
                ReferenceEntry next = this.head.getNextExpirable();
                if (next == this.head) {
                    return null;
                }
                this.remove(next);
                return next;
            }

            @Override
            public boolean remove(Object o) {
                ReferenceEntry e = (ReferenceEntry)o;
                ReferenceEntry previous = e.getPreviousExpirable();
                ReferenceEntry next = e.getNextExpirable();
                CustomConcurrentHashMap.connectExpirables(previous, next);
                CustomConcurrentHashMap.nullifyExpirable(e);
                return next != NullEntry.INSTANCE;
            }

            @Override
            public boolean contains(Object o) {
                ReferenceEntry e = (ReferenceEntry)o;
                return e.getNextExpirable() != NullEntry.INSTANCE;
            }

            @Override
            public boolean isEmpty() {
                return this.head.getNextExpirable() == this.head;
            }

            @Override
            public int size() {
                int size = 0;
                for (ReferenceEntry e = this.head.getNextExpirable(); e != this.head; e = e.getNextExpirable()) {
                    ++size;
                }
                return size;
            }

            @Override
            public void clear() {
                ReferenceEntry e = this.head.getNextExpirable();
                while (e != this.head) {
                    ReferenceEntry next = e.getNextExpirable();
                    CustomConcurrentHashMap.nullifyExpirable(e);
                    e = next;
                }
                this.head.setNextExpirable(this.head);
                this.head.setPreviousExpirable(this.head);
            }

            @Override
            public Iterator<ReferenceEntry<K, V>> iterator() {
                return new AbstractLinkedIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                    @Override
                    protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> previous) {
                        ReferenceEntry next = previous.getNextExpirable();
                        return next == ExpirationQueue.this.head ? null : next;
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @VisibleForTesting
        class EvictionQueue
        extends AbstractQueue<ReferenceEntry<K, V>> {
            @VisibleForTesting
            final ReferenceEntry<K, V> head = new ReferenceEntry<K, V>(){
                ReferenceEntry<K, V> nextEvictable = this;
                ReferenceEntry<K, V> previousEvictable = this;

                @Override
                public ReferenceEntry<K, V> getNextEvictable() {
                    return this.nextEvictable;
                }

                @Override
                public void setNextEvictable(ReferenceEntry<K, V> next) {
                    this.nextEvictable = next;
                }

                @Override
                public ReferenceEntry<K, V> getPreviousEvictable() {
                    return this.previousEvictable;
                }

                @Override
                public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
                    this.previousEvictable = previous;
                }

                @Override
                public ValueReference<K, V> getValueReference() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setValueReference(ValueReference<K, V> valueReference) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void notifyKeyReclaimed() {
                }

                @Override
                public void notifyValueReclaimed(ValueReference<K, V> valueReference) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ReferenceEntry<K, V> getNext() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int getHash() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public K getKey() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public long getExpirationTime() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setExpirationTime(long time) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ReferenceEntry<K, V> getNextExpirable() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setNextExpirable(ReferenceEntry<K, V> next) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ReferenceEntry<K, V> getPreviousExpirable() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
                    throw new UnsupportedOperationException();
                }
            };

            EvictionQueue() {
            }

            @Override
            public boolean offer(ReferenceEntry<K, V> entry) {
                CustomConcurrentHashMap.connectEvictables(entry.getPreviousEvictable(), entry.getNextEvictable());
                CustomConcurrentHashMap.connectEvictables(this.head.getPreviousEvictable(), entry);
                CustomConcurrentHashMap.connectEvictables(entry, this.head);
                return true;
            }

            @Override
            public ReferenceEntry<K, V> peek() {
                ReferenceEntry next = this.head.getNextEvictable();
                return next == this.head ? null : next;
            }

            @Override
            public ReferenceEntry<K, V> poll() {
                ReferenceEntry next = this.head.getNextEvictable();
                if (next == this.head) {
                    return null;
                }
                this.remove(next);
                return next;
            }

            @Override
            public boolean remove(Object o) {
                ReferenceEntry e = (ReferenceEntry)o;
                ReferenceEntry previous = e.getPreviousEvictable();
                ReferenceEntry next = e.getNextEvictable();
                CustomConcurrentHashMap.connectEvictables(previous, next);
                CustomConcurrentHashMap.nullifyEvictable(e);
                return next != NullEntry.INSTANCE;
            }

            @Override
            public boolean contains(Object o) {
                ReferenceEntry e = (ReferenceEntry)o;
                return e.getNextEvictable() != NullEntry.INSTANCE;
            }

            @Override
            public boolean isEmpty() {
                return this.head.getNextEvictable() == this.head;
            }

            @Override
            public int size() {
                int size = 0;
                for (ReferenceEntry e = this.head.getNextEvictable(); e != this.head; e = e.getNextEvictable()) {
                    ++size;
                }
                return size;
            }

            @Override
            public void clear() {
                ReferenceEntry e = this.head.getNextEvictable();
                while (e != this.head) {
                    ReferenceEntry next = e.getNextEvictable();
                    CustomConcurrentHashMap.nullifyEvictable(e);
                    e = next;
                }
                this.head.setNextEvictable(this.head);
                this.head.setPreviousEvictable(this.head);
            }

            @Override
            public Iterator<ReferenceEntry<K, V>> iterator() {
                return new AbstractLinkedIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                    @Override
                    protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> previous) {
                        ReferenceEntry next = previous.getNextEvictable();
                        return next == EvictionQueue.this.head ? null : next;
                    }
                };
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V referent) {
            this.referent = referent;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }

        @Override
        public void notifyValueReclaimed() {
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftValueReference<K, V>
    extends FinalizableSoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        SoftValueReference(V referent, ReferenceEntry<K, V> entry) {
            super(referent, QueueHolder.queue);
            this.entry = entry;
        }

        @Override
        public void notifyValueReclaimed() {
            this.finalizeReferent();
        }

        @Override
        public void finalizeReferent() {
            this.entry.notifyValueReclaimed(this);
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return new SoftValueReference(this.get(), entry);
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakValueReference<K, V>
    extends FinalizableWeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        WeakValueReference(V referent, ReferenceEntry<K, V> entry) {
            super(referent, QueueHolder.queue);
            this.entry = entry;
        }

        @Override
        public void notifyValueReclaimed() {
            this.finalizeReferent();
        }

        @Override
        public void finalizeReferent() {
            this.entry.notifyValueReclaimed(this);
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return new WeakValueReference(this.get(), entry);
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakExpirableEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        WeakExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        WeakEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakExpirableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();

        WeakExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEntry<K, V>
    extends FinalizableWeakReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.unset();

        WeakEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, QueueHolder.queue);
            this.map = map;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            this.notifyKeyReclaimed();
        }

        @Override
        public void notifyKeyReclaimed() {
            this.map.reclaimKey(this);
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            ValueReference<K, V> previous = this.valueReference;
            this.valueReference = valueReference;
            previous.clear();
        }

        @Override
        public void notifyValueReclaimed(ValueReference<K, V> v) {
            this.map.reclaimValue(this, v);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftExpirableEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        SoftExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        SoftEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftExpirableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();

        SoftExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEntry<K, V>
    extends FinalizableSoftReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.unset();

        SoftEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, QueueHolder.queue);
            this.map = map;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            this.notifyKeyReclaimed();
        }

        @Override
        public void notifyKeyReclaimed() {
            this.map.reclaimKey(this);
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            ValueReference<K, V> previous = this.valueReference;
            this.valueReference = valueReference;
            previous.clear();
        }

        @Override
        public void notifyValueReclaimed(ValueReference<K, V> v) {
            this.map.reclaimValue(this, v);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongExpirableEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        StrongExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        StrongEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongExpirableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();

        StrongExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        final K key;
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.unset();

        StrongEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            this.map = map;
            this.key = key;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public void notifyKeyReclaimed() {
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            ValueReference<K, V> previous = this.valueReference;
            this.valueReference = valueReference;
            previous.clear();
        }

        @Override
        public void notifyValueReclaimed(ValueReference<K, V> v) {
            this.map.reclaimValue(this, v);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NullEntry implements ReferenceEntry<Object, Object>
    {
        INSTANCE;


        @Override
        public ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public void notifyKeyReclaimed() {
        }

        @Override
        public void notifyValueReclaimed(ValueReference<Object, Object> v) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public int getHash() {
            return 0;
        }

        @Override
        public Object getKey() {
            return null;
        }

        @Override
        public long getExpirationTime() {
            return 0L;
        }

        @Override
        public void setExpirationTime(long time) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNextExpirable() {
            return this;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousExpirable() {
            return this;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<Object, Object> previous) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNextEvictable() {
            return this;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousEvictable() {
            return this;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<Object, Object> previous) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        public void notifyKeyReclaimed();

        public void notifyValueReclaimed(ValueReference<K, V> var1);

        public ReferenceEntry<K, V> getNext();

        public int getHash();

        public K getKey();

        public long getExpirationTime();

        public void setExpirationTime(long var1);

        public ReferenceEntry<K, V> getNextExpirable();

        public void setNextExpirable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousExpirable();

        public void setPreviousExpirable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getNextEvictable();

        public void setNextEvictable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousEvictable();

        public void setPreviousEvictable(ReferenceEntry<K, V> var1);
    }

    private static class QueueHolder {
        static final FinalizableReferenceQueue queue = new FinalizableReferenceQueue();

        private QueueHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ValueReference<K, V> {
        public V get();

        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> var1);

        public V waitForValue() throws InterruptedException;

        public void clear();

        public boolean isComputingReference();

        public void notifyValueReclaimed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryFactory {
        STRONG{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        STRONG_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        STRONG_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        STRONG_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        SOFT_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        WEAK_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };

        static final int EXPIRABLE_MASK = 1;
        static final int EVICTABLE_MASK = 2;
        static final EntryFactory[][] factories;

        static EntryFactory getFactory(Strength keyStrength, boolean expireAfterWrite, boolean evictsBySize) {
            int flags = (expireAfterWrite ? 1 : 0) | (evictsBySize ? 2 : 0);
            return factories[keyStrength.ordinal()][flags];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> var1, K var2, int var3, @Nullable ReferenceEntry<K, V> var4);

        @GuardedBy(value="Segment.this")
        <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            return this.newEntry(map, original.getKey(), original.getHash(), newNext);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyExpirableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            newEntry.setExpirationTime(original.getExpirationTime());
            CustomConcurrentHashMap.connectExpirables(original.getPreviousExpirable(), newEntry);
            CustomConcurrentHashMap.connectExpirables(newEntry, original.getNextExpirable());
            CustomConcurrentHashMap.nullifyExpirable(original);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyEvictableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            CustomConcurrentHashMap.connectEvictables(original.getPreviousEvictable(), newEntry);
            CustomConcurrentHashMap.connectEvictables(newEntry, original.getNextEvictable());
            CustomConcurrentHashMap.nullifyEvictable(original);
        }

        static {
            factories = new EntryFactory[][]{{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE}, {SOFT, SOFT_EXPIRABLE, SOFT_EVICTABLE, SOFT_EXPIRABLE_EVICTABLE}, {WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE}};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Strength {
        STRONG{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new StrongValueReference(value);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.equals();
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new SoftValueReference<K, V>(value, entry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new WeakValueReference<K, V>(value, entry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        };


        abstract <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> var1, V var2);

        abstract Equivalence<Object> defaultEquivalence();
    }
}

