/*
 * Decompiled with CFR 0.152.
 */
package clover.com.atlassian.extras.core.transformer;

import clover.com.atlassian.extras.api.Product;
import clover.com.atlassian.extras.common.log.Logger;
import clover.com.atlassian.extras.common.util.LicenseProperties;
import clover.com.atlassian.extras.core.transformer.LicensePropertiesTransformer;
import clover.com.atlassian.extras.core.transformer.OverriddingLicenseProperties;
import clover.com.atlassian.extras.legacy.util.OldLicenseTypeResolver;
import clover.com.atlassian.license.LicenseException;
import clover.com.atlassian.license.LicenseType;
import clover.com.atlassian.license.LicenseTypeStore;
import java.util.Properties;

public class Version1LicenseTypeTransformer
implements LicensePropertiesTransformer {
    protected final Logger.Log log = Logger.getInstance(this.getClass());

    public LicenseProperties transform(Product product, LicenseProperties properties) {
        String licenseTypeName = properties.getProperty("LicenseTypeName");
        if (licenseTypeName == null) {
            LicenseTypeStore typeStore;
            String oldLicenseTypeName = properties.getProperty("LicenseType");
            if (oldLicenseTypeName != null && (typeStore = OldLicenseTypeResolver.getLicenseTypeStore(product)) != null) {
                try {
                    LicenseType oldType = typeStore.getLicenseType(oldLicenseTypeName);
                    if (oldType != null) {
                        Properties prop = new Properties();
                        prop.setProperty("LicenseTypeName", oldType.getNewLicenseTypeName());
                        return new OverriddingLicenseProperties(product, properties, prop);
                    }
                }
                catch (LicenseException e) {
                    this.log.warn("License type '" + oldLicenseTypeName + "' can not be resolved. This is a potentially corrupt license.", e);
                    return properties;
                }
            }
            this.log.warn("License type '" + oldLicenseTypeName + "' can not be resolved. This is a potentially corrupt license.");
            return properties;
        }
        return properties;
    }
}

