/*
 * Decompiled with CFR 0.152.
 */
package clover.com.atlassian.extras.core.bamboo;

import clover.com.atlassian.extras.api.LicenseEdition;
import clover.com.atlassian.extras.api.LicenseType;
import clover.com.atlassian.extras.api.Product;
import clover.com.atlassian.extras.api.bamboo.BambooLicense;
import clover.com.atlassian.extras.common.LicenseTypeAndEditionResolver;
import clover.com.atlassian.extras.common.util.LicenseProperties;
import clover.com.atlassian.extras.core.DefaultProductLicense;

class DefaultBambooLicense
extends DefaultProductLicense
implements BambooLicense {
    private static final int MAX_REMOTE_AGENTS_NONE = 0;
    private static final int MAX_REMOTE_AGENTS_STANDARD = 1;
    private static final int MAX_REMOTE_AGENTS_PROFESSIONAL = 10;
    private static final int MAX_REMOTE_AGENTS_ENTERPRISE = 25;
    private static final int MAX_REMOTE_AGENTS_UNLIMITED = 100;
    private static final int MAX_LOCAL_AGENTS_BASIC = 1;
    private static final int MAX_LOCAL_AGENTS_UNLIMITED = -1;
    private static final int MAX_PLANS_STARTER = 10;
    private static final int MAX_PLANS_UNLIMITED = -1;
    private final int maximumNumberOfRemoteAgents;
    private final int maximumNumberOfLocalAgents;
    private final int maximumNumberOfPlans;
    private final LicenseEdition licenseEdition;

    DefaultBambooLicense(Product product, LicenseProperties licenseProperties) {
        super(product, licenseProperties);
        this.licenseEdition = LicenseTypeAndEditionResolver.getLicenseEdition(licenseProperties.getProperty("LicenseEdition"));
        this.maximumNumberOfRemoteAgents = this.calculateRemoteAgents(licenseProperties);
        this.maximumNumberOfLocalAgents = this.calculateLocalAgents(licenseProperties);
        this.maximumNumberOfPlans = this.calculatePlans(licenseProperties);
    }

    public LicenseEdition getLicenseEdition() {
        return this.licenseEdition;
    }

    public int getMaximumNumberOfRemoteAgents() {
        return this.maximumNumberOfRemoteAgents;
    }

    public int getMaximumNumberOfLocalAgents() {
        return this.maximumNumberOfLocalAgents;
    }

    public int getMaximumNumberOfPlans() {
        return this.maximumNumberOfPlans;
    }

    public boolean isUnlimitedRemoteAgents() {
        return -1 == this.maximumNumberOfRemoteAgents;
    }

    public boolean isUnlimitedLocalAgents() {
        return -1 == this.maximumNumberOfLocalAgents;
    }

    public boolean isUnlimitedPlans() {
        return -1 == this.maximumNumberOfPlans;
    }

    private int calculateRemoteAgents(LicenseProperties licenseProperties) {
        String maxRemoteString = licenseProperties.getProperty("NumberOfBambooRemoteAgents");
        if (maxRemoteString != null && maxRemoteString.length() != 0) {
            try {
                return Integer.parseInt(maxRemoteString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (LicenseType.STARTER.equals((Object)this.getLicenseType())) {
            return 0;
        }
        if (LicenseEdition.STANDARD.equals((Object)this.licenseEdition)) {
            return 1;
        }
        if (LicenseEdition.PROFESSIONAL.equals((Object)this.licenseEdition)) {
            return 10;
        }
        if (LicenseEdition.ENTERPRISE.equals((Object)this.licenseEdition)) {
            return 25;
        }
        if (LicenseEdition.UNLIMITED.equals((Object)this.licenseEdition)) {
            return 100;
        }
        return 0;
    }

    private int calculateLocalAgents(LicenseProperties licenseProperties) {
        String maxLocalString = licenseProperties.getProperty("NumberOfBambooLocalAgents");
        if (maxLocalString != null && maxLocalString.length() != 0) {
            try {
                return Integer.parseInt(maxLocalString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (LicenseType.STARTER.equals((Object)this.getLicenseType())) {
            return -1;
        }
        if (LicenseEdition.BASIC.equals((Object)this.licenseEdition)) {
            return 1;
        }
        return -1;
    }

    private int calculatePlans(LicenseProperties licenseProperties) {
        String maxPlanString = licenseProperties.getProperty("NumberOfBambooPlans");
        if (maxPlanString != null && maxPlanString.length() != 0) {
            try {
                return Integer.parseInt(maxPlanString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (LicenseType.STARTER.equals((Object)this.getLicenseType())) {
            return 10;
        }
        return -1;
    }
}

