/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.util;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public abstract class Attribute
implements Serializable {
    private static final long serialVersionUID = 1010771448030194792L;
    protected String mName;
    protected String mAssignment;
    protected String mValue;
    protected char mQuote;

    public Attribute(String name, String assignment, String value, char quote) {
        this.mName = name;
        this.mAssignment = assignment;
        if ('\u0000' == quote) {
            this.setRawValue(value);
        } else {
            this.mValue = value;
            this.mQuote = quote;
        }
    }

    public Attribute(String name, String value, char quote) {
        this(name, null == value ? "" : "=", value, quote);
    }

    public Attribute(String value) throws IllegalArgumentException {
        if (0 != value.trim().length()) {
            throw new IllegalArgumentException("non whitespace value");
        }
        this.mName = null;
        this.mAssignment = null;
        this.mValue = value;
        this.mQuote = '\u0000';
    }

    public Attribute(String name, String value) {
        this(name, null == value ? "" : "=", value, '\u0000');
    }

    public Attribute(String name, String assignment, String value) {
        this(name, assignment, value, '\u0000');
    }

    public Attribute() {
        this(null, null, null, '\u0000');
    }

    public String getName() {
        return this.mName;
    }

    public void getName(StringBuilder buffer) {
        if (null != this.mName) {
            buffer.append(this.mName);
        }
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getAssignment() {
        return this.mAssignment;
    }

    public void getAssignment(StringBuilder buffer) {
        if (null != this.mAssignment) {
            buffer.append(this.mAssignment);
        }
    }

    public void setAssignment(String assignment) {
        this.mAssignment = assignment;
    }

    public String getValue() {
        return this.mValue;
    }

    public void getValue(StringBuilder buffer) {
        if (null != this.mValue) {
            buffer.append(this.mValue);
        }
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public char getQuote() {
        return this.mQuote;
    }

    public void getQuote(StringBuilder buffer) {
        if ('\u0000' != this.mQuote) {
            buffer.append(this.mQuote);
        }
    }

    public void setQuote(char quote) {
        this.mQuote = quote;
    }

    public String getRawValue() {
        String ret;
        if (this.isValued()) {
            char quote = this.getQuote();
            if ('\u0000' != quote) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(quote);
                this.getValue(buffer);
                buffer.append(quote);
                ret = buffer.toString();
            } else {
                ret = this.getValue();
            }
        } else {
            ret = null;
        }
        return ret;
    }

    public void getRawValue(StringBuilder buffer) {
        if (null != this.mValue) {
            buffer.append("\"");
            this.getValue(buffer);
            buffer.append("\"");
        }
    }

    public void setRawValue(String value) {
        int quote = 0;
        if (null != value && 0 != value.trim().length()) {
            if (value.startsWith("'") && value.endsWith("'") && 2 <= value.length()) {
                quote = 39;
                value = value.substring(1, value.length() - 1);
            } else if (value.startsWith("\"") && value.endsWith("\"") && 2 <= value.length()) {
                quote = 34;
                value = value.substring(1, value.length() - 1);
            } else {
                boolean needed = false;
                boolean singleq = true;
                boolean doubleq = true;
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if ('\'' == ch) {
                        singleq = false;
                        needed = true;
                        continue;
                    }
                    if ('\"' == ch) {
                        doubleq = false;
                        needed = true;
                        continue;
                    }
                    if ('-' == ch || '.' == ch || '_' == ch || ':' == ch || Character.isLetterOrDigit(ch)) continue;
                    needed = true;
                }
                if (needed) {
                    if (doubleq) {
                        quote = 34;
                    } else if (singleq) {
                        quote = 39;
                    } else {
                        quote = 34;
                        value = StringUtils.replace((String)value, (String)"\"", (String)"&quot;");
                    }
                }
            }
        }
        this.setValue(value);
        this.setQuote((char)quote);
    }

    public boolean isWhitespace() {
        return null == this.getName();
    }

    public boolean isStandAlone() {
        return null != this.getName() && null == this.getAssignment();
    }

    public boolean isEmpty() {
        return null != this.getAssignment() && null == this.getValue();
    }

    public boolean isValued() {
        return null != this.getValue();
    }

    public int getLength() {
        char quote;
        String value;
        String assignment;
        int ret = 0;
        String name = this.getName();
        if (null != name) {
            ret += name.length();
        }
        if (null != (assignment = this.getAssignment())) {
            ret += assignment.length();
        }
        if (null != (value = this.getValue())) {
            ret += value.length();
        }
        if ('\u0000' != (quote = this.getQuote())) {
            ret += 2;
        }
        return ret;
    }

    public String toString() {
        int length = this.getLength();
        StringBuilder ret = new StringBuilder(length);
        this.toString(ret);
        return ret.toString();
    }

    public void toString(StringBuilder buffer) {
        this.getName(buffer);
        this.getAssignment(buffer);
        this.getRawValue(buffer);
    }
}

