/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLBlockTag;
import info.bliki.wiki.tags.NowikiTag;
import info.bliki.wiki.tags.util.INoBodyParsingTag;
import java.io.IOException;

public class PreTag
extends HTMLBlockTag
implements INoBodyParsingTag {
    public PreTag() {
        super("pre", "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            writer.append("\n<pre>");
            content = Configuration.NOWIKI_OPEN_PATTERN.matcher(content).replaceAll("");
            content = Configuration.NOWIKI_CLOSE_PATTERN.matcher(content).replaceAll("");
            NowikiTag.copyPre(content, writer, true);
            writer.append("</pre>");
        }
    }

    public boolean isReduceTokenStack() {
        return true;
    }
}

