/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner.util;

import java.util.ArrayList;
import java.util.List;

public class HtmlForm {
    public static final int GET = 0;
    public static final int POST = 1;
    private String mID;
    private String mName;
    private int mMethod = 1;
    private String mAction;
    private String mEncType;
    private List mElements = new ArrayList();

    public HtmlForm(String id, String name, int method, String action, String encType) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.mID = id;
        String string = this.mName = name != null ? name : "";
        if (method != 0 && method != 1) {
            throw new IllegalArgumentException("invalid method: " + method);
        }
        this.mMethod = method;
        this.mAction = action != null ? action : "";
        this.mEncType = encType != null ? encType : "";
    }

    public HtmlForm(String id, int method, String action, String encType) {
        this(id, "", method, action, encType);
    }

    public void addElement(Element element) {
        this.mElements.add(element);
    }

    public int getElementCount() {
        return this.mElements.size();
    }

    public Element getElement(int i) {
        return (Element)this.mElements.get(i);
    }

    public String getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public String getAction() {
        return this.mAction;
    }

    public String getEncType() {
        return this.mEncType;
    }

    public void setID(String mid) {
        this.mID = mid;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setMethod(int method) {
        this.mMethod = method;
    }

    public void setAction(String action) {
        this.mAction = action;
    }

    public void setEncType(String encType) {
        this.mEncType = encType;
    }

    public static class ElementAttribute {
        private String mName;
        private String mType;
        private String mValue;

        public ElementAttribute(String name, String atype, String value) {
            this.mName = name;
            this.mType = atype;
            this.mValue = value;
        }

        public String getName() {
            return this.mName;
        }

        public String getType() {
            return this.mType;
        }

        public String getValue() {
            return this.mValue;
        }

        public int hashCode() {
            int hc = this.mName.hashCode();
            hc = 31 * hc + this.mType.hashCode();
            hc = 31 * hc + this.mValue.hashCode();
            return hc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ElementAttribute) {
                ElementAttribute other = (ElementAttribute)o;
                return this.mName.equals(other.mName) && this.mType.equals(other.mType) && this.mValue.equals(other.mValue);
            }
            return false;
        }
    }

    public static class Element {
        private ElementAttribute[] mAttributes;
        private String mElementTag;
        private String mEmbeddedText;

        public Element(String tag, ElementAttribute[] attributes) {
            this.mElementTag = tag;
            int n = attributes != null ? attributes.length : 0;
            this.mAttributes = new ElementAttribute[n];
            if (n > 0) {
                System.arraycopy(attributes, 0, this.mAttributes, 0, n);
            }
        }

        public ElementAttribute getElementAttributeByName(String name) {
            for (int i = 0; i < this.mAttributes.length; ++i) {
                if (!name.equalsIgnoreCase(this.mAttributes[i].getName())) continue;
                return this.mAttributes[i];
            }
            return null;
        }

        public String getTag() {
            return this.mElementTag;
        }

        public boolean elementIsOfType(String type) {
            ElementAttribute att = this.getElementAttributeByName("type");
            if (att != null) {
                return type.equalsIgnoreCase(att.getValue());
            }
            return false;
        }

        public boolean isHiddenElement() {
            return this.mElementTag.equalsIgnoreCase("input") && this.elementIsOfType("hidden");
        }

        public boolean isTextElement() {
            return this.mElementTag.equalsIgnoreCase("input") && this.elementIsOfType("text");
        }

        public boolean isSubmitElement() {
            return this.mElementTag.equalsIgnoreCase("input") && this.elementIsOfType("submit");
        }

        public boolean isTextAreaElement() {
            return this.mElementTag.equalsIgnoreCase("textarea");
        }

        public String getEmbeddedText() {
            return this.mEmbeddedText != null ? this.mEmbeddedText : "";
        }

        public void setEmbeddedText(String text) {
            this.mEmbeddedText = text;
        }
    }
}

