/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.ErrorData;
import info.bliki.api.Page;
import info.bliki.api.ParseData;
import info.bliki.api.UnexpectedAnswerException;
import info.bliki.api.User;
import info.bliki.api.XMLEditParser;
import info.bliki.api.XMLPagesParser;
import info.bliki.api.XMLParseParser;
import info.bliki.api.XMLUserParser;
import info.bliki.api.query.Edit;
import info.bliki.api.query.Query;
import info.bliki.api.query.RequestBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connector {
    public static final String USER_AGENT = "plog4u.org/3.0";
    public static final String UTF8_CHARSET = "utf-8";
    public static final String PARAM_LOGIN_USERNAME = "lgusername";
    public static final String PARAM_LOGIN_USERID = "lguserid";
    public static final String PARAM_LOGIN_TOKEN = "lgtoken";
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_TITLES = "titles";
    public static final String PARAM_PAGE = "page";
    private MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
    private HttpClient client = new HttpClient((HttpConnectionManager)this.manager);

    public static String getAsXmlString(HttpMethod method) throws IOException {
        int indx;
        String responseBody;
        Header contentEncoding = method.getResponseHeader("Content-Encoding");
        InputStream instream = method.getResponseBodyAsStream();
        if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
            instream = new GZIPInputStream(instream);
        }
        if ((responseBody = Connector.convertStreamToString(instream)).length() > 0 && responseBody.charAt(0) != '<' && (indx = responseBody.indexOf("<?xml")) > 0) {
            responseBody = responseBody.substring(indx);
        }
        return responseBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeHttpMethod(HttpMethod method) {
        try {
            method.addRequestHeader("Accept-encoding", "gzip");
            int responseCode = this.client.executeMethod(method);
            if (responseCode == 200) {
                String string = Connector.getAsXmlString(method);
                return string;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User login(User user) {
        for (int i = 0; i < 2; ++i) {
            User user2;
            PostMethod method = new PostMethod(user.getActionUrl());
            String userName = user.getUsername();
            if (userName == null || userName.trim().length() == 0) {
                return user;
            }
            method.setFollowRedirects(false);
            method.addRequestHeader("User-Agent", USER_AGENT);
            String lgDomain = user.getDomain();
            ArrayList params = new ArrayList();
            method.addParameter(PARAM_ACTION, "login");
            method.addParameter(PARAM_FORMAT, "xml");
            method.addParameter("lgname", userName);
            method.addParameter("lgpassword", user.getPassword());
            if (lgDomain.length() > 0) {
                method.addParameter("lgdomain", user.getDomain());
            }
            if (i > 0) {
                method.addParameter(PARAM_LOGIN_TOKEN, user.getToken());
            }
            try {
                int responseCode = this.client.executeMethod((HttpMethod)method);
                if (responseCode != 200) continue;
                String responseBody = Connector.getAsXmlString((HttpMethod)method);
                XMLUserParser parser = new XMLUserParser(user, responseBody);
                parser.parse();
                if (i == 0 && user.getResult().equals("NeedToken")) {
                    continue;
                }
                if (!user.getResult().equals("Success")) break;
                User user3 = user;
                return user3;
            }
            catch (HttpException e) {
                e.printStackTrace();
                user2 = null;
                return user2;
            }
            catch (IOException e) {
                e.printStackTrace();
                user2 = null;
                return user2;
            }
            catch (SAXException e) {
                e.printStackTrace();
                user2 = null;
                return user2;
            }
            finally {
                method.releaseConnection();
            }
        }
        return null;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public MultiThreadedHttpConnectionManager getManager() {
        return this.manager;
    }

    public List<Page> queryContent(User user, List<String> listOfTitleStrings) {
        String[] valuePairs = new String[]{"prop", "revisions", "rvprop", "timestamp|user|comment|content"};
        return this.query(user, listOfTitleStrings, valuePairs);
    }

    public List<Page> queryCategories(User user, List<String> listOfTitleStrings) {
        String[] valuePairs = new String[]{"prop", "categories"};
        return this.query(user, listOfTitleStrings, valuePairs);
    }

    public List<Page> queryInfo(User user, List<String> listOfTitleStrings) {
        String[] valuePairs = new String[]{"prop", "info"};
        return this.query(user, listOfTitleStrings, valuePairs);
    }

    public List<Page> queryLinks(User user, List<String> listOfTitleStrings) {
        String[] valuePairs = new String[]{"prop", "links"};
        return this.query(user, listOfTitleStrings, valuePairs);
    }

    public List<Page> queryImageinfo(User user, List<String> listOfImageStrings) {
        String[] valuePairs = new String[]{"prop", "imageinfo", "iiprop", "url"};
        return this.query(user, listOfImageStrings, valuePairs);
    }

    public List<Page> queryImageinfo(User user, List<String> listOfImageStrings, int imageWidth) {
        String[] valuePairs = new String[]{"prop", "imageinfo", "iiprop", "url", "iiurlwidth", Integer.toString(imageWidth)};
        return this.query(user, listOfImageStrings, valuePairs);
    }

    private List<Page> queryInfoWithEditToken(User user, String title) {
        Query query = Query.create().prop("info", "revisions").titles(title).intoken("edit");
        return this.query(user, query);
    }

    public List<Page> query(User user, Query query) {
        String response = this.sendXML(user, query);
        try {
            XMLPagesParser xmlPagesParser = new XMLPagesParser(response);
            xmlPagesParser.parse();
            return xmlPagesParser.getPagesList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Page> query(User user, List<String> listOfTitleStrings, String[] valuePairs) {
        try {
            String responseBody = this.queryXML(user, listOfTitleStrings, valuePairs);
            if (responseBody != null) {
                XMLPagesParser parser = new XMLPagesParser(responseBody);
                parser.parse();
                return parser.getPagesList();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return new ArrayList<Page>();
    }

    public String queryXML(User user, String[] valuePairs) {
        return this.queryXML(user, new ArrayList<String>(), valuePairs);
    }

    public String queryXML(User user, List<String> listOfTitleStrings, String[] valuePairs) {
        int i;
        PostMethod method = this.createAuthenticatedPostMethod(user);
        StringBuffer titlesString = new StringBuffer();
        for (i = 0; i < listOfTitleStrings.size(); ++i) {
            titlesString.append(listOfTitleStrings.get(i));
            if (i >= listOfTitleStrings.size() - 1) continue;
            titlesString.append("|");
        }
        method.addParameter(new NameValuePair(PARAM_ACTION, "query"));
        if (titlesString.length() > 0) {
            method.addParameter(new NameValuePair(PARAM_TITLES, titlesString.toString()));
        }
        if (valuePairs != null && valuePairs.length > 0) {
            for (i = 0; i < valuePairs.length; i += 2) {
                method.addParameter(new NameValuePair(valuePairs[i], valuePairs[i + 1]));
            }
        }
        return this.executeHttpMethod((HttpMethod)method);
    }

    public ParseData parse(User user, RequestBuilder requestBuilder) {
        String xmlResponse = this.sendXML(user, requestBuilder);
        if (xmlResponse != null) {
            try {
                XMLParseParser xmlParseParser = new XMLParseParser(xmlResponse);
                xmlParseParser.parse();
                return xmlParseParser.getParse();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void edit(User user, Edit editQuery) throws UnexpectedAnswerException {
        String title = editQuery.get("title");
        if (title == null) return;
        List<Page> pages = this.queryInfoWithEditToken(user, title);
        if (pages == null || pages.size() != 1 || pages.get(0).getPageid() == null) throw new UnexpectedAnswerException("The specified page was not found");
        Page page = pages.get(0);
        if (page.getEditToken() == null) throw new UnexpectedAnswerException("Edit token was not obtained");
        editQuery.token(page.getEditToken());
        String response = this.sendXML(user, editQuery);
        try {
            if (response == null) return;
            XMLEditParser editParser = new XMLEditParser(response);
            editParser.parse();
            ErrorData errorData = editParser.getErrorData();
            if (errorData == null) return;
            UnexpectedAnswerException ex = new UnexpectedAnswerException(errorData.getInfo());
            ex.setErrorData(errorData);
            throw ex;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String sendXML(User user, RequestBuilder requestBuilder) {
        PostMethod method = this.createAuthenticatedPostMethod(user);
        method.addParameters(requestBuilder.getParameters());
        return this.executeHttpMethod((HttpMethod)method);
    }

    private PostMethod createAuthenticatedPostMethod(User user) {
        PostMethod method = new PostMethod(user.getActionUrl());
        method.setFollowRedirects(false);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        method.setRequestHeader("User-Agent", USER_AGENT);
        method.addParameter(new NameValuePair(PARAM_LOGIN_USERNAME, user.getUserid()));
        method.addParameter(new NameValuePair(PARAM_LOGIN_USERID, user.getNormalizedUsername()));
        method.addParameter(new NameValuePair(PARAM_LOGIN_TOKEN, user.getToken()));
        method.addParameter(new NameValuePair(PARAM_FORMAT, "xml"));
        return method;
    }
}

