/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.coll.NamedObjectSet;
import de.memtext.util.DateUtils;
import de.superx.common.DBServletException;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.dbcp.PoolingDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SxPools
extends NamedObjectSet {
    private static Logger logger = LoggerFactory.getLogger(SuperXManager.class);
    private static final long serialVersionUID = 1L;
    private static NamedObjectSet pools = new NamedObjectSet();
    private static boolean hasMandanten = false;

    private SxPools() {
    }

    public static synchronized Connection getConnection(String poolname) throws SQLException {
        if (pools.size() == 0) {
            IllegalStateException e = new IllegalStateException("Kein Datenbank-ConnectionPool gefunden.");
            e.printStackTrace();
            throw e;
        }
        if (!pools.containsItemWithName(poolname)) {
            throw new SQLException("Kein Datenbank-ConnectionPool f\u00fcr Mandant:" + poolname + " gefunden");
        }
        String pooldrv = "jdbc:apache:commons:dbcp:" + poolname;
        if (DriverManager.getDriver(pooldrv) == null) {
            String msg = "Kein Datenbank-ConnectionPool gefunden ";
            if (!poolname.equals("default")) {
                msg = msg + " f\u00fcr Mandant " + poolname;
            }
            throw new SQLException(msg);
        }
        return ((SxPool)pools.getByName(poolname)).getConnection();
    }

    public static boolean hasMandanten() {
        return hasMandanten;
    }

    public static int count() {
        return pools.size();
    }

    public static SxPool get(String poolname) {
        if (!pools.containsItemWithName(poolname)) {
            throw new IllegalStateException("Kein Datenbank-ConnectionPool (" + poolname + ") vorhanden");
        }
        return (SxPool)pools.getByName(poolname);
    }

    public static Collection<String> getMandantenIds() {
        HashSet<String> result = new HashSet<String>();
        Iterator it = pools.iterator();
        while (it.hasNext()) {
            result.add(((SxPool)it.next()).getName());
        }
        return result;
    }

    public static boolean hasPool(String poolname) {
        return pools != null && pools.containsItemWithName(poolname);
    }

    static void initDefaultOnly() throws SQLException, IOException, DBServletException {
        pools.add(new SxPool("default"));
    }

    public static void init() throws SQLException, IOException, DBServletException {
        String mandantenCfg = SuperXManager.getWEB_INFPfad() + File.separator + "mandanten.cfg";
        File f = new File(mandantenCfg);
        if (!f.exists()) {
            logger.debug(DateUtils.getTodayString() + " " + DateUtils.getNowString());
            System.out.print("Aufbau Datenbank-ConnectionPool");
            SxPool connectionPool = new SxPool("default");
            logger.debug(" OK");
            logger.debug("           eingeschr\u00e4nkter Datenbankuser f\u00fcr Verbindung: " + connectionPool.isRestrictedConnection());
            logger.debug("           public/private key" + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv"));
            pools.add(connectionPool);
        } else {
            String line;
            hasMandanten = true;
            FileReader fr = new FileReader(f);
            BufferedReader bfr = new BufferedReader(fr);
            while ((line = bfr.readLine()) != null) {
                System.out.print("Aufbau Datenbank-ConnectionPool f\u00fcr " + line);
                try {
                    SxPool connectionPool = new SxPool(line);
                    logger.debug("OK");
                    logger.debug("           eingeschr\u00e4nkter Datenbankuser f\u00fcr Verbindung: " + connectionPool.isRestrictedConnection());
                    logger.debug("           public/private key" + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv"));
                    pools.add(connectionPool);
                }
                catch (Exception e) {
                    String msg = "ERROR: Verbindung f\u00fcr " + line + " nicht erfolgreich (" + e + ")";
                    System.out.println("ERROR: Verbindung f\u00fcr " + line + " nicht erfolgreich (" + e + ")");
                    logger.info(msg);
                }
            }
            bfr.close();
            fr.close();
        }
    }

    static void closeAll() throws Exception {
        for (SxPool pool : pools) {
            pool.close();
        }
    }

    public static void main(String[] args) {
        try {
            SxPools.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean i = true;
    }

    public static void invalidate(String poolname, Connection con) throws DBServletException {
        if (!pools.containsItemWithName(poolname)) {
            throw new DBServletException("Kann Connection nicht invalidieren - kein Datenbank-ConnectionPool " + poolname + " gefunden.");
        }
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:" + poolname);
            driver.invalidateConnection(con);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBServletException("Invalidating connection failed -" + e);
        }
    }

    public static String getPoolFinRechteInfos() {
        StringBuffer result = new StringBuffer();
        for (SxPool aPool : pools) {
            result.append("Mandant: " + aPool.getName() + " - SxFinRechtevariante:" + aPool.getFinRightVariantName() + "<br>");
        }
        return result.toString();
    }

    public static void resetAllPools() throws TransformerConfigurationException, SQLException, DBServletException {
        for (SxPool aPool : pools) {
            try {
                aPool.init();
            }
            catch (Exception e) {
                logger.debug("ERROR: Datenreset f\u00fcr " + aPool.getName() + " fehlgeschlagen:" + e);
                e.printStackTrace();
            }
        }
        logger.debug(DateUtils.getNowString() + " Alle SuperX-Pools neu geladen");
    }

    public static void clearLogFiles() throws IOException {
        for (SxPool aPool : pools) {
            aPool.clearLogFiles();
        }
    }
}

