/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldXmlEncoder;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.Maske;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.MaskenContainer;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SichtChanger;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class SuperXmlMaske
extends AbstractSuperXServlet {
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String mxr = config.getInitParameter("maxRowsOrganigramm");
        SqlStringUtils.maxRowsOrganigramm = mxr == null || mxr.equals("") ? "4000" : mxr;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SuperXmlMaske.setEncoding(request);
        this.checkCacheClearing(request);
        this.checkAnmeldungImRequest(request);
        if (!this.hasProperSession(request)) {
            this.infoNeuAnmelden(response);
        } else {
            if (SichtChanger.isSichtChangeWanted(request)) {
                SichtChanger s = new SichtChanger(request, response, false);
                s.run(true);
            }
            if (this.isJSONRequest(request)) {
                JSONResponder jr = new JSONResponder(request, response);
                jr.run(true);
            } else if (this.isAjaxRequest(request)) {
                AjaxResponder ar = new AjaxResponder(request, response);
                ar.run(true);
            } else {
                MaskCreator maskCreator = new MaskCreator(request, response);
                maskCreator.run(true);
            }
        }
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        boolean result = false;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String aName = (String)en.nextElement();
            if (!aName.startsWith("getXML_")) continue;
            result = true;
        }
        return result;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJSONRequest(request)) {
            // empty if block
        }
        this.doPost(request, response);
    }

    public String getServletInfo() {
        return "<i>SuperXDBServlet, v.1.2</i>";
    }

    private class MaskCreator
    extends SuperXServletHelper {
        private Hashtable formular;
        private Maske maske;

        MaskCreator(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.formular = new Hashtable();
        }

        @Override
        protected void perform() throws NichtAngemeldetException, TransformerException, ParseException, NumberFormatException, TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            this.userid = this.request.getSession().getAttribute("UserID").toString();
            SxUser user = (SxUser)this.request.getSession().getAttribute("user");
            if (user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            Locale desiredLocale = this.getDesiredLocale();
            this.formular.put("UserID", this.userid);
            this.formular.put("locale", desiredLocale.getLanguage());
            boolean showNavigation = SuperXmlMaske.this.getShowNavigation(this.request);
            TimeUtils t = new TimeUtils();
            t.start();
            String contenttype = null;
            contenttype = ServletHelper.getParameter(this.request, "contenttype");
            if (contenttype == null) {
                contenttype = "text/html";
            }
            String tidStr = SuperXmlMaske.this.getTid(this.request);
            user.checkAuthentificationForMask(tidStr);
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            String cm = ServletHelper.getParameter(this.request, "cachingcontrol");
            if (cm != null && cm.equalsIgnoreCase("clearsessiondefaults")) {
                user.getSelectionBuffer().clear();
            }
            if (cm != null && cm.toLowerCase().equals("reusemask")) {
                this.maske = mc.getMaske(tidStr);
            }
            if (this.maske == null) {
                if (SxPools.get(this.getMandantenID()).hasMaske(new Integer(tidStr))) {
                    this.maske = SxPools.get(this.getMandantenID()).getMaskenclone(new Integer(tidStr));
                    Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINE, "   using mask clone");
                } else {
                    this.maske = new Maske(this.getMandantenID(), user, new Integer(tidStr), desiredLocale);
                }
            }
            this.maske.removeTempFieldItems();
            this.maske.setLocale(desiredLocale);
            this.maske.setFieldDefaults(user, this.request, false);
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, "   Maskenvorbereitung Dauer:" + t.getSinceStart());
            t.start();
            mc.addMaske(this.maske);
            String returnText = "";
            if (contenttype.equalsIgnoreCase("text/xml")) {
                returnText = this.maske.getMaskXml(user, this.getJSessionId(), showNavigation);
                this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
            } else {
                returnText = this.maske.getMaskHtml(user, this.getJSessionId(), showNavigation);
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            }
            returnText = SxPools.get(this.getMandantenID()).localize(returnText, desiredLocale);
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " HTML f\u00fcr Maske Dauer insgesamt: " + t.getSinceStart());
            t.start();
            this.setExpires(600);
            this.sendBackHtml(returnText);
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " schicken der Maske an Client " + t.getSinceStart());
        }
    }

    private class JSONResponder
    extends SuperXServletHelper {
        private Maske maske;
        private SxUser user;

        public JSONResponder(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.user = (SxUser)request.getSession().getAttribute("user");
            this.setAjaxResponder(true);
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, NoMainEntryException, InvalidDataTypeException {
            if (this.user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            this.userid = this.request.getSession().getAttribute("UserID").toString();
            String tidString = SuperXmlMaske.this.getTid(this.request);
            StringBuffer json = new StringBuffer("");
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            this.maske = mc.getMaske(tidString);
            if (this.maske == null) {
                throw new IllegalStateException("Es wurde versucht, per AJAX Feld-XML nachzuladen, ohne, dass die Maske geladen wurde");
            }
            try {
                Enumeration en = this.request.getParameterNames();
                while (en.hasMoreElements()) {
                    String aName = (String)en.nextElement();
                    if (!aName.startsWith("getJSON_")) continue;
                    Field f = this.maske.getField(aName.substring(8));
                    String param = ServletHelper.getParameter(this.request, aName);
                    if (f.getArt() != 12 && !f.isOldOrganigrammArt() && f.isDynamic() && param != null && param.equals("xxxxxx-xxxxxx@")) {
                        f.setInited(false);
                        this.maske.setFieldDefaults(this.user, this.request, false);
                    }
                    if (f.getArt() == 12 && f.getSichtgruppe().hasDynamicSicht() && param.equals("xxxxxx-xxxxxx@")) {
                        this.maske.setFieldDefaults(this.user, this.request, false);
                        this.maske.updateDynamicSichten(f, this.user);
                    }
                    json.append(f.getJSON(param));
                }
            }
            catch (UngueltigeEingabeException e) {
                json.setLength(0);
                json.append("({error:\"" + StringUtils.jsonAdapt(e.getMessage(), true) + "\"})");
            }
            String result = SxPools.get(this.getMandantenID()).localize(json, this.getDesiredLocale());
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINE, "/*" + result + "*/");
            this.sendBack("/*" + result + "*/", "text/json-comment-filtered");
        }

        public void sendNotAuthorized() throws IOException {
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            PrintWriter p = this.response.getWriter();
            String msg = ServletUtils.getJSONErrorText(this.userid, this.getDesiredLocale());
            System.out.println(msg);
            p.print(msg);
            p.close();
        }
    }

    private class AjaxResponder
    extends SuperXServletHelper {
        private Maske maske;
        private SxUser user;
        private StringBuffer xml;

        public AjaxResponder(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.xml = new StringBuffer("<?xml version=\"1.0\"  encoding=\"" + SqlStringUtils.getEncoding() + "\" ?>\n<felder>");
            this.user = (SxUser)request.getSession().getAttribute("user");
            if (this.user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            String tidString = SuperXmlMaske.this.getTid(this.request);
            this.request.setCharacterEncoding("UTF-8");
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            this.maske = mc.getMaske(tidString);
            if (this.maske == null) {
                throw new IllegalStateException("Es wurde versucht, per AJAX Feld-XML nachzuladen, ohne dass die Maske geladen wurde");
            }
            this.maske.setFieldDefaults(this.user, this.request, false);
            Enumeration en = this.request.getParameterNames();
            while (en.hasMoreElements()) {
                String aName = (String)en.nextElement();
                if (!aName.startsWith("getXML_")) continue;
                this.appendXml(aName.substring(7));
            }
            this.xml.append("\n</felder>");
            this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
            this.sendBack(this.xml.toString());
        }

        private void appendXml(String fieldname) {
            Field f = this.maske.getField(fieldname);
            String param = ServletHelper.getParameter(this.request, "getXML_" + fieldname);
            this.xml.append(FieldXmlEncoder.toXml(f, param));
        }
    }
}

