/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.IdObject;
import de.superx.common.SxResultRow;
import java.awt.Color;
import java.awt.Paint;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarRenderer;

public class GraphicFormat
extends IdObject {
    private String charttype;
    private String caption;
    private String captionx;
    private String captiony;
    private String moreAttribs;
    private Integer width;
    private Integer height;
    private boolean isLineXWanted;
    private boolean isLineYWanted;
    private boolean isShowValuesWanted;
    private static final String[] CMDS = new String[]{"IGNOREROWSWITH:", "IGNORECOLNO:", "USEONLYCOLNO:", "USENO:", "FLIPFLOP", "COLOR1:", "COLOR2:", "COLOR3:", "COLOR4:", "COLOR5:", "COLOR6:", "COLOR7:", "COLOR8:", "COLOR9:", "COLOR10:", "COLOR11:", "COLOR12:", "COLOR13:", "COLOR14:", "COLOR15:"};
    private static List CMDS_LIST = Arrays.asList(CMDS);

    public GraphicFormat() {
        String[] add = new String[]{""};
        CMDS_LIST.addAll(Arrays.asList(add));
    }

    public GraphicFormat(SxResultRow aGFRow) {
        this.setId(aGFRow.get(0));
        this.setCharttype((String)aGFRow.get(1));
        this.setCaption((String)aGFRow.get(2));
        this.setWidth((Integer)aGFRow.get(3));
        this.setHeight((Integer)aGFRow.get(4));
        this.setCaptionx((String)aGFRow.get(5));
        this.setCaptiony((String)aGFRow.get(6));
        this.isLineXWanted = (Integer)aGFRow.get(7) == 1;
        this.isLineYWanted = (Integer)aGFRow.get(8) == 1;
        this.isShowValuesWanted = (Integer)aGFRow.get(9) == 1;
        this.setMoreAttribs((String)aGFRow.get(10));
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaptionx() {
        return this.captionx;
    }

    public void setCaptionx(String captionx) {
        this.captionx = captionx;
    }

    public String getCaptiony() {
        return this.captiony;
    }

    public void setCaptiony(String captiony) {
        this.captiony = captiony;
    }

    public String getCharttype() {
        return this.charttype;
    }

    public void setCharttype(String charttype) {
        this.charttype = charttype;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getMoreAttribs() {
        return this.moreAttribs;
    }

    public void setMoreAttribs(String moreattribs) {
        this.moreAttribs = moreattribs;
        if (moreattribs == null) {
            this.moreAttribs = "";
        }
        StringTokenizer st = new StringTokenizer(this.moreAttribs, "|");
        while (st.hasMoreElements()) {
            String aparam = st.nextToken();
            boolean isOk = false;
            int colpos = aparam.indexOf(":");
            isOk = colpos == -1 ? CMDS_LIST.contains(aparam.toUpperCase()) : CMDS_LIST.contains(aparam.substring(0, colpos + 1).toUpperCase());
            if (isOk) continue;
            throw new IllegalArgumentException("GraficFormat " + this.getId() + " enth\u00e4lt ein unbekanntes Attribut: " + aparam + " Spalte moreattribs pr\u00fcfen");
        }
    }

    public boolean isRowWanted(String rowname) {
        boolean result = true;
        for (String element : this.getItems("IGNOREROWSWITH:")) {
            if (rowname.indexOf(element) <= -1) continue;
            result = false;
        }
        return result;
    }

    private List getItems(String type) {
        LinkedList<String> result = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(this.moreAttribs, "|");
        while (st.hasMoreElements()) {
            String param = this.adapt(st.nextToken());
            if (!param.startsWith(type.toUpperCase())) continue;
            result.add(param.substring(type.length()));
        }
        return result;
    }

    public Integer getWidth() {
        return this.width;
    }

    public static void main(String[] args) {
        GraphicFormat f = new GraphicFormat();
        f.setMoreAttribs("ignoreColNo:1|siwthch");
        List li = f.getItems("ignoreColNo:");
        boolean b = li.contains("1");
        boolean i = true;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @Override
    public String toString() {
        return "GraphicFormat Nr " + this.getId() + " caption: " + this.getCaption();
    }

    public boolean isColWanted(int colnr) {
        boolean result = true;
        String colnrStr = "" + colnr;
        if (this.getItems("IGNORECOLNO:").contains(colnrStr)) {
            result = false;
        }
        if (this.hasParam("USEONLYCOLNO:") && !this.getItems("USEONLYCOLNO:").contains(colnrStr)) {
            result = false;
        }
        return result;
    }

    public int getPieChartColumn() {
        int result = 2;
        List l = this.getItems("USENO:");
        if (l.size() > 0) {
            result = Integer.parseInt(l.get(0).toString());
        }
        if (result == 1) {
            throw new IllegalArgumentException("Der Parameter useColNo: bei Graficformat Nr " + this.getId() + " muss >=2 sein");
        }
        return result;
    }

    public boolean isFlipFlopWanted() {
        return this.hasParam("flipFlop");
    }

    boolean hasParam(String param) {
        boolean result = false;
        StringTokenizer st = new StringTokenizer(this.moreAttribs, "|");
        while (st.hasMoreElements()) {
            String aparam = this.adapt(st.nextToken());
            if (!aparam.startsWith(this.adapt(param))) continue;
            result = true;
        }
        return result;
    }

    private String adapt(String param) {
        int colonpos = param.indexOf(":");
        param = colonpos == -1 ? param.toUpperCase() : param.substring(0, colonpos + 1).toUpperCase() + param.substring(colonpos + 1);
        return param;
    }

    public void applyParams(Plot plot) {
        if (plot instanceof CategoryPlot) {
            CategoryPlot cplot = (CategoryPlot)plot;
            cplot.setDomainGridlinesVisible(this.isLineYWanted());
            cplot.setDomainGridlinePosition(CategoryAnchor.END);
            cplot.setRangeGridlinesVisible(this.isLineXWanted());
            cplot.getDomainAxis().setCategoryMargin(0.05);
            if (cplot.getRenderer() instanceof BarRenderer) {
                ((BarRenderer)cplot.getRenderer()).setItemMargin(0.05);
            }
            if (this.isShowValuesWanted) {
                cplot.getRenderer().setItemLabelsVisible(true);
            }
        }
        if (!this.isShowValuesWanted && this.getCharttype().toLowerCase().indexOf("pie") > -1) {
            ((PiePlot)plot).setLabelGenerator(null);
        }
        this.applyColors(plot);
    }

    private void applyColors(Plot plot) {
        StringTokenizer st = new StringTokenizer(this.moreAttribs, "|");
        while (st.hasMoreElements()) {
            String aparam = this.adapt(st.nextToken());
            if (!aparam.startsWith("COLOR")) continue;
            int colpos = aparam.indexOf(":");
            int no = Integer.parseInt(aparam.substring(5, colpos));
            Color c = this.parseColor(aparam.substring(colpos + 1));
            if (plot instanceof CategoryPlot) {
                try {
                    ((CategoryPlot)plot).getRenderer().setSeriesPaint(no - 1, (Paint)c);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (!(plot instanceof PiePlot)) continue;
            try {
                ((PiePlot)plot).setSectionPaint(no, (Paint)c);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    private Color parseColor(String colorDef) {
        Color c = null;
        if (colorDef.indexOf(",") == -1) {
            if (colorDef.indexOf("%") > -1) {
                if (colorDef.trim().endsWith("%")) {
                    colorDef = colorDef.substring(0, colorDef.indexOf("%"));
                }
                int percent = Integer.parseInt(colorDef.substring(4));
                int val = (int)((double)(100 - percent) * 2.55);
                c = new Color(val, val, val);
            } else {
                c = Color.getColor(colorDef);
            }
        } else {
            int[] rgb = new int[3];
            int i = 0;
            StringTokenizer st = new StringTokenizer(colorDef, ",");
            while (st.hasMoreElements()) {
                String element = (String)st.nextElement();
                rgb[i++] = Integer.parseInt(element);
            }
            c = new Color(rgb[0], rgb[1], rgb[2]);
        }
        return c;
    }

    public boolean isLineXWanted() {
        return this.isLineXWanted;
    }

    public boolean isLineYWanted() {
        return this.isLineYWanted;
    }

    public boolean isShowValuesWanted() {
        return this.isShowValuesWanted;
    }
}

