/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.ExceptionHandler;
import de.memtext.util.GetOpts;
import de.superx.bin.FMParser;
import de.superx.bin.SxConnection;
import de.superx.bin.SxDBUtils;
import de.superx.bin.SxJdbcClient;
import de.superx.bin.SxTransformer;
import de.superx.bin.XUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Dosql {
    private static Connection myDb;
    private static Statement st;
    private static boolean done;
    private static String delim;
    private static String header;
    private static String logfile;
    private static String tabelle;
    private static String dbpropfile;
    private static String outfile;
    private static String outFormat;
    private static String _dateiPfad;
    private static Logger logger;
    private static ExceptionHandler exceptionHandler;
    private static String usage;

    public static void instructions() {
        System.out.println("SuperX 5.2\n");
        System.out.println("\nDieses Javaprogramm f\u00fchrt ein beliebiges sql-Script mit einer oder mehr sql-Anweisungen aus");
        System.out.println("Im Classpath muss superx5.2.jar sowie der zugeh\u00f6rige jdbc-Treiber sein.");
        System.out.println("Befehl:\n java dosql <Dateipfad sql-Script> <delimiter>(optional) <Ausgabe der Feld\u00fcberschriften (optional, true oder false).");
        System.out.println("Default:\n java dosql <Dateipfad sql-Script> <TAB> true");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            Dosql.execute(args);
        }
        catch (Exception e) {
            logger.severe("Fehler beim sql-Script: " + _dateiPfad + " " + e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void execute(String[] args) throws Exception {
        File f;
        String params = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-logger,-dbproperties,-sqlfile");
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        if (GetOpts.isPresent("-logger")) {
            logfile = GetOpts.getValue("-logger");
        }
        if (GetOpts.isPresent("-dbproperties")) {
            dbpropfile = GetOpts.getValue("-dbproperties");
        }
        if (GetOpts.isPresent("-sqlfile")) {
            _dateiPfad = GetOpts.getValue("-sqlfile");
        }
        if (GetOpts.isPresent("-outFormat")) {
            outFormat = GetOpts.getValue("-outFormat");
        }
        if (GetOpts.isPresent("-delim")) {
            delim = GetOpts.getValue("-delim");
        }
        if (GetOpts.isPresent("-header")) {
            header = GetOpts.getValue("-header");
        }
        if (GetOpts.isPresent("-outfile")) {
            outfile = GetOpts.getValue("-outfile");
        }
        if (GetOpts.isPresent("-params")) {
            params = GetOpts.getValue("-params");
        }
        if (delim.equals("")) {
            delim = "^";
        }
        if (!(f = new File(logfile)).exists()) {
            throw new IOException("Datei nicht gefunden: " + logfile);
        }
        FileInputStream ins = new FileInputStream(logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        logfile = MyLogManager.getProperty(".level");
        logger.info("Using Loggging-Level " + logfile);
        f = new File(_dateiPfad);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + _dateiPfad);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        String sql = "";
        String text = "";
        while ((text = in.readLine()) != null) {
            sql = sql + System.getProperty("line.separator") + text.trim();
        }
        in.close();
        if (sql.toLowerCase().indexOf("<xupdate>") > -1) {
            SxConnection myConnection = new SxConnection();
            myConnection.setPropfile(dbpropfile);
            Connection con = myConnection.getConnection();
            new XUpdater().execute(con, myConnection.getDatabaseAbbr(), sql, logger);
        } else {
            if (sql.toLowerCase().indexOf("--freemarker template") > -1) {
                try {
                    sql = FMParser.simpleParser(dbpropfile, sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((sql = sql.trim()).startsWith("\"")) {
                sql = sql.substring(1, sql.length());
            }
            if (sql.endsWith("\"")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            logger.config("Inhalt der sql-Datei: \n--" + sql + "--");
            if (!params.equals("")) {
                if (!params.endsWith("|")) {
                    params = params + "|";
                }
                StringTokenizer st = new StringTokenizer(params, "|");
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    if (param.equals("")) continue;
                    String paramname = param.substring(0, param.indexOf("="));
                    String paramvalue = param.substring(param.indexOf("=") + 1, param.length());
                    sql = SxDBUtils.replaceString(sql, paramname, paramvalue);
                }
            }
            SxJdbcClient myClient = new SxJdbcClient(logger, dbpropfile, sql);
            if (outfile.equals("") && outFormat.equalsIgnoreCase("txt")) {
                myClient.setLogAllResultSetsToConsole(true);
            }
            SxTransformer myTransformer = null;
            myClient.Rs_executeALL();
            ResultSet myrs = myClient.getRs();
            if (myrs != null) {
                myTransformer = outfile.equals("") ? new SxTransformer(logger, System.out) : new SxTransformer(logger, new FileWriter(outfile));
                if (!outfile.equals("") || !outFormat.equalsIgnoreCase("txt")) {
                    myTransformer.setDelim(delim);
                    myTransformer.setHeader(header);
                    myTransformer.setOutrs(myrs);
                    myTransformer.setOutrsmd(myClient.getRsmd());
                    myTransformer.printResult(outFormat);
                }
            } else {
                logger.info("Keine R\u00fcckgabewerte aus SQL-Script");
            }
            myClient.close();
        }
        System.out.println("Dosql hat das Script " + _dateiPfad + " erfolgreich durchgef\u00fchrt");
        logger.info("dosql erfolgreich beendet");
    }

    static {
        done = false;
        delim = "^";
        header = "false";
        logfile = "../conf/logging.properties";
        tabelle = "";
        dbpropfile = "../conf/db.properties";
        outfile = "";
        outFormat = "txt";
        _dateiPfad = "";
        logger = Logger.getLogger(Dosql.class.toString());
        exceptionHandler = new ExceptionHandler(false);
        usage = "-------------------------------------\nGebrauch: java de.superx.bin.Dosql -logger=<<Pfad zu logging.properties>> -dbproperties=<<Pfad zu db.properties>> -sqlfile:<Datei mit sql-Ausdr\u00fccken> -params:<Parameter, die in sql- oder Script-Dateien ersetzt werden; Syntax:param1=wert1,param2=wert2 etc> -outFormat:<Ausgabeformat (txt | html | xml)>(optional) -delim:<delimiter> -header:<mit Spalten\u00fcberschriften (true | false)>(optional) -outfile:<Ausgabedatei>(optional) \n---------------------------------------------------";
    }
}

