/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.widgets.WarningMessage;
import java.util.logging.Logger;

public class ExceptionHandler {
    private boolean isApplication = true;
    private WarningMessage warningMessage = new WarningMessage(null, "", "Problem");
    private boolean withGui;
    private boolean isExitWanted;
    private String additionalInfo;
    private Logger logger;

    public ExceptionHandler() {
        this(true, true);
    }

    public ExceptionHandler(boolean withGui) {
        this(withGui, true);
    }

    public ExceptionHandler(boolean withGui, boolean isExitWanted) {
        this.withGui = withGui;
        this.isExitWanted = isExitWanted;
    }

    public void handle(Throwable e) {
        this.handle("", e);
    }

    public void handle(String txt, Throwable e) {
        String msg = e.toString() + " " + txt;
        if (this.additionalInfo != null) {
            msg = msg + "\n" + this.additionalInfo;
        }
        if (this.withGui) {
            this.warningMessage.setMsg(msg);
            this.warningMessage.show();
        }
        System.out.println(msg);
        if (this.logger != null) {
            this.logger.severe(msg);
        }
        e.printStackTrace();
        if (this.isExitWanted) {
            this.doBeforeEnd();
            if (this.isApplication) {
                System.exit(1);
            }
        }
    }

    protected void doBeforeEnd() {
    }

    public boolean isExitWanted() {
        return this.isExitWanted;
    }

    public boolean isWithGui() {
        return this.withGui;
    }

    public void setExitWanted(boolean b) {
        this.isExitWanted = b;
    }

    public void setWithGui(boolean b) {
        this.withGui = b;
    }

    public boolean isApplication() {
        return this.isApplication;
    }

    public void setApplication(boolean b) {
        this.isApplication = b;
    }

    public void clearAdditionalInfo() {
        this.additionalInfo = null;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String info) {
        this.additionalInfo = info;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

