/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree;

import de.memtext.icons.ArrowDownIcon;
import de.memtext.icons.ArrowUpIcon;
import de.memtext.icons.DoubleArrowDownIcon;
import de.memtext.icons.DoubleArrowDownLineIcon;
import de.memtext.icons.DoubleArrowUpIcon;
import de.memtext.icons.DoubleArrowUpLineIcon;
import de.memtext.tree.SelectedNodeAction;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.MBFrame;
import de.memtext.widgets.VerticalBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class SortTreePanel
extends JPanel
implements ActionListener {
    private JTree tree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode parent;
    private DefaultMutableTreeNode movedNode;
    private int oldIndex;
    private int newIndex;
    private JPanel sortPanel = new JPanel(new BorderLayout());
    private VerticalBox sortButtonPanel = new VerticalBox();
    private SelectedNodeAction upmax = new UpMaxAction();
    private SelectedNodeAction up5 = new Up5Action();
    private SelectedNodeAction up1 = new Up1Action();
    private SelectedNodeAction down1 = new Down1Action();
    private SelectedNodeAction down5 = new Down5Action();
    private SelectedNodeAction downmax = new DownMaxAction();
    private JButton btnClose;
    private JButton btnUp1;
    private JButton btnDown1;
    private JButton btnUp5;
    private JButton btnDown5;
    private JButton btnUpMax;
    private JButton btnDownMax;
    private JPanel pnorth;
    private final List actionListeners = new LinkedList();

    public SortTreePanel(JTree tree) {
        super(new BorderLayout());
        this.tree = tree;
        this.treeModel = (DefaultTreeModel)tree.getModel();
        this.add((Component)new JScrollPane(tree), "Center");
        this.btnClose = new JButton("x");
        this.btnClose.setActionCommand("hide sortpanel");
        this.btnClose.setMargin(new Insets(2, 2, 2, 2));
        this.btnClose.addActionListener(this);
        this.pnorth = new JPanel(new FlowLayout(2));
        this.pnorth.add(this.btnClose);
        this.sortPanel.add((Component)this.pnorth, "North");
        tree.addTreeSelectionListener(this.upmax);
        tree.addTreeSelectionListener(this.up5);
        tree.addTreeSelectionListener(this.up1);
        tree.addTreeSelectionListener(this.down1);
        tree.addTreeSelectionListener(this.down5);
        tree.addTreeSelectionListener(this.downmax);
        JLabel lbl1 = new JLabel("T\u00e4tigkeits-", 0);
        JLabel lbl2 = new JLabel("Sortierung", 0);
        this.sortButtonPanel.addGlue();
        this.sortButtonPanel.add(lbl1);
        this.sortButtonPanel.add(lbl2);
        this.sortButtonPanel.addStrut(7);
        this.btnUpMax = new JButton(this.upmax);
        this.sortButtonPanel.add(this.btnUpMax);
        this.sortButtonPanel.addStrut(3);
        this.btnUp5 = new JButton(this.up5);
        this.sortButtonPanel.add(this.btnUp5);
        this.sortButtonPanel.addStrut(3);
        this.btnUp1 = new JButton(this.up1);
        this.sortButtonPanel.add(this.btnUp1);
        this.sortButtonPanel.addStrut(3);
        this.btnDown1 = new JButton(this.down1);
        this.sortButtonPanel.add(this.btnDown1);
        this.sortButtonPanel.addStrut(3);
        this.btnDown5 = new JButton(this.down5);
        this.sortButtonPanel.add(this.btnDown5);
        this.sortButtonPanel.addStrut(3);
        this.btnDownMax = new JButton(this.downmax);
        this.sortButtonPanel.add(this.btnDownMax);
        this.sortButtonPanel.addGlue();
        this.sortPanel.add((Component)this.sortButtonPanel, "Center");
        this.add((Component)this.sortPanel, "East");
        this.setToolTipTexts();
    }

    private void setToolTipTexts() {
        this.btnUp1.setToolTipText("1 nach oben");
        this.btnDown1.setToolTipText("1 nach unten");
        this.btnUp5.setToolTipText("5 nach oben");
        this.btnDown5.setToolTipText("5 nach unten");
        this.btnUpMax.setToolTipText("ganz nach oben");
        this.btnDownMax.setToolTipText("ganz nach unten");
    }

    public void set5Visible(boolean visible) {
        this.btnUp5.setVisible(visible);
        this.btnDown5.setVisible(visible);
    }

    public void setSortPanelVisible(boolean vis) {
        this.sortButtonPanel.setVisible(vis);
        this.pnorth.setVisible(vis);
    }

    public void addAcceptableTreeNodeClass(Class nodeClass) {
        if (nodeClass == null) {
            throw new NullPointerException("Acceptable node class must not be null");
        }
        this.upmax.addAcceptableTreeNodeClass(nodeClass);
        this.up5.addAcceptableTreeNodeClass(nodeClass);
        this.up1.addAcceptableTreeNodeClass(nodeClass);
        this.down1.addAcceptableTreeNodeClass(nodeClass);
        this.down5.addAcceptableTreeNodeClass(nodeClass);
        this.downmax.addAcceptableTreeNodeClass(nodeClass);
    }

    public void removeAcceptableTreeNodeClass(Class nodeClass) {
        this.upmax.removeAcceptableTreeNodeClass(nodeClass);
        this.up5.removeAcceptableTreeNodeClass(nodeClass);
        this.up1.removeAcceptableTreeNodeClass(nodeClass);
        this.down1.removeAcceptableTreeNodeClass(nodeClass);
        this.down5.removeAcceptableTreeNodeClass(nodeClass);
        this.downmax.removeAcceptableTreeNodeClass(nodeClass);
    }

    public void nodeMoved() {
    }

    public DefaultMutableTreeNode getParentNode() {
        return this.parent;
    }

    public int getNewIndex() {
        return this.newIndex;
    }

    public int getOldIndex() {
        return this.oldIndex;
    }

    public DefaultMutableTreeNode getMovedNode() {
        return this.movedNode;
    }

    public static void main(String[] a) {
        MBFrame f = new MBFrame();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode aa = new DefaultMutableTreeNode("a");
        DefaultMutableTreeNode a1 = new DefaultMutableTreeNode("a1");
        DefaultMutableTreeNode a2 = new DefaultMutableTreeNode("a2");
        DefaultMutableTreeNode a3 = new DefaultMutableTreeNode("a3");
        DefaultMutableTreeNode a4 = new DefaultMutableTreeNode("a4");
        DefaultMutableTreeNode a5 = new DefaultMutableTreeNode("a5");
        DefaultMutableTreeNode a6 = new DefaultMutableTreeNode("a6");
        DefaultMutableTreeNode a7 = new DefaultMutableTreeNode("a7");
        aa.add(a1);
        aa.add(a2);
        aa.add(a3);
        aa.add(a4);
        aa.add(a5);
        aa.add(a6);
        aa.add(a7);
        DefaultMutableTreeNode b = new DefaultMutableTreeNode("b");
        DefaultMutableTreeNode c = new DefaultMutableTreeNode("c");
        DefaultMutableTreeNode d = new DefaultMutableTreeNode("d");
        DefaultMutableTreeNode e = new DefaultMutableTreeNode("e");
        DefaultMutableTreeNode ff = new DefaultMutableTreeNode("f");
        root.add(aa);
        root.add(b);
        root.add(c);
        root.add(d);
        root.add(e);
        root.add(ff);
        f.getContentPane().add(new SortTreePanel(new JTree(root)));
        f.setSize(700, 500);
        WindowUtils.center(f);
        f.show();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("hide sortpanel")) {
            this.setSortPanelVisible(false);
        }
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(ae);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.pnorth != null) {
            this.pnorth.setBackground(c);
        }
        if (this.sortPanel != null) {
            this.sortPanel.setBackground(c);
        }
        if (this.sortButtonPanel != null) {
            this.sortButtonPanel.setBackground(c);
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    class DownMaxAction
    extends NodeNavigateAction {
        public DownMaxAction() {
            super(" max", new DoubleArrowDownLineIcon());
        }

        @Override
        protected void checkAcceptable() {
            if (this.isEnabled()) {
                this.setEnabled(this.getIndexOfSelection() < this.getMaxPossibleIndexOfSelection());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.moveSelectedNode(this.getMaxPossibleIndexOfSelection() - this.getIndexOfSelection());
        }
    }

    class Down5Action
    extends NodeNavigateAction {
        public Down5Action() {
            super(" 5  ", new DoubleArrowDownIcon());
        }

        @Override
        protected void checkAcceptable() {
            if (this.isEnabled()) {
                this.setEnabled(this.getIndexOfSelection() + 5 <= this.getMaxPossibleIndexOfSelection());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.moveSelectedNode(5);
        }
    }

    class Down1Action
    extends NodeNavigateAction {
        public Down1Action() {
            super(" 1  ", new ArrowDownIcon());
        }

        @Override
        protected void checkAcceptable() {
            if (this.isEnabled()) {
                this.setEnabled(this.getIndexOfSelection() + 1 <= this.getMaxPossibleIndexOfSelection());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.moveSelectedNode(1);
        }
    }

    class Up1Action
    extends NodeNavigateAction {
        public Up1Action() {
            super(" 1  ", new ArrowUpIcon());
        }

        @Override
        protected void checkAcceptable() {
            if (this.isEnabled()) {
                this.setEnabled(this.getIndexOfSelection() > 0);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.moveSelectedNode(-1);
        }
    }

    class Up5Action
    extends NodeNavigateAction {
        public Up5Action() {
            super(" 5  ", new DoubleArrowUpIcon());
        }

        @Override
        protected void checkAcceptable() {
            if (this.isEnabled()) {
                this.setEnabled(this.getIndexOfSelection() > 4);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.moveSelectedNode(-5);
        }
    }

    class UpMaxAction
    extends NodeNavigateAction {
        public UpMaxAction() {
            super(" max", new DoubleArrowUpLineIcon());
        }

        @Override
        protected void checkAcceptable() {
            if (this.isEnabled()) {
                this.setEnabled(this.getIndexOfSelection() > 0);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.moveSelectedNode(this.getIndexOfSelection() * -1);
        }
    }

    abstract class NodeNavigateAction
    extends SelectedNodeAction {
        public NodeNavigateAction(String name) {
            this(name, null);
        }

        public NodeNavigateAction(Icon icon) {
            this(null, icon);
        }

        public NodeNavigateAction(String name, Icon icon) {
            super(name, icon);
        }

        DefaultMutableTreeNode getParentOfSelection() {
            return (DefaultMutableTreeNode)this.getSelectedNode().getParent();
        }

        int getIndexOfSelection() {
            if (((DefaultMutableTreeNode)this.getSelectedNode()).isRoot()) {
                return -1;
            }
            return this.getSelectedNode().getParent().getIndex(this.getSelectedNode());
        }

        int getMaxPossibleIndexOfSelection() {
            if (((DefaultMutableTreeNode)this.getSelectedNode()).isRoot()) {
                return -1;
            }
            return this.getParentOfSelection().getChildCount() - 1;
        }

        void moveSelectedNode(int offset) {
            int[] selrows = SortTreePanel.this.tree.getSelectionRows();
            SortTreePanel.this.oldIndex = this.getIndexOfSelection();
            SortTreePanel.this.newIndex = SortTreePanel.this.oldIndex + offset;
            SortTreePanel.this.parent = this.getParentOfSelection();
            SortTreePanel.this.movedNode = (DefaultMutableTreeNode)this.getSelectedNode();
            SortTreePanel.this.movedNode.removeFromParent();
            SortTreePanel.this.parent.insert(SortTreePanel.this.movedNode, SortTreePanel.this.newIndex);
            SortTreePanel.this.treeModel.nodeStructureChanged(SortTreePanel.this.parent);
            SortTreePanel.this.tree.setSelectionInterval(selrows[0] + offset, selrows[0] + offset);
            SortTreePanel.this.nodeMoved();
        }
    }
}

