/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.db.DB;
import de.memtext.util.StringUtils;

public class ProcedureSql {
    private DB dbsystem;
    private boolean isAddPossible = true;
    private boolean isNameSet;
    private boolean isFinished;
    private String finalSelect = "";
    private StringBuffer result = new StringBuffer();

    public ProcedureSql(DB db) {
        this.dbsystem = db;
        if (this.dbsystem.equals(DB.INFORMIX)) {
            this.result.append("execute procedure ");
        }
        if (this.dbsystem.equals(DB.POSTGRES)) {
            this.result.append("select ");
        }
    }

    public ProcedureSql(DB dbsystem, String procname) {
        this(dbsystem);
        this.result.append(procname + "(");
        this.isNameSet = true;
    }

    public void setName(String procName) {
        if (this.isNameSet) {
            throw new IllegalStateException("Name wurde schon gesetzt");
        }
        this.result.append(procName + "(");
        this.isNameSet = true;
    }

    public void addParam(String param) {
        if (!this.isAddPossible) {
            throw new IllegalStateException("kann keine Parameter hinzuf\u00fcgen, vielleicht wurde getFinishedCall schon aufgerufen");
        }
        this.result.append(param + ",");
    }

    public void addDateParam(String param) {
        if (!this.isAddPossible) {
            throw new IllegalStateException("kann keine Parameter hinzuf\u00fcgen, vielleicht wurde getFinishedCall schon aufgerufen");
        }
        if (this.dbsystem.equals(DB.INFORMIX)) {
            this.result.append("date");
        }
        if (this.dbsystem.equals(DB.POSTGRES)) {
            this.result.append("date_val");
        }
        this.result.append("('" + param + "'),");
    }

    public void setFinalSelect(String sel) {
        this.finalSelect = sel;
    }

    public String getFinishedCall() {
        if (!this.isFinished) {
            this.finish();
        }
        return this.result.toString();
    }

    private void finish() {
        this.addClosingBracket();
        this.result.append(this.finalSelect);
        this.isAddPossible = false;
        this.isFinished = true;
    }

    private void addClosingBracket() {
        char lc = this.result.charAt(this.result.length() - 1);
        if (lc == ',') {
            StringUtils.deleteLastChar(this.result);
        }
        this.result.append(");");
    }

    public void addParam(Integer integer) {
        this.addParam(integer.toString());
    }

    public void addParam(int in) {
        this.addParam(new Integer(in).toString());
    }

    public void addParam(Object param) {
        this.addParam(param.toString());
    }

    public static void main(String[] args) {
        ProcedureSql p = new ProcedureSql(DB.POSTGRES, "test");
        p.addParam(23);
        System.out.println(p.getFinishedCall());
    }
}

