/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.util.CryptUtils;
import de.memtext.util.PropUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionCreator {
    public static void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(0);
        }
    }

    public static Connection getConnection(String url, String username, String passwd) throws SQLException {
        return DriverManager.getConnection(url, username, passwd);
    }

    public static Connection getConnection(String driver, String url, String username, String passwd) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        return ConnectionCreator.getConnection(url, username, passwd);
    }

    public static Connection getConnectionQuitOnException(String driver, String url, String username, String passwd) {
        Connection con = null;
        try {
            con = ConnectionCreator.getConnection(driver, url, username, passwd);
        }
        catch (Exception e) {
            System.out.println("Couldn't create connection to database " + url + "\n" + e.toString());
            System.exit(-1);
        }
        return con;
    }

    public static Connection getConnection(String propfilename, String driverkey, String urlkey, String usernamekey, String passwordkey) throws IOException, SQLException, ClassNotFoundException {
        Properties props = PropUtils.getProps(propfilename);
        String driver = PropUtils.getProperty(props, driverkey);
        String url = PropUtils.getProperty(props, urlkey);
        String username = PropUtils.getProperty(props, usernamekey);
        String passwd = PropUtils.getProperty(props, passwordkey);
        return ConnectionCreator.getConnection(driver, url, username, passwd);
    }

    public static Connection getConnection(String propfilename) throws IOException, SQLException, ClassNotFoundException {
        return ConnectionCreator.getConnection(propfilename, "driver", "url", "username", "password");
    }

    public static Connection getConnectionCryptPassword(String propfilename, String driverkey, String urlkey, String usernamekey, String passwordkey) throws IOException, SQLException, ClassNotFoundException {
        Properties props = PropUtils.getProps(propfilename);
        String driver = PropUtils.getProperty(props, driverkey);
        String url = PropUtils.getProperty(props, urlkey);
        String username = PropUtils.getProperty(props, usernamekey);
        String passwd = PropUtils.getProperty(props, passwordkey);
        if (passwd.startsWith("sx_des")) {
            try {
                passwd = CryptUtils.decryptStringDES(passwd.substring(6));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException("DES-Passwort konnte nicht entschl\u00fcsselt werden");
            }
        }
        return ConnectionCreator.getConnection(driver, url, username, passwd);
    }
}

