/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.sql;

import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLGate {
    private int connectionCounter = 0;
    private static int statementCounter = 0;
    private static int preparedStatementCounter = 0;
    private static int callableStatementCounter = 0;
    private String url = null;
    private String user = null;
    private String pw = null;
    private String driver = null;
    private Connection con = null;

    public SQLGate(String _driver, String _url, String _user, String _pw) {
        this.url = _url;
        this.user = _user;
        this.pw = _pw;
        this.driver = _driver;
    }

    public Connection getConnection() {
        if (this.connectionCounter == 0) {
            try {
                System.err.println("Benutzte DB: " + this.url + " mit " + this.driver);
                Class.forName(this.driver);
                this.con = DriverManager.getConnection(this.url, this.user, this.pw);
                this.connectionCounter = 1;
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        } else {
            ++this.connectionCounter;
        }
        return this.con;
    }

    public void commit(Connection _con) {
        try {
            _con.commit();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void rollback(Connection _con) {
        try {
            _con.rollback();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void setAutoCommit(Connection _con, boolean value) {
        try {
            _con.setAutoCommit(value);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void enableAutoCommit(Connection _con) {
        this.setAutoCommit(_con, true);
    }

    public void disableAutoCommit(Connection _con) {
        this.setAutoCommit(_con, false);
    }

    public void closeConnection() {
        try {
            if (this.connectionCounter == 1) {
                this.con.close();
                this.con = null;
                this.connectionCounter = 0;
            } else {
                --this.connectionCounter;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.con = null;
        }
    }

    public Statement createStatement(Connection _con) {
        Statement stmt = null;
        try {
            stmt = _con.createStatement();
            ++statementCounter;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(Connection _con, String _sql) {
        PreparedStatement stmt = null;
        try {
            stmt = _con.prepareStatement(_sql);
            ++preparedStatementCounter;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return stmt;
    }

    public void close(Statement _stmt) {
        if (_stmt == null) {
            return;
        }
        try {
            _stmt.close();
            if (_stmt instanceof PreparedStatement) {
                --preparedStatementCounter;
            } else if (_stmt instanceof CallableStatement) {
                --callableStatementCounter;
            } else {
                --statementCounter;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public boolean execute(Statement _stmt, String _sql) {
        boolean ok = false;
        try {
            ok = _stmt.execute(_sql);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ok = false;
        }
        return ok;
    }

    public ResultSet executeQuery(PreparedStatement _stmt) {
        ResultSet rs = null;
        try {
            rs = _stmt.executeQuery();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            rs = null;
        }
        return rs;
    }

    public ResultSet executeQuery(Statement _stmt, String _sql) {
        ResultSet rs = null;
        try {
            rs = _stmt.executeQuery(_sql);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            rs = null;
        }
        return rs;
    }

    public int executeUpdate(Statement _stmt, String _sql) {
        int rownumber = 0;
        try {
            rownumber = _stmt.executeUpdate(_sql);
            this.commit(this.con);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return rownumber;
    }

    public int executeModifiedUpdate(Statement _stmt, String _sql) {
        int ret;
        block2: {
            ret = 0;
            try {
                _stmt.executeUpdate(_sql);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1) break block2;
                ret = -1;
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public boolean next(ResultSet _rs) {
        boolean ok = false;
        try {
            ok = _rs.next();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return ok;
    }

    public int findColumn(ResultSet _rs, String _column) {
        int index = -1;
        try {
            index = _rs.findColumn(_column);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return index;
    }

    public ResultSetMetaData getMetaData(ResultSet _rs) {
        ResultSetMetaData rsmd = null;
        try {
            rsmd = _rs.getMetaData();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            rsmd = null;
        }
        return rsmd;
    }

    public String getString(ResultSet _rs, int _position) {
        String value = null;
        try {
            value = _rs.getString(_position);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            value = null;
        }
        return value;
    }

    public String getString(ResultSet _rs, String _columnName) {
        if (_columnName == null) {
            return null;
        }
        String value = null;
        try {
            value = _rs.getString(_columnName);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            value = null;
        }
        return value;
    }

    public int getInt(ResultSet _rs, int _position) {
        int value = -1;
        try {
            value = _rs.getInt(_position);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            value = -1;
        }
        return value;
    }

    public int getInt(ResultSet _rs, String _column) {
        int value = -1;
        try {
            value = _rs.getInt(_column);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            value = -1;
        }
        return value;
    }

    public int countSearch(String _query) {
        Statement stmt = this.createStatement(this.con);
        ResultSet rs = this.executeQuery(stmt, _query);
        int counter = 0;
        try {
            if (rs.next()) {
                counter = Integer.parseInt(this.getString(rs, "COUNTER"));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            counter = 0;
        }
        this.close(stmt);
        return counter;
    }

    public String getColumnName(ResultSetMetaData _rsmd, int _position) {
        String value = null;
        try {
            value = _rsmd.getColumnName(_position);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            value = null;
        }
        return value;
    }

    public int getColumnCount(ResultSetMetaData _rsmd) {
        int value = -1;
        try {
            value = _rsmd.getColumnCount();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            value = -1;
        }
        return value;
    }

    public int getColumnType(ResultSetMetaData _rsmd, int _index) {
        int value = -1;
        try {
            value = _rsmd.getColumnType(_index);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            value = -1;
        }
        return value;
    }

    public void defineColumnType(Statement _stmt, int _position) {
    }

    public int computeMax(String index, String tableName) {
        int max = -1;
        String newSelect = new String("select max(" + index + ") from " + tableName);
        Statement stmtTmp = this.createStatement(this.con);
        ResultSet rsTmp = this.executeQuery(stmtTmp, newSelect);
        boolean ok = this.next(rsTmp);
        if (ok) {
            max = this.getInt(rsTmp, 1);
            ++max;
        } else {
            max = 1;
        }
        this.close(stmtTmp);
        stmtTmp = null;
        return max;
    }

    public static int[] getStatementCounters() {
        int[] counters = new int[]{statementCounter, preparedStatementCounter, callableStatementCounter};
        return counters;
    }

    public void executeScript(Connection connection, Reader reader) {
        StringBuffer buffer = new StringBuffer();
        try {
            int read = reader.read();
            while (read != -1) {
                char character = (char)read;
                switch (character) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (buffer.length() <= 0 || buffer.charAt(buffer.length() - 1) == ' ') break;
                        buffer.append(character);
                        break;
                    }
                    case ';': {
                        if (buffer.length() <= 0) break;
                        Statement statement = this.createStatement(connection);
                        this.executeUpdate(statement, buffer.toString());
                        statement.close();
                        buffer.delete(0, buffer.length());
                        break;
                    }
                    default: {
                        buffer.append(character);
                    }
                }
                read = reader.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

