/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CipherPacker;
import de.werum.sis.crypt.CryptProperties;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class EncryptHybridOutputStream
extends OutputStream {
    private CipherOutputStream secureOut;
    private CryptProperties properties;

    public EncryptHybridOutputStream(OutputStream out, CryptProperties properties, boolean usePrivateKey) throws GeneralSecurityException, IOException {
        if (out == null) {
            throw new IllegalArgumentException("out ist erforderlich.");
        }
        this.properties = properties;
        if (this.properties == null) {
            throw new IllegalArgumentException("properties ist erforderlich.");
        }
        Integer userId = this.properties.getEncryptPackagingUserId();
        KeyGenerator keyGen = KeyGenerator.getInstance(this.properties.getSymetricAlgorithm(userId), this.properties.getProviderName(userId));
        Integer symmetricKeySize = this.properties.getSymmetricKeySize(userId);
        if (symmetricKeySize != null) {
            keyGen.init(symmetricKeySize);
        }
        SecretKey symmetricKey = keyGen.generateKey();
        SecureRandom secRand = this.properties.getSecureRandom();
        if (secRand == null) {
            secRand = new SecureRandom();
        }
        Cipher symmetricCipher = Cipher.getInstance(this.properties.getSymetricAlgorithmComplete(userId), this.properties.getProviderName(userId));
        symmetricCipher.init(1, (Key)symmetricKey, secRand);
        CipherPacker cipherPacker = new CipherPacker(this.properties);
        cipherPacker.packCipherHybrid(out, symmetricKey, symmetricCipher, usePrivateKey, null);
        this.secureOut = new CipherOutputStream(new BufferedOutputStream(out), symmetricCipher);
    }

    public void write(int b) throws IOException {
        this.secureOut.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.secureOut.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.secureOut.write(b, off, len);
    }

    public void close() throws IOException {
        if (this.secureOut != null) {
            this.secureOut.close();
            this.secureOut = null;
        }
    }
}

