/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFBedingung;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.parser.ConditionParser;
import de.statspez.sdf.generator.parser.IdentifierParser;
import de.statspez.sdf.generator.parser.IncludeVariableGroupParser;
import de.statspez.sdf.generator.parser.IncludeVariableParser;
import de.statspez.sdf.generator.parser.PreconditionParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataGroupParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private IdentifierParser identifierParser;
    private ConditionParser conditionParser;
    private PreconditionParser preconditionParser;
    private IncludeVariableParser includeVariableParser;
    private IncludeVariableGroupParser includeVariableGroupParser;
    private MetaSDFAusgabegruppe ausgabegruppe;
    private String[] dimensionVariables;
    private HashMap identifiers;

    public DataGroupParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.identifierParser = new IdentifierParser(this, resolver);
        this.parserChain.addParser((SubParser)this.identifierParser);
        this.conditionParser = new ConditionParser(this, resolver);
        this.parserChain.addParser((SubParser)this.conditionParser);
        this.preconditionParser = new PreconditionParser(this, resolver);
        this.parserChain.addParser((SubParser)this.preconditionParser);
        this.includeVariableParser = new IncludeVariableParser(this, resolver);
        this.parserChain.addParser((SubParser)this.includeVariableParser);
        this.includeVariableGroupParser = new IncludeVariableGroupParser(this, resolver);
        this.parserChain.addParser((SubParser)this.includeVariableGroupParser);
        this.ausgabegruppe = null;
        this.dimensionVariables = null;
        this.identifiers = new HashMap();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("dataGroup".equalsIgnoreCase(localName)) {
            String maxOccurs;
            String minOccurs;
            String name = atts.getValue("name");
            if (name == null) {
                throw new MetaParseException("Gruppenname nicht definiert!");
            }
            this.ausgabegruppe.setName(SDFTags.dekodiereXMLName(name));
            String dimVariables = atts.getValue("dimension-variables");
            if (dimVariables != null) {
                this.dimensionVariables = dimVariables.split(" ");
                int i = 0;
                while (i < this.dimensionVariables.length) {
                    this.dimensionVariables[i] = SDFTags.dekodiereXMLName(this.dimensionVariables[i]);
                    ++i;
                }
            }
            if ((minOccurs = atts.getValue("minimum-occurrences")) != null) {
                this.ausgabegruppe.setMinimaleAnzahl(minOccurs);
            }
            if ((maxOccurs = atts.getValue("maximum-occurrences")) != null) {
                this.ausgabegruppe.setMaximaleAnzahl(maxOccurs);
            }
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("dataGroup".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("dataGroup".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSDF(namespaceURI);
            this.ausgabegruppe = new MetaSDFAusgabegruppe();
            this.ausgabegruppe.setAttributDaten((short)1);
            this.dimensionVariables = null;
            this.identifiers.clear();
            this.enable();
        } else if ("identifiers".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSDF(namespaceURI);
        } else if ("conditions".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            if ("description".equalsIgnoreCase(localName)) {
                ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            } else if ("annotation".equalsIgnoreCase(localName)) {
                ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            } else {
                throw MetaParseException.unknownTagException((String)localName);
            }
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("dataGroup".equalsIgnoreCase(localName)) {
            boolean resolved = true;
            if (this.dimensionVariables != null && this.dimensionVariables.length > 0) {
                int i = 0;
                while (i < this.dimensionVariables.length) {
                    resolved = false;
                    Iterator variables = this.ausgabegruppe.getSDFFeldReferenzen();
                    while (variables != null && variables.hasNext() && !resolved) {
                        MetaCustomSDFFeldReferenz variable = (MetaCustomSDFFeldReferenz)variables.next();
                        if (!variable.getReferenceName().equals(this.dimensionVariables[i])) continue;
                        variable.setIstDimension(true);
                        resolved = true;
                    }
                    ++i;
                }
            }
            if (!resolved) {
                throw new MetaParseException("Dimensionvariable nicht definiert!");
            }
            Iterator iter = this.identifiers.keySet().iterator();
            while (iter != null && iter.hasNext() && resolved) {
                String referenceName = (String)iter.next();
                resolved = false;
                Iterator variables = this.ausgabegruppe.getSDFFeldReferenzen();
                while (variables != null && variables.hasNext() && !resolved) {
                    MetaCustomSDFFeldReferenz variable = (MetaCustomSDFFeldReferenz)variables.next();
                    if (!variable.getReferenceName().equals(referenceName)) continue;
                    variable.setVorgabeWert((String)this.identifiers.get(referenceName));
                    variable.setVorgabeWertAenderbar(false);
                    resolved = true;
                }
                if (resolved) continue;
                throw new MetaParseException("Identifier nicht definiert!");
            }
            this.disableAndNotify();
        } else if (!("identifiers".equalsIgnoreCase(localName) || "conditions".equalsIgnoreCase(localName) || this.parserChain.endElement(namespaceURI, localName, qName) || "description".equalsIgnoreCase(localName) || "annotation".equalsIgnoreCase(localName))) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.ausgabegruppe;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.identifierParser) {
            this.identifiers.put(this.identifierParser.getReferenceName(), this.identifierParser.getValue());
        } else if (aParser == this.conditionParser) {
            Iterator iter = this.conditionParser.getConditions();
            while (iter != null && iter.hasNext()) {
                this.ausgabegruppe.addToSDFBedingungen((MetaSDFBedingung)iter.next());
            }
        } else if (aParser == this.preconditionParser) {
            Iterator iter = this.preconditionParser.getConditions();
            while (iter != null && iter.hasNext()) {
                this.ausgabegruppe.addToSDFBedingungen((MetaSDFBedingung)iter.next());
            }
        } else {
            this.ausgabegruppe.addToSDFFeldReferenzen((MetaSDFFeldReferenz)aParser.object());
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

